/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.nio.file.Path;
import org.elasticsearch.common.io.DiskIoBufferPool;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.OperationListener;

public final class TranslogConfig {
    public static final ByteSizeValue DEFAULT_BUFFER_SIZE = new ByteSizeValue(1L, ByteSizeUnit.MB);
    public static final ByteSizeValue EMPTY_TRANSLOG_BUFFER_SIZE = ByteSizeValue.ofBytes(10L);
    private final BigArrays bigArrays;
    private final DiskIoBufferPool diskIoBufferPool;
    private final IndexSettings indexSettings;
    private final ShardId shardId;
    private final Path translogPath;
    private final ByteSizeValue bufferSize;
    private final OperationListener operationListener;

    public TranslogConfig(ShardId shardId, Path translogPath, IndexSettings indexSettings, BigArrays bigArrays) {
        this(shardId, translogPath, indexSettings, bigArrays, DEFAULT_BUFFER_SIZE, DiskIoBufferPool.INSTANCE);
    }

    TranslogConfig(ShardId shardId, Path translogPath, IndexSettings indexSettings, BigArrays bigArrays, ByteSizeValue bufferSize, DiskIoBufferPool diskIoBufferPool) {
        this(shardId, translogPath, indexSettings, bigArrays, bufferSize, diskIoBufferPool, (d, s, l) -> {});
    }

    public TranslogConfig(ShardId shardId, Path translogPath, IndexSettings indexSettings, BigArrays bigArrays, ByteSizeValue bufferSize, DiskIoBufferPool diskIoBufferPool, OperationListener operationListener) {
        this.bufferSize = bufferSize;
        this.indexSettings = indexSettings;
        this.shardId = shardId;
        this.translogPath = translogPath;
        this.bigArrays = bigArrays;
        this.diskIoBufferPool = diskIoBufferPool;
        this.operationListener = operationListener;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public BigArrays getBigArrays() {
        return this.bigArrays;
    }

    public Path getTranslogPath() {
        return this.translogPath;
    }

    public ByteSizeValue getBufferSize() {
        return this.bufferSize;
    }

    public DiskIoBufferPool getDiskIoBufferPool() {
        return this.diskIoBufferPool;
    }

    public OperationListener getOperationListener() {
        return this.operationListener;
    }
}

