/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class StringStoredFieldFieldLoader
implements SourceLoader.SyntheticFieldLoader {
    private final String name;
    private final String simpleName;
    private List<Object> values = Collections.emptyList();
    @Nullable
    private final String extraStoredName;
    private List<Object> extraValues = Collections.emptyList();

    public StringStoredFieldFieldLoader(String name, String simpleName, @Nullable String extraStoredName) {
        this.name = name;
        this.simpleName = simpleName;
        this.extraStoredName = extraStoredName;
    }

    @Override
    public final Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
        Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> standard = Stream.of(Map.entry(this.name, values -> {
            this.values = values;
        }));
        if (this.extraStoredName == null) {
            return standard;
        }
        return Stream.concat(standard, Stream.of(Map.entry(this.extraStoredName, values -> {
            this.extraValues = values;
        })));
    }

    @Override
    public final boolean hasValue() {
        return !this.values.isEmpty() || !this.extraValues.isEmpty();
    }

    @Override
    public final void write(XContentBuilder b) throws IOException {
        int size = this.values.size() + this.extraValues.size();
        switch (size) {
            case 0: {
                return;
            }
            case 1: {
                b.field(this.simpleName);
                if (this.values.size() > 0) {
                    assert (this.values.size() == 1);
                    assert (this.extraValues.isEmpty());
                    this.write(b, this.values.get(0));
                } else {
                    assert (this.values.isEmpty());
                    assert (this.extraValues.size() == 1);
                    this.write(b, this.extraValues.get(0));
                }
                this.values = Collections.emptyList();
                this.extraValues = Collections.emptyList();
                return;
            }
        }
        b.startArray(this.simpleName);
        for (Object value : this.values) {
            this.write(b, value);
        }
        for (Object value : this.extraValues) {
            this.write(b, value);
        }
        b.endArray();
        this.values = Collections.emptyList();
        this.extraValues = Collections.emptyList();
    }

    protected abstract void write(XContentBuilder var1, Object var2) throws IOException;

    @Override
    public final SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader reader, int[] docIdsInLeaf) throws IOException {
        return null;
    }
}

