/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.VersionFieldMapper;
import org.elasticsearch.xcontent.XContentType;

public class ParsedDocument {
    private final Field version;
    private final String id;
    private final SeqNoFieldMapper.SequenceIDFields seqID;
    private final String routing;
    private final List<LuceneDocument> documents;
    private BytesReference source;
    private XContentType xContentType;
    private Mapping dynamicMappingsUpdate;

    public static ParsedDocument noopTombstone(String reason) {
        LuceneDocument document = new LuceneDocument();
        SeqNoFieldMapper.SequenceIDFields seqIdFields = SeqNoFieldMapper.SequenceIDFields.tombstone();
        seqIdFields.addFields(document);
        Field versionField = VersionFieldMapper.versionField();
        document.add((IndexableField)versionField);
        BytesRef byteRef = new BytesRef((CharSequence)reason);
        document.add((IndexableField)new StoredField("_source", byteRef.bytes, byteRef.offset, byteRef.length));
        return new ParsedDocument(versionField, seqIdFields, "", null, Collections.singletonList(document), new BytesArray("{}"), XContentType.JSON, null);
    }

    public static ParsedDocument deleteTombstone(String id) {
        LuceneDocument document = new LuceneDocument();
        SeqNoFieldMapper.SequenceIDFields seqIdFields = SeqNoFieldMapper.SequenceIDFields.tombstone();
        seqIdFields.addFields(document);
        Field versionField = VersionFieldMapper.versionField();
        document.add((IndexableField)versionField);
        document.add((IndexableField)IdFieldMapper.standardIdField(id));
        return new ParsedDocument(versionField, seqIdFields, id, null, Collections.singletonList(document), new BytesArray("{}"), XContentType.JSON, null);
    }

    public ParsedDocument(Field version, SeqNoFieldMapper.SequenceIDFields seqID, String id, String routing, List<LuceneDocument> documents, BytesReference source, XContentType xContentType, Mapping dynamicMappingsUpdate) {
        this.version = version;
        this.seqID = seqID;
        this.id = id;
        this.routing = routing;
        this.documents = documents;
        this.source = source;
        this.dynamicMappingsUpdate = dynamicMappingsUpdate;
        this.xContentType = xContentType;
    }

    public String id() {
        return this.id;
    }

    public Field version() {
        return this.version;
    }

    public void updateSeqID(long seqNo, long primaryTerm) {
        this.seqID.set(seqNo, primaryTerm);
    }

    public String routing() {
        return this.routing;
    }

    public LuceneDocument rootDoc() {
        return this.documents.get(this.documents.size() - 1);
    }

    public List<LuceneDocument> docs() {
        return this.documents;
    }

    public BytesReference source() {
        return this.source;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    public void setSource(BytesReference source, XContentType xContentType) {
        this.source = source;
        this.xContentType = xContentType;
    }

    public Mapping dynamicMappingsUpdate() {
        return this.dynamicMappingsUpdate;
    }

    public void addDynamicMappingsUpdate(Mapping update) {
        this.dynamicMappingsUpdate = this.dynamicMappingsUpdate == null ? update : this.dynamicMappingsUpdate.merge(update, MapperService.MergeReason.MAPPING_AUTO_UPDATE, Long.MAX_VALUE);
    }

    public String toString() {
        return "Document id[" + this.id + "] doc [" + this.documents + "]";
    }

    public String documentDescription() {
        return "id";
    }
}

