/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.script.IpFieldScript;

public class IpScriptBlockDocValuesReader
extends BlockDocValuesReader {
    private final IpFieldScript script;
    private int docId;

    IpScriptBlockDocValuesReader(IpFieldScript script) {
        this.script = script;
    }

    @Override
    public int docId() {
        return this.docId;
    }

    @Override
    public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs) throws IOException {
        try (BlockLoader.BytesRefBuilder builder = factory.bytesRefs(docs.count());){
            for (int i = 0; i < docs.count(); ++i) {
                this.read(docs.get(i), builder);
            }
            BlockLoader.Block block = builder.build();
            return block;
        }
    }

    @Override
    public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
        this.docId = docId;
        this.read(docId, (BlockLoader.BytesRefBuilder)builder);
    }

    private void read(int docId, BlockLoader.BytesRefBuilder builder) {
        this.script.runForDoc(docId);
        switch (this.script.count()) {
            case 0: {
                builder.appendNull();
                break;
            }
            case 1: {
                builder.appendBytesRef(this.script.values()[0]);
                break;
            }
            default: {
                builder.beginPositionEntry();
                for (int i = 0; i < this.script.count(); ++i) {
                    builder.appendBytesRef(this.script.values()[i]);
                }
                builder.endPositionEntry();
            }
        }
    }

    @Override
    public String toString() {
        return "ScriptIps";
    }

    static class IpScriptBlockLoader
    extends BlockDocValuesReader.DocValuesBlockLoader {
        private final IpFieldScript.LeafFactory factory;

        IpScriptBlockLoader(IpFieldScript.LeafFactory factory) {
            this.factory = factory;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.bytesRefs(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            return new IpScriptBlockDocValuesReader(this.factory.newInstance(context));
        }
    }
}

