/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.util.Comparator;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.index.Index;

public abstract class PriorityComparator
implements Comparator<ShardRouting> {
    @Override
    public final int compare(ShardRouting o1, ShardRouting o2) {
        Index o1Index = o1.index();
        Index o2Index = o2.index();
        int cmp = 0;
        if (!o1Index.equals(o2Index)) {
            IndexMetadata metadata01 = this.getMetadata(o1Index);
            IndexMetadata metadata02 = this.getMetadata(o2Index);
            cmp = Boolean.compare(metadata02.isSystem(), metadata01.isSystem());
            if (cmp == 0 && (cmp = Long.compare(metadata02.priority(), metadata01.priority())) == 0 && (cmp = Long.compare(metadata02.getCreationDate(), metadata01.getCreationDate())) == 0) {
                cmp = o2Index.getName().compareTo(o1Index.getName());
            }
        }
        return cmp;
    }

    protected abstract IndexMetadata getMetadata(Index var1);

    public static PriorityComparator getAllocationComparator(final RoutingAllocation allocation) {
        return new PriorityComparator(){

            @Override
            protected IndexMetadata getMetadata(Index index) {
                return allocation.metadata().getIndexSafe(index);
            }
        };
    }
}

