/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.synonyms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntFunction;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.synonyms.PagedResult;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class AbstractSynonymsPagedResultAction<T extends ActionResponse>
extends ActionType<T> {
    public AbstractSynonymsPagedResultAction(String name, Writeable.Reader<T> reader) {
        super(name);
    }

    public static abstract class AbstractPagedResultResponse<T extends Writeable>
    extends ActionResponse
    implements ToXContentObject {
        private final Writeable[] resultList;
        private final long totalCount;

        protected abstract String resultFieldName();

        protected abstract Writeable.Reader<T> reader();

        protected abstract IntFunction<T[]> arraySupplier();

        public AbstractPagedResultResponse(StreamInput in) throws IOException {
            this.totalCount = in.readVLong();
            this.resultList = (Writeable[])in.readArray(this.reader(), this.arraySupplier());
        }

        public AbstractPagedResultResponse(PagedResult<T> result) {
            this.resultList = result.pageResults();
            this.totalCount = result.totalResults();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("count", this.totalCount);
            builder.array(this.resultFieldName(), (Object[])this.resultList);
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.totalCount);
            out.writeArray(this.resultList);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractPagedResultResponse that = (AbstractPagedResultResponse)o;
            return this.totalCount == that.totalCount && Arrays.equals(this.resultList, that.resultList);
        }

        public int hashCode() {
            int result = Objects.hash(this.totalCount);
            result = 31 * result + Arrays.hashCode(this.resultList);
            return result;
        }
    }

    public static class Request
    extends ActionRequest {
        private static final int MAX_SYNONYMS_RESULTS = 10000;
        private final int from;
        private final int size;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.from = in.readVInt();
            this.size = in.readVInt();
        }

        public Request(int from, int size) {
            this.from = from;
            this.size = size;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            validationException = Request.validatePositiveInt("from", this.from, validationException);
            validationException = Request.validatePositiveInt("size", this.size, validationException);
            if (this.from + this.size > 10000) {
                validationException = ValidateActions.addValidationError("Too many results to retrieve. [from] + [size] must be less than or equal to 10000", validationException);
            }
            return validationException;
        }

        private static ActionRequestValidationException validatePositiveInt(String paramName, int value, ActionRequestValidationException validationException) {
            if (value < 0) {
                validationException = ValidateActions.addValidationError("[" + paramName + "] must be a positive integer", validationException);
            }
            return validationException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.from);
            out.writeVInt(this.size);
        }

        public int from() {
            return this.from;
        }

        public int size() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.from == request.from && this.size == request.size;
        }

        public int hashCode() {
            return Objects.hash(this.from, this.size);
        }
    }
}

