/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;

public abstract class AbstractThreadedActionListener<Response>
implements ActionListener<Response> {
    private static final Logger logger = LogManager.getLogger(AbstractThreadedActionListener.class);
    protected final Executor executor;
    protected final ActionListener<Response> delegate;
    protected final boolean forceExecution;

    protected AbstractThreadedActionListener(Executor executor, boolean forceExecution, ActionListener<Response> delegate) {
        this.forceExecution = forceExecution;
        this.executor = executor;
        this.delegate = delegate;
    }

    @Override
    public final void onFailure(final Exception e) {
        this.executor.execute(new AbstractRunnable(){

            @Override
            public boolean isForceExecution() {
                return AbstractThreadedActionListener.this.forceExecution;
            }

            @Override
            protected void doRun() {
                AbstractThreadedActionListener.this.delegate.onFailure(e);
            }

            @Override
            public void onRejection(Exception rejectionException) {
                rejectionException.addSuppressed(e);
                try {
                    AbstractThreadedActionListener.this.delegate.onFailure(rejectionException);
                }
                catch (Exception doubleFailure) {
                    rejectionException.addSuppressed(doubleFailure);
                    this.onFailure(rejectionException);
                }
            }

            @Override
            public void onFailure(Exception e2) {
                logger.error(() -> "failed to execute failure callback on [" + AbstractThreadedActionListener.this + "]", (Throwable)e2);
                assert (false) : e2;
            }

            public String toString() {
                return AbstractThreadedActionListener.this + "/onFailure";
            }
        });
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[" + this.executor + "/" + this.delegate + "]";
    }
}

