/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import org.elasticsearch.action.ActionRequestLazyBuilder;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.WriteRequestBuilder;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.XContentType;

public class BulkRequestBuilder
extends ActionRequestLazyBuilder<BulkRequest, BulkResponse>
implements WriteRequestBuilder<BulkRequestBuilder> {
    private final String globalIndex;
    private final List<DocWriteRequest<?>> requests = new ArrayList();
    private final List<FramedData> framedData = new ArrayList<FramedData>();
    private final Deque<ActionRequestLazyBuilder<? extends DocWriteRequest<?>, ? extends DocWriteResponse>> requestBuilders = new ArrayDeque();
    private ActiveShardCount waitForActiveShards;
    private TimeValue timeout;
    private String globalPipeline;
    private String globalRouting;
    private WriteRequest.RefreshPolicy refreshPolicy;
    private boolean requestPreviouslyCalled = false;

    public BulkRequestBuilder(ElasticsearchClient client, @Nullable String globalIndex) {
        super(client, TransportBulkAction.TYPE);
        this.globalIndex = globalIndex;
    }

    public BulkRequestBuilder(ElasticsearchClient client) {
        this(client, (String)null);
    }

    @Deprecated
    public BulkRequestBuilder add(IndexRequest request) {
        this.requests.add(request);
        return this;
    }

    public BulkRequestBuilder add(IndexRequestBuilder request) {
        this.requestBuilders.add(request);
        return this;
    }

    @Deprecated
    public BulkRequestBuilder add(DeleteRequest request) {
        this.requests.add(request);
        return this;
    }

    public BulkRequestBuilder add(DeleteRequestBuilder request) {
        this.requestBuilders.add(request);
        return this;
    }

    @Deprecated
    public BulkRequestBuilder add(UpdateRequest request) {
        this.requests.add(request);
        return this;
    }

    public BulkRequestBuilder add(UpdateRequestBuilder request) {
        this.requestBuilders.add(request);
        return this;
    }

    public BulkRequestBuilder add(byte[] data, int from, int length, XContentType xContentType) throws Exception {
        this.framedData.add(new FramedData(data, from, length, null, xContentType));
        return this;
    }

    public BulkRequestBuilder add(byte[] data, int from, int length, @Nullable String defaultIndex, XContentType xContentType) throws Exception {
        this.framedData.add(new FramedData(data, from, length, defaultIndex, xContentType));
        return this;
    }

    public BulkRequestBuilder setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public BulkRequestBuilder setWaitForActiveShards(int waitForActiveShards) {
        return this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public final BulkRequestBuilder setTimeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public final BulkRequestBuilder setTimeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue((String)timeout, null, (String)(this.getClass().getSimpleName() + ".timeout"));
        return this;
    }

    public int numberOfActions() {
        return this.requests.size() + this.requestBuilders.size() + this.framedData.size();
    }

    public BulkRequestBuilder pipeline(String globalPipeline) {
        this.globalPipeline = globalPipeline;
        return this;
    }

    public BulkRequestBuilder routing(String globalRouting) {
        this.globalRouting = globalRouting;
        return this;
    }

    @Override
    public BulkRequestBuilder setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public BulkRequestBuilder setRefreshPolicy(String refreshPolicy) {
        this.refreshPolicy = WriteRequest.RefreshPolicy.parse(refreshPolicy);
        return this;
    }

    @Override
    public BulkRequest request() {
        assert (!this.requestPreviouslyCalled) : "Cannot call request() multiple times on the same BulkRequestBuilder object";
        if (this.requestPreviouslyCalled) {
            throw new IllegalStateException("Cannot call request() multiple times on the same BulkRequestBuilder object");
        }
        this.requestPreviouslyCalled = true;
        this.validate();
        BulkRequest request = new BulkRequest(this.globalIndex);
        ActionRequestLazyBuilder<DocWriteRequest<?>, DocWriteResponse> builder = this.requestBuilders.pollFirst();
        while (builder != null) {
            request.add((DocWriteRequest<?>)((DocWriteRequest)builder.request()));
            builder = this.requestBuilders.pollFirst();
        }
        for (DocWriteRequest<?> childRequest : this.requests) {
            request.add(childRequest);
        }
        for (FramedData framedData : this.framedData) {
            try {
                request.add(framedData.data, framedData.from, framedData.length, framedData.defaultIndex, framedData.xContentType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.waitForActiveShards != null) {
            request.waitForActiveShards(this.waitForActiveShards);
        }
        if (this.timeout != null) {
            request.timeout(this.timeout);
        }
        if (this.globalPipeline != null) {
            request.pipeline(this.globalPipeline);
        }
        if (this.globalRouting != null) {
            request.routing(this.globalRouting);
        }
        if (this.refreshPolicy != null) {
            request.setRefreshPolicy(this.refreshPolicy);
        }
        return request;
    }

    private void validate() {
        if (this.countNonEmptyCollections(this.requestBuilders, this.requests, this.framedData) > 1) {
            throw new IllegalStateException("Must use only request builders, requests, or byte arrays within a single bulk request. Cannot mix and match");
        }
    }

    private int countNonEmptyCollections(Collection<?> ... collections) {
        int sum = 0;
        for (Collection<?> collection : collections) {
            if (collection.isEmpty()) continue;
            ++sum;
        }
        return sum;
    }

    private record FramedData(byte[] data, int from, int length, @Nullable String defaultIndex, XContentType xContentType) {
    }
}

