/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.post;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SimulateIndexTemplateResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField TEMPLATE = new ParseField("template", new String[0]);
    private static final ParseField OVERLAPPING = new ParseField("overlapping", new String[0]);
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField INDEX_PATTERNS = new ParseField("index_patterns", new String[0]);
    @Nullable
    private final Template resolvedTemplate;
    @Nullable
    private final Map<String, List<String>> overlappingTemplates;
    @Nullable
    private final RolloverConfiguration rolloverConfiguration;
    @Nullable
    private final DataStreamGlobalRetention globalRetention;

    public SimulateIndexTemplateResponse(@Nullable Template resolvedTemplate, @Nullable Map<String, List<String>> overlappingTemplates, DataStreamGlobalRetention globalRetention) {
        this(resolvedTemplate, overlappingTemplates, null, globalRetention);
    }

    public SimulateIndexTemplateResponse(@Nullable Template resolvedTemplate, @Nullable Map<String, List<String>> overlappingTemplates, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention globalRetention) {
        this.resolvedTemplate = resolvedTemplate;
        this.overlappingTemplates = overlappingTemplates;
        this.rolloverConfiguration = rolloverConfiguration;
        this.globalRetention = globalRetention;
    }

    public SimulateIndexTemplateResponse(StreamInput in) throws IOException {
        super(in);
        this.resolvedTemplate = in.readOptionalWriteable(Template::new);
        if (in.readBoolean()) {
            int overlappingTemplatesCount = in.readInt();
            this.overlappingTemplates = Maps.newMapWithExpectedSize(overlappingTemplatesCount);
            for (int i = 0; i < overlappingTemplatesCount; ++i) {
                String templateName = in.readString();
                this.overlappingTemplates.put(templateName, in.readStringCollectionAsList());
            }
        } else {
            this.overlappingTemplates = null;
        }
        this.rolloverConfiguration = in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X) ? in.readOptionalWriteable(RolloverConfiguration::new) : null;
        this.globalRetention = in.getTransportVersion().onOrAfter(TransportVersions.USE_DATA_STREAM_GLOBAL_RETENTION) ? in.readOptionalWriteable(DataStreamGlobalRetention::read) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.resolvedTemplate);
        if (this.overlappingTemplates != null) {
            out.writeBoolean(true);
            out.writeInt(this.overlappingTemplates.size());
            for (Map.Entry<String, List<String>> entry : this.overlappingTemplates.entrySet()) {
                out.writeString(entry.getKey());
                out.writeStringCollection((Collection<String>)entry.getValue());
            }
        } else {
            out.writeBoolean(false);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            out.writeOptionalWriteable(this.rolloverConfiguration);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.USE_DATA_STREAM_GLOBAL_RETENTION)) {
            out.writeOptionalWriteable(this.globalRetention);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.resolvedTemplate != null) {
            builder.field(TEMPLATE.getPreferredName());
            this.resolvedTemplate.toXContent(builder, params, this.rolloverConfiguration, this.globalRetention);
        }
        if (this.overlappingTemplates != null) {
            builder.startArray(OVERLAPPING.getPreferredName());
            for (Map.Entry<String, List<String>> entry : this.overlappingTemplates.entrySet()) {
                builder.startObject();
                builder.field(NAME.getPreferredName(), entry.getKey());
                builder.stringListField(INDEX_PATTERNS.getPreferredName(), (Collection)entry.getValue());
                builder.endObject();
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulateIndexTemplateResponse that = (SimulateIndexTemplateResponse)o;
        return Objects.equals(this.resolvedTemplate, that.resolvedTemplate) && Objects.deepEquals(this.overlappingTemplates, that.overlappingTemplates) && Objects.equals(this.rolloverConfiguration, that.rolloverConfiguration) && Objects.equals(this.globalRetention, that.globalRetention);
    }

    public int hashCode() {
        return Objects.hash(this.resolvedTemplate, this.overlappingTemplates, this.rolloverConfiguration, this.globalRetention);
    }

    public String toString() {
        return "SimulateIndexTemplateResponse{resolved template=" + this.resolvedTemplate + ", overlapping templates=" + String.join((CharSequence)"|", this.overlappingTemplates.keySet()) + "}";
    }
}

