/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.put;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public class PutMappingRequest
extends AcknowledgedRequest<PutMappingRequest>
implements IndicesRequest.Replaceable {
    private static Set<String> RESERVED_FIELDS = Set.of("_uid", "_id", "_type", "_source", "_all", "_analyzer", "_parent", "_routing", "_index", "_size", "_timestamp", "_ttl", "_field_names");
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.builder().concreteTargetOptions(IndicesOptions.ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(IndicesOptions.WildcardOptions.builder().matchOpen(true).matchClosed(true).includeHidden(false).allowEmptyExpressions(false).resolveAliases(true)).gatekeeperOptions(IndicesOptions.GatekeeperOptions.builder().allowClosedIndices(true).allowAliasToMultipleIndices(true).ignoreThrottled(false).allowFailureIndices(false)).build();
    private String source;
    private String origin = "";
    private Index concreteIndex;
    private boolean writeIndexOnly;

    public PutMappingRequest(StreamInput in) throws IOException {
        super(in);
        String type;
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0) && !"_doc".equals(type = in.readOptionalString())) {
            throw new IllegalArgumentException("Expected type [_doc] but received [" + type + "]");
        }
        this.source = in.readString();
        this.concreteIndex = in.readOptionalWriteable(Index::new);
        this.origin = in.readOptionalString();
        this.writeIndexOnly = in.readBoolean();
    }

    public PutMappingRequest() {
    }

    public PutMappingRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("mapping source is missing", validationException);
        } else if (this.source.isEmpty()) {
            validationException = ValidateActions.addValidationError("mapping source is empty", validationException);
        }
        if (this.concreteIndex != null && !CollectionUtils.isEmpty(this.indices)) {
            validationException = ValidateActions.addValidationError("either concrete index or unresolved indices can be set, concrete index: [" + this.concreteIndex + "] and indices: " + Arrays.asList(this.indices), validationException);
        }
        return validationException;
    }

    @Override
    public PutMappingRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public PutMappingRequest setConcreteIndex(Index index) {
        Objects.requireNonNull(index, "index must not be null");
        this.concreteIndex = index;
        return this;
    }

    public Index getConcreteIndex() {
        return this.concreteIndex;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public PutMappingRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public String source() {
        return this.source;
    }

    public PutMappingRequest source(String ... source) {
        return this.source(PutMappingRequest.simpleMapping(source));
    }

    public String origin() {
        return this.origin;
    }

    public PutMappingRequest origin(String origin) {
        this.origin = Objects.requireNonNull(origin);
        return this;
    }

    public static XContentBuilder simpleMapping(String ... source) {
        if (source.length % 2 != 0) {
            throw new IllegalArgumentException("mapping source must be pairs of fieldnames and properties definition.");
        }
        try {
            String[] s2;
            String[] s1;
            String fieldName;
            int i;
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            for (i = 0; i < source.length; ++i) {
                if (!RESERVED_FIELDS.contains(fieldName = source[i++])) continue;
                builder.startObject(fieldName);
                for (String s : s1 = Strings.splitStringByCommaToArray(source[i])) {
                    s2 = Strings.split(s, "=");
                    if (s2.length != 2) {
                        throw new IllegalArgumentException("malformed " + s);
                    }
                    builder.field(s2[0], s2[1]);
                }
                builder.endObject();
            }
            builder.startObject("properties");
            for (i = 0; i < source.length; ++i) {
                if (RESERVED_FIELDS.contains(fieldName = source[i++])) continue;
                builder.startObject(fieldName);
                for (String s : s1 = Strings.splitStringByCommaToArray(source[i])) {
                    s2 = Strings.split(s, "=");
                    if (s2.length != 2) {
                        throw new IllegalArgumentException("malformed " + s);
                    }
                    builder.field(s2[0], s2[1]);
                }
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to generate simplified mapping definition", e);
        }
    }

    public PutMappingRequest source(XContentBuilder mappingBuilder) {
        return this.source(BytesReference.bytes(mappingBuilder), mappingBuilder.contentType());
    }

    public PutMappingRequest source(Map<String, ?> mappingSource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
            builder.map(mappingSource);
            return this.source(BytesReference.bytes(builder), builder.contentType());
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + mappingSource + "]", e);
        }
    }

    public PutMappingRequest source(String mappingSource, XContentType xContentType) {
        return this.source(new BytesArray(mappingSource), xContentType);
    }

    public PutMappingRequest source(BytesReference mappingSource, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        try {
            this.source = XContentHelper.convertToJson(mappingSource, false, false, xContentType);
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException("failed to convert source to json", e);
        }
    }

    public PutMappingRequest writeIndexOnly(boolean writeIndexOnly) {
        this.writeIndexOnly = writeIndexOnly;
        return this;
    }

    public boolean writeIndexOnly() {
        return this.writeIndexOnly;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeOptionalString("_doc");
        }
        out.writeString(this.source);
        out.writeOptionalWriteable(this.concreteIndex);
        out.writeOptionalString(this.origin);
        out.writeBoolean(this.writeIndexOnly);
    }
}

