/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStage;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import org.elasticsearch.action.admin.cluster.snapshots.status.TransportNodesSnapshotsStatus;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.RefCountAwareThreadedActionListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSnapshotsStatusAction
extends TransportMasterNodeAction<SnapshotsStatusRequest, SnapshotsStatusResponse> {
    private static final Logger logger = LogManager.getLogger(TransportSnapshotsStatusAction.class);
    private final RepositoriesService repositoriesService;
    private final NodeClient client;

    @Inject
    public TransportSnapshotsStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RepositoriesService repositoriesService, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/snapshot/status", transportService, clusterService, threadPool, actionFilters, SnapshotsStatusRequest::new, indexNameExpressionResolver, SnapshotsStatusResponse::new, threadPool.executor("snapshot_meta"));
        this.repositoriesService = repositoriesService;
        this.client = client;
    }

    @Override
    protected ClusterBlockException checkBlock(SnapshotsStatusRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(Task task, SnapshotsStatusRequest request, ClusterState state, ActionListener<SnapshotsStatusResponse> listener) throws Exception {
        assert (task instanceof CancellableTask) : task + " not cancellable";
        CancellableTask cancellableTask = (CancellableTask)task;
        SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(state);
        List<SnapshotsInProgress.Entry> currentSnapshots = SnapshotsService.currentSnapshots(snapshotsInProgress, request.repository(), Arrays.asList(request.snapshots()));
        if (currentSnapshots.isEmpty()) {
            this.buildResponse(snapshotsInProgress, request, currentSnapshots, null, cancellableTask, listener);
            return;
        }
        HashSet<String> nodesIds = new HashSet<String>();
        for (SnapshotsInProgress.Entry entry : currentSnapshots) {
            for (SnapshotsInProgress.ShardSnapshotStatus status : entry.shardsByRepoShardId().values()) {
                if (status.nodeId() == null) continue;
                nodesIds.add(status.nodeId());
            }
        }
        if (!nodesIds.isEmpty()) {
            Snapshot[] snapshots = new Snapshot[currentSnapshots.size()];
            for (int i = 0; i < currentSnapshots.size(); ++i) {
                snapshots[i] = currentSnapshots.get(i).snapshot();
            }
            this.client.executeLocally(TransportNodesSnapshotsStatus.TYPE, (TransportNodesSnapshotsStatus.Request)new TransportNodesSnapshotsStatus.Request(nodesIds.toArray(Strings.EMPTY_ARRAY)).snapshots(snapshots).timeout(request.masterNodeTimeout().millis() < 0L ? null : request.masterNodeTimeout()), new RefCountAwareThreadedActionListener<TransportNodesSnapshotsStatus.NodesSnapshotStatus>(this.threadPool.executor("snapshot_meta"), listener.delegateFailureAndWrap((l, nodeSnapshotStatuses) -> this.buildResponse(snapshotsInProgress, request, currentSnapshots, (TransportNodesSnapshotsStatus.NodesSnapshotStatus)nodeSnapshotStatuses, cancellableTask, (ActionListener<SnapshotsStatusResponse>)l))));
        } else {
            this.buildResponse(snapshotsInProgress, request, currentSnapshots, null, cancellableTask, listener);
        }
    }

    private void buildResponse(SnapshotsInProgress snapshotsInProgress, SnapshotsStatusRequest request, List<SnapshotsInProgress.Entry> currentSnapshotEntries, TransportNodesSnapshotsStatus.NodesSnapshotStatus nodeSnapshotStatuses, CancellableTask task, ActionListener<SnapshotsStatusResponse> listener) {
        String repositoryName;
        ArrayList<SnapshotStatus> builder = new ArrayList<SnapshotStatus>();
        HashSet<String> currentSnapshotNames = new HashSet<String>();
        if (!currentSnapshotEntries.isEmpty()) {
            Map nodeSnapshotStatusMap = nodeSnapshotStatuses != null ? nodeSnapshotStatuses.getNodesMap() : new HashMap();
            for (SnapshotsInProgress.Entry entry : currentSnapshotEntries) {
                currentSnapshotNames.add(entry.snapshot().getSnapshotId().getName());
                ArrayList<SnapshotIndexShardStatus> shardStatusBuilder = new ArrayList<SnapshotIndexShardStatus>();
                for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> shardEntry : entry.shardsByRepoShardId().entrySet()) {
                    SnapshotIndexShardStatus shardStatus;
                    SnapshotIndexShardStage stage;
                    ShardId sid;
                    SnapshotIndexShardStatus shardStatus2;
                    Map<ShardId, SnapshotIndexShardStatus> shardStatues;
                    TransportNodesSnapshotsStatus.NodeSnapshotStatus nodeStatus;
                    SnapshotsInProgress.ShardSnapshotStatus status = shardEntry.getValue();
                    if (status.nodeId() != null && (nodeStatus = (TransportNodesSnapshotsStatus.NodeSnapshotStatus)nodeSnapshotStatusMap.get(status.nodeId())) != null && (shardStatues = nodeStatus.status().get(entry.snapshot())) != null && (shardStatus2 = shardStatues.get(sid = entry.shardId(shardEntry.getKey()))) != null) {
                        if (shardStatus2.getStage() == SnapshotIndexShardStage.DONE && shardEntry.getValue().state() != SnapshotsInProgress.ShardState.SUCCESS) {
                            shardStatus2 = new SnapshotIndexShardStatus(sid, SnapshotIndexShardStage.FINALIZE, shardStatus2.getStats(), shardStatus2.getNodeId(), shardStatus2.getFailure());
                        }
                        shardStatusBuilder.add(shardStatus2);
                        continue;
                    }
                    switch (shardEntry.getValue().state()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case FAILED: 
                        case ABORTED: 
                        case MISSING: {
                            SnapshotIndexShardStage snapshotIndexShardStage = SnapshotIndexShardStage.FAILURE;
                            break;
                        }
                        case INIT: 
                        case WAITING: 
                        case PAUSED_FOR_NODE_REMOVAL: 
                        case QUEUED: {
                            SnapshotIndexShardStage snapshotIndexShardStage = SnapshotIndexShardStage.STARTED;
                            break;
                        }
                        case SUCCESS: {
                            SnapshotIndexShardStage snapshotIndexShardStage = stage = SnapshotIndexShardStage.DONE;
                        }
                    }
                    if (stage == SnapshotIndexShardStage.DONE) {
                        ShardId shardId = entry.shardId(shardEntry.getKey());
                        shardStatus = new SnapshotIndexShardStatus(shardId, this.repositoriesService.repository(entry.repository()).getShardSnapshotStatus(entry.snapshot().getSnapshotId(), entry.indices().get(shardId.getIndexName()), shardId));
                    } else {
                        shardStatus = new SnapshotIndexShardStatus(entry.shardId(shardEntry.getKey()), stage);
                    }
                    shardStatusBuilder.add(shardStatus);
                }
                builder.add(new SnapshotStatus(entry.snapshot(), entry.state(), Collections.unmodifiableList(shardStatusBuilder), entry.includeGlobalState(), entry.startTime(), Math.max(this.threadPool.absoluteTimeInMillis() - entry.startTime(), 0L)));
            }
        }
        if (Strings.hasText(repositoryName = request.repository()) && !CollectionUtils.isEmpty(request.snapshots())) {
            this.loadRepositoryData(snapshotsInProgress, request, builder, currentSnapshotNames, repositoryName, task, listener);
        } else {
            listener.onResponse(new SnapshotsStatusResponse(Collections.unmodifiableList(builder)));
        }
    }

    private void loadRepositoryData(SnapshotsInProgress snapshotsInProgress, SnapshotsStatusRequest request, List<SnapshotStatus> builder, Set<String> currentSnapshotNames, String repositoryName, CancellableTask task, ActionListener<SnapshotsStatusResponse> listener) {
        HashSet<String> requestedSnapshotNames = Sets.newHashSet(request.snapshots());
        ListenableFuture<RepositoryData> repositoryDataListener = new ListenableFuture<RepositoryData>();
        this.repositoriesService.getRepositoryData(repositoryName, repositoryDataListener);
        ArrayList snapshotIdsToLoad = new ArrayList();
        repositoryDataListener.addListener(listener.delegateFailureAndWrap((delegate, repositoryData) -> {
            task.ensureNotCancelled();
            Map matchedSnapshotIds = repositoryData.getSnapshotIds().stream().filter(s -> requestedSnapshotNames.contains(s.getName())).collect(Collectors.toMap(SnapshotId::getName, Function.identity()));
            for (String snapshotName : request.snapshots()) {
                if (currentSnapshotNames.contains(snapshotName)) continue;
                SnapshotId snapshotId = (SnapshotId)matchedSnapshotIds.get(snapshotName);
                if (snapshotId == null) {
                    if (request.ignoreUnavailable()) {
                        logger.debug("snapshot status request ignoring snapshot [{}], not found in repository [{}]", (Object)snapshotName, (Object)repositoryName);
                        continue;
                    }
                    throw new SnapshotMissingException(repositoryName, snapshotName);
                }
                if (snapshotsInProgress.snapshot(new Snapshot(repositoryName, snapshotId)) != null) continue;
                snapshotIdsToLoad.add(snapshotId);
            }
            if (snapshotIdsToLoad.isEmpty()) {
                delegate.onResponse(new SnapshotsStatusResponse(Collections.unmodifiableList(builder)));
            } else {
                List threadSafeBuilder = Collections.synchronizedList(builder);
                this.repositoriesService.repository(repositoryName).getSnapshotInfo(snapshotIdsToLoad, true, task::isCancelled, (CheckedConsumer<SnapshotInfo, Exception>)((CheckedConsumer)snapshotInfo -> {
                    ArrayList<SnapshotIndexShardStatus> shardStatusBuilder = new ArrayList<SnapshotIndexShardStatus>();
                    Map<ShardId, IndexShardSnapshotStatus.Copy> shardStatuses = this.snapshotShards(repositoryName, (RepositoryData)repositoryData, task, (SnapshotInfo)snapshotInfo);
                    for (Map.Entry<ShardId, IndexShardSnapshotStatus.Copy> shardStatus : shardStatuses.entrySet()) {
                        IndexShardSnapshotStatus.Copy lastSnapshotStatus = shardStatus.getValue();
                        shardStatusBuilder.add(new SnapshotIndexShardStatus(shardStatus.getKey(), lastSnapshotStatus));
                    }
                    SnapshotsInProgress.State state = switch (snapshotInfo.state()) {
                        case SnapshotState.FAILED -> SnapshotsInProgress.State.FAILED;
                        case SnapshotState.SUCCESS, SnapshotState.PARTIAL -> SnapshotsInProgress.State.SUCCESS;
                        default -> throw new IllegalArgumentException("Unexpected snapshot state " + snapshotInfo.state());
                    };
                    long startTime = snapshotInfo.startTime();
                    long endTime = snapshotInfo.endTime();
                    assert (endTime >= startTime || endTime == 0L && !snapshotInfo.state().completed()) : "Inconsistent timestamps found in SnapshotInfo [" + snapshotInfo + "]";
                    threadSafeBuilder.add(new SnapshotStatus(new Snapshot(repositoryName, snapshotInfo.snapshotId()), state, Collections.unmodifiableList(shardStatusBuilder), snapshotInfo.includeGlobalState(), startTime, (endTime == 0L ? this.threadPool.absoluteTimeInMillis() : endTime) - startTime));
                }), delegate.map(v -> new SnapshotsStatusResponse(List.copyOf(threadSafeBuilder))));
            }
        }));
    }

    private Map<ShardId, IndexShardSnapshotStatus.Copy> snapshotShards(String repositoryName, RepositoryData repositoryData, CancellableTask task, SnapshotInfo snapshotInfo) throws IOException {
        Repository repository = this.repositoriesService.repository(repositoryName);
        HashMap<ShardId, IndexShardSnapshotStatus.Copy> shardStatus = new HashMap<ShardId, IndexShardSnapshotStatus.Copy>();
        for (String index : snapshotInfo.indices()) {
            IndexId indexId = repositoryData.resolveIndexId(index);
            task.ensureNotCancelled();
            IndexMetadata indexMetadata = repository.getSnapshotIndexMetaData(repositoryData, snapshotInfo.snapshotId(), indexId);
            if (indexMetadata == null) continue;
            int numberOfShards = indexMetadata.getNumberOfShards();
            for (int i = 0; i < numberOfShards; ++i) {
                IndexShardSnapshotStatus.Copy shardSnapshotStatus;
                ShardId shardId = new ShardId(indexMetadata.getIndex(), i);
                SnapshotShardFailure shardFailure = TransportSnapshotsStatusAction.findShardFailure(snapshotInfo.shardFailures(), shardId);
                if (shardFailure != null) {
                    shardStatus.put(shardId, IndexShardSnapshotStatus.newFailed(shardFailure.reason()));
                    continue;
                }
                if (snapshotInfo.state() == SnapshotState.FAILED) {
                    shardSnapshotStatus = IndexShardSnapshotStatus.newFailed("skipped");
                } else {
                    task.ensureNotCancelled();
                    shardSnapshotStatus = repository.getShardSnapshotStatus(snapshotInfo.snapshotId(), indexId, shardId);
                }
                shardStatus.put(shardId, shardSnapshotStatus);
            }
        }
        return Collections.unmodifiableMap(shardStatus);
    }

    private static SnapshotShardFailure findShardFailure(List<SnapshotShardFailure> shardFailures, ShardId shardId) {
        for (SnapshotShardFailure shardFailure : shardFailures) {
            if (!shardId.getIndexName().equals(shardFailure.index()) || shardId.getId() != shardFailure.shardId()) continue;
            return shardFailure;
        }
        return null;
    }
}

