/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.create;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class CreateSnapshotRequest
extends MasterNodeRequest<CreateSnapshotRequest>
implements IndicesRequest.Replaceable,
ToXContentObject {
    public static final TransportVersion SETTINGS_IN_REQUEST_VERSION = TransportVersions.V_8_0_0;
    public static int MAXIMUM_METADATA_BYTES = 1024;
    private String snapshot;
    private String repository;
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandHidden();
    private String[] featureStates = Strings.EMPTY_ARRAY;
    private boolean partial = false;
    private boolean includeGlobalState = true;
    private boolean waitForCompletion;
    @Nullable
    private Map<String, Object> userMetadata;

    public CreateSnapshotRequest() {
    }

    public CreateSnapshotRequest(String repository, String snapshot) {
        this.snapshot = snapshot;
        this.repository = repository;
    }

    public CreateSnapshotRequest(StreamInput in) throws IOException {
        super(in);
        this.snapshot = in.readString();
        this.repository = in.readString();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        if (in.getTransportVersion().before(SETTINGS_IN_REQUEST_VERSION)) {
            Settings.readSettingsFromStream(in);
        }
        this.featureStates = in.readStringArray();
        this.includeGlobalState = in.readBoolean();
        this.waitForCompletion = in.readBoolean();
        this.partial = in.readBoolean();
        this.userMetadata = in.readGenericMap();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.snapshot);
        out.writeString(this.repository);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        if (out.getTransportVersion().before(SETTINGS_IN_REQUEST_VERSION)) {
            Settings.EMPTY.writeTo(out);
        }
        out.writeStringArray(this.featureStates);
        out.writeBoolean(this.includeGlobalState);
        out.writeBoolean(this.waitForCompletion);
        out.writeBoolean(this.partial);
        out.writeGenericMap(this.userMetadata);
    }

    @Override
    public ActionRequestValidationException validate() {
        int metadataSize;
        ActionRequestValidationException validationException = null;
        if (this.snapshot == null) {
            validationException = ValidateActions.addValidationError("snapshot is missing", validationException);
        }
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError("repository is missing", validationException);
        }
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError("indices is null", validationException);
        } else {
            for (String index : this.indices) {
                if (index != null) continue;
                validationException = ValidateActions.addValidationError("index is null", validationException);
                break;
            }
        }
        if (this.indicesOptions == null) {
            validationException = ValidateActions.addValidationError("indicesOptions is null", validationException);
        }
        if (this.featureStates == null) {
            validationException = ValidateActions.addValidationError("featureStates is null", validationException);
        }
        if ((metadataSize = CreateSnapshotRequest.metadataSize(this.userMetadata)) > MAXIMUM_METADATA_BYTES) {
            validationException = ValidateActions.addValidationError("metadata must be smaller than 1024 bytes, but was [" + metadataSize + "]", validationException);
        }
        return validationException;
    }

    public static int metadataSize(Map<String, Object> userMetadata) {
        int n;
        block9: {
            if (userMetadata == null) {
                return 0;
            }
            XContentBuilder builder = XContentFactory.jsonBuilder();
            try {
                int size;
                builder.value(userMetadata);
                n = size = BytesReference.bytes(builder).length();
                if (builder == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchException(e);
                }
            }
            builder.close();
        }
        return n;
    }

    public CreateSnapshotRequest snapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public CreateSnapshotRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    @Override
    public CreateSnapshotRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public CreateSnapshotRequest indices(List<String> indices) {
        this.indices = indices.toArray(new String[indices.size()]);
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public CreateSnapshotRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public boolean partial() {
        return this.partial;
    }

    public CreateSnapshotRequest partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public CreateSnapshotRequest waitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public CreateSnapshotRequest includeGlobalState(boolean includeGlobalState) {
        this.includeGlobalState = includeGlobalState;
        return this;
    }

    public boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    @Nullable
    public Map<String, Object> userMetadata() {
        return this.userMetadata;
    }

    public CreateSnapshotRequest userMetadata(@Nullable Map<String, Object> userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    public String[] featureStates() {
        return this.featureStates;
    }

    public CreateSnapshotRequest featureStates(String[] featureStates) {
        this.featureStates = featureStates;
        return this;
    }

    public CreateSnapshotRequest featureStates(List<String> featureStates) {
        return this.featureStates(featureStates.toArray(Strings.EMPTY_ARRAY));
    }

    public CreateSnapshotRequest source(Map<String, Object> source) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name;
            switch (name = entry.getKey()) {
                case "indices": {
                    if (entry.getValue() instanceof String) {
                        this.indices(Strings.splitStringByCommaToArray((String)entry.getValue()));
                        break;
                    }
                    if (entry.getValue() instanceof List) {
                        this.indices((List)entry.getValue());
                        break;
                    }
                    throw new IllegalArgumentException("malformed indices section, should be an array of strings");
                }
                case "feature_states": {
                    if (entry.getValue() instanceof List) {
                        this.featureStates((List)entry.getValue());
                        break;
                    }
                    throw new IllegalArgumentException("malformed feature_states section, should be an array of strings");
                }
                case "partial": {
                    this.partial(XContentMapValues.nodeBooleanValue(entry.getValue(), "partial"));
                    break;
                }
                case "include_global_state": {
                    this.includeGlobalState = XContentMapValues.nodeBooleanValue(entry.getValue(), "include_global_state");
                    break;
                }
                case "metadata": {
                    if (entry.getValue() != null && !(entry.getValue() instanceof Map)) {
                        throw new IllegalArgumentException("malformed metadata, should be an object");
                    }
                    this.userMetadata((Map)entry.getValue());
                }
            }
        }
        this.indicesOptions(IndicesOptions.fromMap(source, this.indicesOptions));
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("repository", this.repository);
        builder.field("snapshot", this.snapshot);
        builder.array("indices", this.indices);
        if (this.featureStates != null) {
            builder.array("feature_states", this.featureStates);
        }
        builder.field("partial", this.partial);
        builder.field("include_global_state", this.includeGlobalState);
        if (this.indicesOptions != null) {
            this.indicesOptions.toXContent(builder, params);
        }
        builder.field("metadata", this.userMetadata);
        builder.endObject();
        return builder;
    }

    @Override
    public String getDescription() {
        return "snapshot [" + this.repository + ":" + this.snapshot + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSnapshotRequest that = (CreateSnapshotRequest)o;
        return this.partial == that.partial && this.includeGlobalState == that.includeGlobalState && this.waitForCompletion == that.waitForCompletion && Objects.equals(this.snapshot, that.snapshot) && Objects.equals(this.repository, that.repository) && Arrays.equals(this.indices, that.indices) && Objects.equals(this.indicesOptions, that.indicesOptions) && Arrays.equals(this.featureStates, that.featureStates) && Objects.equals(this.masterNodeTimeout, that.masterNodeTimeout) && Objects.equals(this.userMetadata, that.userMetadata);
    }

    public int hashCode() {
        int result = Objects.hash(this.snapshot, this.repository, this.indicesOptions, this.partial, this.includeGlobalState, this.waitForCompletion, this.userMetadata);
        result = 31 * result + Arrays.hashCode(this.indices);
        result = 31 * result + Arrays.hashCode(this.featureStates);
        return result;
    }

    @Override
    public String toString() {
        return "CreateSnapshotRequest{snapshot='" + this.snapshot + "', repository='" + this.repository + "', indices=" + (this.indices == null ? null : Arrays.asList(this.indices)) + ", indicesOptions=" + this.indicesOptions + ", featureStates=" + Arrays.asList(this.featureStates) + ", partial=" + this.partial + ", includeGlobalState=" + this.includeGlobalState + ", waitForCompletion=" + this.waitForCompletion + ", masterNodeTimeout=" + this.masterNodeTimeout + ", metadata=" + this.userMetadata + "}";
    }
}

