/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.cleanup;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.RepositoryCleanupInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryCleanupResult;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class TransportCleanupRepositoryAction
extends TransportMasterNodeAction<CleanupRepositoryRequest, CleanupRepositoryResponse> {
    public static final ActionType<CleanupRepositoryResponse> TYPE = new ActionType("cluster:admin/repository/_cleanup");
    private static final Logger logger = LogManager.getLogger(TransportCleanupRepositoryAction.class);
    private final RepositoriesService repositoriesService;

    @Inject
    public TransportCleanupRepositoryAction(TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, CleanupRepositoryRequest::new, indexNameExpressionResolver, CleanupRepositoryResponse::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.repositoriesService = repositoriesService;
        if (DiscoveryNode.isMasterNode(clusterService.getSettings())) {
            TransportCleanupRepositoryAction.addClusterStateApplier(clusterService);
        }
    }

    private static void addClusterStateApplier(ClusterService clusterService) {
        clusterService.addStateApplier(event -> {
            if (event.localNodeMaster() && !event.previousState().nodes().isLocalNodeElectedMaster()) {
                final RepositoryCleanupInProgress repositoryCleanupInProgress = RepositoryCleanupInProgress.get(event.state());
                if (!repositoryCleanupInProgress.hasCleanupInProgress()) {
                    return;
                }
                TransportCleanupRepositoryAction.submitUnbatchedTask(clusterService, "clean up repository cleanup task after master failover", new ClusterStateUpdateTask(){

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        return TransportCleanupRepositoryAction.removeInProgressCleanup(currentState);
                    }

                    @Override
                    public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                        logger.debug("Removed repository cleanup task [{}] from cluster state", (Object)repositoryCleanupInProgress);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.warn("Failed to remove repository cleanup task [{}] from cluster state", (Object)repositoryCleanupInProgress);
                    }
                });
            }
        });
    }

    private static ClusterState removeInProgressCleanup(ClusterState currentState) {
        return RepositoryCleanupInProgress.get(currentState).hasCleanupInProgress() ? ClusterState.builder(currentState).putCustom("repository_cleanup", RepositoryCleanupInProgress.EMPTY).build() : currentState;
    }

    @Override
    protected void masterOperation(Task task, CleanupRepositoryRequest request, ClusterState state, ActionListener<CleanupRepositoryResponse> listener) {
        this.cleanupRepo(request.name(), listener.map(CleanupRepositoryResponse::new));
    }

    @Override
    protected ClusterBlockException checkBlock(CleanupRepositoryRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    private void cleanupRepo(final String repositoryName, ActionListener<RepositoryCleanupResult> listener) {
        Repository repository = this.repositoriesService.repository(repositoryName);
        if (!(repository instanceof BlobStoreRepository)) {
            listener.onFailure(new IllegalArgumentException("Repository [" + repositoryName + "] does not support repository cleanup"));
            return;
        }
        final BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        ListenableFuture<RepositoryData> repositoryDataListener = new ListenableFuture<RepositoryData>();
        repository.getRepositoryData(EsExecutors.DIRECT_EXECUTOR_SERVICE, repositoryDataListener);
        repositoryDataListener.addListener(listener.delegateFailureAndWrap((delegate, repositoryData) -> {
            final long repositoryStateId = repositoryData.getGenId();
            logger.info("Running cleanup operations on repository [{}][{}]", (Object)repositoryName, (Object)repositoryStateId);
            TransportCleanupRepositoryAction.submitUnbatchedTask(this.clusterService, "cleanup repository [" + repositoryName + "][" + repositoryStateId + "]", new ClusterStateUpdateTask((ActionListener)delegate){
                private boolean startedCleanup = false;
                final /* synthetic */ ActionListener val$delegate;
                {
                    this.val$delegate = actionListener;
                }

                @Override
                public ClusterState execute(ClusterState currentState) {
                    SnapshotsService.ensureRepositoryExists(repositoryName, currentState);
                    RepositoryCleanupInProgress repositoryCleanupInProgress = RepositoryCleanupInProgress.get(currentState);
                    if (repositoryCleanupInProgress.hasCleanupInProgress()) {
                        throw new IllegalStateException("Cannot cleanup [" + repositoryName + "] - a repository cleanup is already in-progress in [" + repositoryCleanupInProgress + "]");
                    }
                    SnapshotDeletionsInProgress deletionsInProgress = SnapshotDeletionsInProgress.get(currentState);
                    if (deletionsInProgress.hasDeletionsInProgress()) {
                        throw new IllegalStateException("Cannot cleanup [" + repositoryName + "] - a snapshot is currently being deleted in [" + deletionsInProgress + "]");
                    }
                    SnapshotsInProgress snapshots = SnapshotsInProgress.get(currentState);
                    if (!snapshots.isEmpty()) {
                        throw new IllegalStateException("Cannot cleanup [" + repositoryName + "] - a snapshot is currently running in [" + snapshots + "]");
                    }
                    return ClusterState.builder(currentState).putCustom("repository_cleanup", new RepositoryCleanupInProgress(List.of(RepositoryCleanupInProgress.startedEntry(repositoryName, repositoryStateId)))).build();
                }

                @Override
                public void onFailure(Exception e) {
                    this.after(e, null);
                }

                @Override
                public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                    this.startedCleanup = true;
                    logger.debug("Initialized repository cleanup in cluster state for [{}][{}]", (Object)repositoryName, (Object)repositoryStateId);
                    ActionListener.run(ActionListener.wrap(result -> this.after(null, new RepositoryCleanupResult((DeleteResult)result)), e -> this.after((Exception)e, null)), l -> blobStoreRepository.cleanup(repositoryStateId, newState.nodes().getMaxDataNodeCompatibleIndexVersion(), (ActionListener<DeleteResult>)l));
                }

                private void after(final @Nullable Exception failure, final @Nullable RepositoryCleanupResult result) {
                    if (failure == null) {
                        logger.debug("Finished repository cleanup operations on [{}][{}]", (Object)repositoryName, (Object)repositoryStateId);
                    } else {
                        logger.debug(() -> "Failed to finish repository cleanup operations on [" + repositoryName + "][" + repositoryStateId + "]", (Throwable)failure);
                    }
                    assert (failure != null || result != null);
                    if (!this.startedCleanup) {
                        logger.debug("No cleanup task to remove from cluster state because we failed to start one", (Throwable)failure);
                        this.val$delegate.onFailure(failure);
                        return;
                    }
                    TransportCleanupRepositoryAction.submitUnbatchedTask(TransportCleanupRepositoryAction.this.clusterService, "remove repository cleanup task [" + repositoryName + "][" + repositoryStateId + "]", new ClusterStateUpdateTask(){

                        @Override
                        public ClusterState execute(ClusterState currentState) {
                            return TransportCleanupRepositoryAction.removeInProgressCleanup(currentState);
                        }

                        @Override
                        public void onFailure(Exception e) {
                            if (failure != null) {
                                e.addSuppressed(failure);
                            }
                            logger.warn(() -> "[" + repositoryName + "] failed to remove repository cleanup task", (Throwable)e);
                            val$delegate.onFailure(e);
                        }

                        @Override
                        public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                            if (failure == null) {
                                logger.info("Done with repository cleanup on [{}][{}] with result [{}]", (Object)repositoryName, (Object)repositoryStateId, (Object)result);
                                val$delegate.onResponse(result);
                            } else {
                                logger.warn(() -> "Failed to run repository cleanup operations on [" + repositoryName + "][" + repositoryStateId + "]", (Throwable)failure);
                                val$delegate.onFailure(failure);
                            }
                        }
                    });
                }
            });
        }));
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private static void submitUnbatchedTask(ClusterService clusterService, String source, ClusterStateUpdateTask task) {
        clusterService.submitUnbatchedStateUpdateTask(source, task);
    }
}

