/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.actions.throttler;

import java.time.Clock;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.watcher.actions.ActionStatus;
import org.elasticsearch.xpack.core.watcher.actions.throttler.Throttler;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;

public class PeriodThrottler
implements Throttler {
    @Nullable
    private final TimeValue period;
    private final Clock clock;

    public PeriodThrottler(Clock clock, TimeValue period) {
        this.period = period;
        this.clock = clock;
    }

    public TimeValue period() {
        return this.period;
    }

    @Override
    public Throttler.Result throttle(String actionId, WatchExecutionContext ctx) {
        long executionTime;
        ActionStatus status;
        TimeValue throttlePeriod = this.period;
        if (throttlePeriod == null) {
            throttlePeriod = ctx.watch().throttlePeriod();
        }
        if (throttlePeriod == null) {
            throttlePeriod = ctx.defaultThrottlePeriod();
        }
        if ((status = ctx.watch().status().actionStatus(actionId)).lastSuccessfulExecution() == null) {
            return Throttler.Result.NO;
        }
        long now = this.clock.millis();
        TimeValue timeElapsed = TimeValue.timeValueMillis((long)(now - (executionTime = status.lastSuccessfulExecution().timestamp().toInstant().toEpochMilli())));
        if (timeElapsed.getMillis() <= throttlePeriod.getMillis()) {
            return Throttler.Result.throttle(Throttler.Type.PERIOD, "throttling interval is set to [{}] but time elapsed since last execution is [{}]", throttlePeriod, timeElapsed);
        }
        return Throttler.Result.NO;
    }
}

