/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.transform.TransformConfigVersion;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.transforms.DestConfig;
import org.elasticsearch.xpack.core.transform.transforms.NullRetentionPolicyConfig;
import org.elasticsearch.xpack.core.transform.transforms.RetentionPolicyConfig;
import org.elasticsearch.xpack.core.transform.transforms.SettingsConfig;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.SyncConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;

public final class TransformConfigUpdate
implements Writeable {
    public static final String NAME = "data_frame_transform_config_update";
    public static final TransformConfigUpdate EMPTY = new TransformConfigUpdate(null, null, null, null, null, null, null, null);
    private static final ConstructingObjectParser<TransformConfigUpdate, String> PARSER = new ConstructingObjectParser("data_frame_transform_config_update", false, args -> {
        SourceConfig source = (SourceConfig)args[0];
        DestConfig dest = (DestConfig)args[1];
        TimeValue frequency = args[2] == null ? null : TimeValue.parseTimeValue((String)((String)args[2]), (String)TransformField.FREQUENCY.getPreferredName());
        SyncConfig syncConfig = (SyncConfig)args[3];
        String description = (String)args[4];
        SettingsConfig settings = (SettingsConfig)args[5];
        Map metadata = (Map)args[6];
        RetentionPolicyConfig retentionPolicyConfig = (RetentionPolicyConfig)args[7];
        return new TransformConfigUpdate(source, dest, frequency, syncConfig, description, settings, metadata, retentionPolicyConfig);
    });
    private final SourceConfig source;
    private final DestConfig dest;
    private final TimeValue frequency;
    private final SyncConfig syncConfig;
    private final String description;
    private final SettingsConfig settings;
    private final Map<String, Object> metadata;
    private final RetentionPolicyConfig retentionPolicyConfig;
    private Map<String, String> headers;

    public TransformConfigUpdate(SourceConfig source, DestConfig dest, TimeValue frequency, SyncConfig syncConfig, String description, SettingsConfig settings, Map<String, Object> metadata, RetentionPolicyConfig retentionPolicyConfig) {
        this.source = source;
        this.dest = dest;
        this.frequency = frequency;
        this.syncConfig = syncConfig;
        this.description = description;
        if (this.description != null && this.description.length() > 1000) {
            throw new IllegalArgumentException("[description] must be less than 1000 characters in length.");
        }
        this.settings = settings;
        this.metadata = metadata;
        this.retentionPolicyConfig = retentionPolicyConfig;
    }

    public TransformConfigUpdate(StreamInput in) throws IOException {
        this.source = (SourceConfig)in.readOptionalWriteable(SourceConfig::new);
        this.dest = (DestConfig)in.readOptionalWriteable(DestConfig::new);
        this.frequency = in.readOptionalTimeValue();
        this.description = in.readOptionalString();
        this.syncConfig = (SyncConfig)in.readOptionalNamedWriteable(SyncConfig.class);
        if (in.readBoolean()) {
            this.setHeaders(in.readMap(StreamInput::readString));
        }
        this.settings = (SettingsConfig)in.readOptionalWriteable(SettingsConfig::new);
        this.metadata = in.readGenericMap();
        this.retentionPolicyConfig = (RetentionPolicyConfig)in.readOptionalNamedWriteable(RetentionPolicyConfig.class);
    }

    public SourceConfig getSource() {
        return this.source;
    }

    public DestConfig getDestination() {
        return this.dest;
    }

    public TimeValue getFrequency() {
        return this.frequency;
    }

    public SyncConfig getSyncConfig() {
        return this.syncConfig;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public SettingsConfig getSettings() {
        return this.settings;
    }

    @Nullable
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Nullable
    public RetentionPolicyConfig getRetentionPolicyConfig() {
        return this.retentionPolicyConfig;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.source);
        out.writeOptionalWriteable((Writeable)this.dest);
        out.writeOptionalTimeValue(this.frequency);
        out.writeOptionalString(this.description);
        out.writeOptionalNamedWriteable((NamedWriteable)this.syncConfig);
        if (this.headers != null) {
            out.writeBoolean(true);
            out.writeMap(this.headers, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalWriteable((Writeable)this.settings);
        out.writeGenericMap(this.metadata);
        out.writeOptionalNamedWriteable((NamedWriteable)this.retentionPolicyConfig);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformConfigUpdate that = (TransformConfigUpdate)other;
        return Objects.equals(this.source, that.source) && Objects.equals(this.dest, that.dest) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.syncConfig, that.syncConfig) && Objects.equals(this.description, that.description) && Objects.equals(this.settings, that.settings) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.retentionPolicyConfig, that.retentionPolicyConfig) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.dest, this.frequency, this.syncConfig, this.description, this.settings, this.metadata, this.retentionPolicyConfig, this.headers);
    }

    public static TransformConfigUpdate fromXContent(XContentParser parser) {
        return (TransformConfigUpdate)PARSER.apply(parser, null);
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    boolean isNoop(TransformConfig config) {
        return TransformConfigUpdate.isNullOrEqual(this.source, config.getSource()) && TransformConfigUpdate.isNullOrEqual(this.dest, config.getDestination()) && TransformConfigUpdate.isNullOrEqual(this.frequency, config.getFrequency()) && TransformConfigUpdate.isNullOrEqual(this.syncConfig, config.getSyncConfig()) && TransformConfigUpdate.isNullOrEqual(this.description, config.getDescription()) && TransformConfigUpdate.isNullOrEqual(this.settings, config.getSettings()) && TransformConfigUpdate.isNullOrEqual(this.metadata, config.getMetadata()) && TransformConfigUpdate.isNullOrEqual(this.retentionPolicyConfig, config.getRetentionPolicyConfig()) && TransformConfigUpdate.isNullOrEqual(this.headers, config.getHeaders());
    }

    public boolean changesSettings(TransformConfig config) {
        return !TransformConfigUpdate.isNullOrEqual(this.settings, config.getSettings());
    }

    public boolean changesHeaders(TransformConfig config) {
        return !TransformConfigUpdate.isNullOrEqual(this.headers, config.getHeaders());
    }

    private static boolean isNullOrEqual(Object lft, Object rgt) {
        return lft == null || lft.equals(rgt);
    }

    public TransformConfig apply(TransformConfig config) {
        if (this.isNoop(config)) {
            return config;
        }
        TransformConfig.Builder builder = new TransformConfig.Builder(config);
        if (this.source != null) {
            builder.setSource(this.source);
        }
        if (this.dest != null) {
            builder.setDest(this.dest);
        }
        if (this.frequency != null) {
            builder.setFrequency(this.frequency);
        }
        if (this.syncConfig != null) {
            String currentConfigName;
            String string = currentConfigName = config.getSyncConfig() == null ? "null" : config.getSyncConfig().getWriteableName();
            if (!this.syncConfig.getWriteableName().equals(currentConfigName)) {
                throw new ElasticsearchStatusException(TransformMessages.getMessage("Cannot change the current sync configuration of transform [{0}] from [{1}] to [{2}]", config.getId(), currentConfigName, this.syncConfig.getWriteableName()), RestStatus.BAD_REQUEST, new Object[0]);
            }
            builder.setSyncConfig(this.syncConfig);
        }
        if (this.description != null) {
            builder.setDescription(this.description);
        }
        if (this.headers != null) {
            builder.setHeaders(this.headers);
        }
        if (this.settings != null) {
            SettingsConfig.Builder settingsBuilder = new SettingsConfig.Builder(config.getSettings());
            settingsBuilder.update(this.settings);
            builder.setSettings(settingsBuilder.build());
        }
        if (this.metadata != null) {
            builder.setMetadata(this.metadata);
        }
        if (this.retentionPolicyConfig != null) {
            if (NullRetentionPolicyConfig.INSTANCE.equals(this.retentionPolicyConfig)) {
                builder.setRetentionPolicyConfig(null);
            } else {
                builder.setRetentionPolicyConfig(this.retentionPolicyConfig);
            }
        }
        builder.setVersion(TransformConfigVersion.CURRENT);
        return builder.build();
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SourceConfig.fromXContent(p, false), TransformField.SOURCE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DestConfig.fromXContent(p, false), TransformField.DESTINATION);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.FREQUENCY);
        PARSER.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (SyncConfig)p.namedObject(SyncConfig.class, n, c), TransformField.SYNC);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.DESCRIPTION);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SettingsConfig.fromXContent(p, false), TransformField.SETTINGS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), TransformField.METADATA);
        PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            XContentParser.Token token = p.nextToken();
            assert (token == XContentParser.Token.FIELD_NAME);
            String currentName = p.currentName();
            RetentionPolicyConfig namedObject = (RetentionPolicyConfig)p.namedObject(RetentionPolicyConfig.class, currentName, c);
            token = p.nextToken();
            assert (token == XContentParser.Token.END_OBJECT);
            return namedObject;
        }, (Object)NullRetentionPolicyConfig.INSTANCE, TransformField.RETENTION_POLICY);
    }
}

