/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class StartTransformAction
extends ActionType<Response> {
    public static final StartTransformAction INSTANCE = new StartTransformAction();
    public static final String NAME = "cluster:admin/transform/start";

    private StartTransformAction() {
        super(NAME);
    }

    public static class Response
    extends BaseTasksResponse
    implements ToXContentObject {
        private final boolean acknowledged;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.acknowledged = in.readBoolean();
        }

        public Response(boolean acknowledged) {
            super(Collections.emptyList(), Collections.emptyList());
            this.acknowledged = acknowledged;
        }

        public boolean isAcknowledged() {
            return this.acknowledged;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.acknowledged);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.toXContentCommon(builder, params);
            builder.field("acknowledged", this.acknowledged);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response response = (Response)((Object)obj);
            return this.acknowledged == response.acknowledged;
        }

        public int hashCode() {
            return Objects.hash(this.acknowledged);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String id;
        private final Instant from;

        public Request(String id, Instant from, TimeValue timeout) {
            super(timeout);
            this.id = ExceptionsHelper.requireNonNull(id, TransformField.ID.getPreferredName());
            this.from = from;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
            this.from = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_7_0) ? in.readOptionalInstant() : null;
        }

        public String getId() {
            return this.id;
        }

        public Instant from() {
            return this.from;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_7_0)) {
                out.writeOptionalInstant(this.from);
            }
        }

        public int hashCode() {
            return Objects.hash(this.timeout(), this.id, this.from);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.id, other.id) && Objects.equals(this.from, other.from) && this.timeout().equals((Object)other.timeout());
        }
    }
}

