/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.spatial;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.spatial.action.SpatialStatsAction;

public class SpatialFeatureSetUsage
extends XPackFeatureSet.Usage {
    private final SpatialStatsAction.Response statsResponse;

    public SpatialFeatureSetUsage(SpatialStatsAction.Response statsResponse) {
        super("spatial", true, true);
        this.statsResponse = statsResponse;
    }

    public SpatialFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.statsResponse = input.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_11_0) ? new SpatialStatsAction.Response(input) : null;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_7_4_0;
    }

    SpatialStatsAction.Response statsResponse() {
        return this.statsResponse;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_11_0)) {
            this.statsResponse.writeTo(out);
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.available, this.enabled, this.statsResponse});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpatialFeatureSetUsage other = (SpatialFeatureSetUsage)obj;
        return Objects.equals((Object)this.statsResponse, (Object)other.statsResponse);
    }
}

