/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.action.admin.indices.mapping.put.TransportAutoPutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.TransportPutMappingAction;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.security.authz.RestrictedIndices;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.DocumentPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.support.StringMatcher;

public final class IndicesPermission {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(IndicesPermission.class);
    public static final IndicesPermission NONE = new IndicesPermission(new RestrictedIndices(Automatons.EMPTY), Group.EMPTY_ARRAY);
    private static final Set<String> PRIVILEGE_NAME_SET_BWC_ALLOW_MAPPING_UPDATE = Set.of("create", "create_doc", "index", "write");
    private final Map<String, IsResourceAuthorizedPredicate> allowedIndicesMatchersForAction = new ConcurrentHashMap<String, IsResourceAuthorizedPredicate>();
    private final RestrictedIndices restrictedIndices;
    private final Group[] groups;
    private final boolean hasFieldOrDocumentLevelSecurity;

    private IndicesPermission(RestrictedIndices restrictedIndices, Group[] groups) {
        this.restrictedIndices = restrictedIndices;
        this.groups = groups;
        this.hasFieldOrDocumentLevelSecurity = Arrays.stream(groups).noneMatch(Group::isTotal) && Arrays.stream(groups).anyMatch(g -> g.hasQuery() || g.fieldPermissions.hasFieldLevelSecurity());
    }

    private StringMatcher indexMatcher(Collection<String> ordinaryIndices, Collection<String> restrictedIndices) {
        Predicate<String> matcher;
        if (ordinaryIndices.isEmpty()) {
            matcher = StringMatcher.of(restrictedIndices);
        } else {
            matcher = StringMatcher.of(ordinaryIndices);
            if (this.restrictedIndices != null) {
                matcher = matcher.and("<not-restricted>", name -> !this.restrictedIndices.isRestricted((String)name));
            }
            if (!restrictedIndices.isEmpty()) {
                matcher = StringMatcher.of(restrictedIndices).or(matcher);
            }
        }
        return matcher;
    }

    public Group[] groups() {
        return this.groups;
    }

    public IsResourceAuthorizedPredicate allowedIndicesMatcher(String action) {
        return this.allowedIndicesMatchersForAction.computeIfAbsent(action, this::buildIndexMatcherPredicateForAction);
    }

    public boolean hasFieldOrDocumentLevelSecurity() {
        return this.hasFieldOrDocumentLevelSecurity;
    }

    private IsResourceAuthorizedPredicate buildIndexMatcherPredicateForAction(String action) {
        HashSet<String> ordinaryIndices = new HashSet<String>();
        HashSet<String> restrictedIndices = new HashSet<String>();
        HashSet<String> grantMappingUpdatesOnIndices = new HashSet<String>();
        HashSet<String> grantMappingUpdatesOnRestrictedIndices = new HashSet<String>();
        boolean isMappingUpdateAction = IndicesPermission.isMappingUpdateAction(action);
        for (Group group : this.groups) {
            if (group.actionMatcher.test(action)) {
                if (group.allowRestrictedIndices) {
                    restrictedIndices.addAll(Arrays.asList(group.indices()));
                    continue;
                }
                ordinaryIndices.addAll(Arrays.asList(group.indices()));
                continue;
            }
            if (!isMappingUpdateAction || !IndicesPermission.containsPrivilegeThatGrantsMappingUpdatesForBwc(group)) continue;
            if (group.allowRestrictedIndices) {
                grantMappingUpdatesOnRestrictedIndices.addAll(Arrays.asList(group.indices()));
                continue;
            }
            grantMappingUpdatesOnIndices.addAll(Arrays.asList(group.indices()));
        }
        StringMatcher nameMatcher = this.indexMatcher(ordinaryIndices, restrictedIndices);
        StringMatcher bwcSpecialCaseMatcher = this.indexMatcher(grantMappingUpdatesOnIndices, grantMappingUpdatesOnRestrictedIndices);
        return new IsResourceAuthorizedPredicate(nameMatcher, bwcSpecialCaseMatcher);
    }

    public boolean check(String action) {
        boolean isMappingUpdateAction = IndicesPermission.isMappingUpdateAction(action);
        for (Group group : this.groups) {
            if (!group.checkAction(action) && (!isMappingUpdateAction || !IndicesPermission.containsPrivilegeThatGrantsMappingUpdatesForBwc(group))) continue;
            return true;
        }
        return false;
    }

    public boolean checkResourcePrivileges(Set<String> checkForIndexPatterns, boolean allowRestrictedIndices, Set<String> checkForPrivileges, @Nullable ResourcePrivilegesMap.Builder resourcePrivilegesMapBuilder) {
        HashMap<Group, Automaton> predicateCache = new HashMap<Group, Automaton>();
        boolean allMatch = true;
        for (String forIndexPattern : checkForIndexPatterns) {
            Automaton checkIndexAutomaton = Automatons.patterns(forIndexPattern);
            if (!allowRestrictedIndices && !this.isConcreteRestrictedIndex(forIndexPattern)) {
                checkIndexAutomaton = Automatons.minusAndMinimize(checkIndexAutomaton, this.restrictedIndices.getAutomaton());
            }
            if (!Operations.isEmpty((Automaton)checkIndexAutomaton)) {
                Automaton allowedIndexPrivilegesAutomaton = null;
                for (Group group : this.groups) {
                    Automaton groupIndexAutomaton = predicateCache.computeIfAbsent(group, Group::getIndexMatcherAutomaton);
                    if (!Operations.subsetOf((Automaton)checkIndexAutomaton, (Automaton)groupIndexAutomaton)) continue;
                    allowedIndexPrivilegesAutomaton = allowedIndexPrivilegesAutomaton != null ? Automatons.unionAndMinimize(Arrays.asList(allowedIndexPrivilegesAutomaton, group.privilege().getAutomaton())) : group.privilege().getAutomaton();
                }
                for (String privilege : checkForPrivileges) {
                    IndexPrivilege indexPrivilege = IndexPrivilege.get(Collections.singleton(privilege));
                    if (allowedIndexPrivilegesAutomaton != null && Operations.subsetOf((Automaton)indexPrivilege.getAutomaton(), (Automaton)allowedIndexPrivilegesAutomaton)) {
                        if (resourcePrivilegesMapBuilder == null) continue;
                        resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.TRUE);
                        continue;
                    }
                    if (resourcePrivilegesMapBuilder != null) {
                        resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.FALSE);
                        allMatch = false;
                        continue;
                    }
                    return false;
                }
                continue;
            }
            if (resourcePrivilegesMapBuilder != null) {
                for (String privilege : checkForPrivileges) {
                    resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.FALSE);
                }
                allMatch = false;
                continue;
            }
            return false;
        }
        return allMatch;
    }

    public Automaton allowedActionsMatcher(String index) {
        ArrayList<Automaton> automatonList = new ArrayList<Automaton>();
        for (Group group : this.groups) {
            if (!group.indexNameMatcher.test(index)) continue;
            automatonList.add(group.privilege.getAutomaton());
        }
        return automatonList.isEmpty() ? Automatons.EMPTY : Automatons.unionAndMinimize(automatonList);
    }

    public IndicesAccessControl authorize(String action, Set<String> requestedIndicesOrAliases, Map<String, IndexAbstraction> lookup, FieldPermissionsCache fieldPermissionsCache) {
        if (Arrays.stream(this.groups).anyMatch(Group::isTotal)) {
            return IndicesAccessControl.allowAll();
        }
        Map resources = Maps.newMapWithExpectedSize((int)requestedIndicesOrAliases.size());
        AtomicInteger totalResourceCountHolder = new AtomicInteger(0);
        for (String indexOrAlias : requestedIndicesOrAliases) {
            IndexResource resource = new IndexResource(indexOrAlias, lookup.get(indexOrAlias));
            resources.put(resource.name, resource);
            totalResourceCountHolder.getAndAdd(resource.size());
        }
        boolean overallGranted = this.isActionGranted(action, resources);
        Supplier<Map<String, IndicesAccessControl.IndexAccessControl>> indexPermissions = () -> this.buildIndicesAccessControl(action, resources, totalResourceCountHolder.get(), fieldPermissionsCache);
        return new IndicesAccessControl(overallGranted, indexPermissions);
    }

    private Map<String, IndicesAccessControl.IndexAccessControl> buildIndicesAccessControl(String action, Map<String, IndexResource> requestedResources, int totalResourceCount, FieldPermissionsCache fieldPermissionsCache) {
        Map fieldPermissionsByIndex = Maps.newMapWithExpectedSize((int)totalResourceCount);
        Map roleQueriesByIndex = Maps.newMapWithExpectedSize((int)totalResourceCount);
        HashSet grantedResources = Sets.newHashSetWithExpectedSize((int)totalResourceCount);
        boolean isMappingUpdateAction = IndicesPermission.isMappingUpdateAction(action);
        for (IndexResource resource : requestedResources.values()) {
            boolean granted = false;
            Collection<String> concreteIndices = resource.resolveConcreteIndices();
            for (Group group : this.groups) {
                if (!resource.checkIndex(group) || !group.checkAction(action) && (!isMappingUpdateAction || resource.isPartOfDataStream() || !IndicesPermission.containsPrivilegeThatGrantsMappingUpdatesForBwc(group))) continue;
                granted = true;
                for (String index : concreteIndices) {
                    DocumentLevelPermissions docPermissions;
                    Set fieldPermissions = fieldPermissionsByIndex.compute(index, (k, existingSet) -> {
                        if (existingSet == null) {
                            return Set.of(group.getFieldPermissions());
                        }
                        if (existingSet.size() == 1) {
                            FieldPermissions fp = group.getFieldPermissions();
                            if (existingSet.contains(fp)) {
                                return existingSet;
                            }
                            HashSet<FieldPermissions> hashSet = new HashSet<FieldPermissions>((Collection<FieldPermissions>)existingSet);
                            hashSet.add(fp);
                            return hashSet;
                        }
                        existingSet.add(group.getFieldPermissions());
                        return existingSet;
                    });
                    if (group.hasQuery()) {
                        docPermissions = roleQueriesByIndex.computeIfAbsent(index, k -> new DocumentLevelPermissions());
                        docPermissions.addAll(group.getQuery());
                    } else {
                        docPermissions = DocumentLevelPermissions.ALLOW_ALL;
                        roleQueriesByIndex.put(index, docPermissions);
                    }
                    if (index.equals(resource.name)) continue;
                    fieldPermissionsByIndex.put(resource.name, fieldPermissions);
                    roleQueriesByIndex.put(resource.name, docPermissions);
                }
            }
            if (!granted) continue;
            grantedResources.add(resource.name);
            if (!resource.canHaveBackingIndices()) continue;
            for (String concreteIndex : concreteIndices) {
                if (requestedResources.containsKey(concreteIndex)) continue;
                grantedResources.add(concreteIndex);
            }
        }
        Map indexPermissions = Maps.newMapWithExpectedSize((int)grantedResources.size());
        for (String index : grantedResources) {
            DocumentLevelPermissions permissions = (DocumentLevelPermissions)roleQueriesByIndex.get(index);
            DocumentPermissions documentPermissions = permissions != null && !permissions.isAllowAll() ? DocumentPermissions.filteredBy(permissions.queries) : DocumentPermissions.allowAll();
            Set indexFieldPermissions = (Set)fieldPermissionsByIndex.get(index);
            FieldPermissions fieldPermissions = indexFieldPermissions != null && !indexFieldPermissions.isEmpty() ? (indexFieldPermissions.size() == 1 ? (FieldPermissions)indexFieldPermissions.iterator().next() : fieldPermissionsCache.union(indexFieldPermissions)) : FieldPermissions.DEFAULT;
            indexPermissions.put(index, new IndicesAccessControl.IndexAccessControl(fieldPermissions, documentPermissions));
        }
        return Collections.unmodifiableMap(indexPermissions);
    }

    private boolean isActionGranted(String action, Map<String, IndexResource> requestedResources) {
        boolean isMappingUpdateAction = IndicesPermission.isMappingUpdateAction(action);
        for (IndexResource resource : requestedResources.values()) {
            boolean granted = false;
            boolean bwcGrantMappingUpdate = false;
            ArrayList<Runnable> bwcDeprecationLogActions = new ArrayList<Runnable>();
            for (Group group : this.groups) {
                if (!resource.checkIndex(group)) continue;
                boolean actionCheck = group.checkAction(action);
                if (actionCheck) {
                    granted = true;
                    break;
                }
                boolean bwcMappingActionCheck = isMappingUpdateAction && false == resource.isPartOfDataStream() && IndicesPermission.containsPrivilegeThatGrantsMappingUpdatesForBwc(group);
                boolean bl = bwcGrantMappingUpdate = bwcGrantMappingUpdate || bwcMappingActionCheck;
                if (!bwcMappingActionCheck) continue;
                IndicesPermission.logDeprecatedBwcPrivilegeUsage(action, resource, group, bwcDeprecationLogActions);
            }
            if (!granted && bwcGrantMappingUpdate) {
                granted = true;
                bwcDeprecationLogActions.forEach(Runnable::run);
            }
            if (granted) continue;
            return false;
        }
        return true;
    }

    private static void logDeprecatedBwcPrivilegeUsage(String action, IndexResource resource, Group group, List<Runnable> bwcDeprecationLogActions) {
        for (String privilegeName : group.privilege.name()) {
            if (!PRIVILEGE_NAME_SET_BWC_ALLOW_MAPPING_UPDATE.contains(privilegeName)) continue;
            bwcDeprecationLogActions.add(() -> deprecationLogger.warn(DeprecationCategory.SECURITY, "[" + resource.name + "] mapping update for ingest privilege [" + privilegeName + "]", "the index privilege [" + privilegeName + "] allowed the update mapping action [" + action + "] on index [" + resource.name + "], this privilege will not permit mapping updates in the next major release - users who require access to update mappings must be granted explicit privileges", new Object[0]));
        }
    }

    private boolean isConcreteRestrictedIndex(String indexPattern) {
        if (Regex.isSimpleMatchPattern((String)indexPattern) || Automatons.isLuceneRegex(indexPattern)) {
            return false;
        }
        return this.restrictedIndices.isRestricted(indexPattern);
    }

    private static boolean isMappingUpdateAction(String action) {
        return action.equals(TransportPutMappingAction.TYPE.name()) || action.equals(TransportAutoPutMappingAction.TYPE.name());
    }

    private static boolean containsPrivilegeThatGrantsMappingUpdatesForBwc(Group group) {
        return group.privilege().name().stream().anyMatch(PRIVILEGE_NAME_SET_BWC_ALLOW_MAPPING_UPDATE::contains);
    }

    public static class Group {
        public static final Group[] EMPTY_ARRAY = new Group[0];
        private final IndexPrivilege privilege;
        private final Predicate<String> actionMatcher;
        private final String[] indices;
        private final StringMatcher indexNameMatcher;
        private final Supplier<Automaton> indexNameAutomaton;
        private final FieldPermissions fieldPermissions;
        private final Set<BytesReference> query;
        private final boolean allowRestrictedIndices;

        public Group(IndexPrivilege privilege, FieldPermissions fieldPermissions, @Nullable Set<BytesReference> query, boolean allowRestrictedIndices, RestrictedIndices restrictedIndices, String ... indices) {
            assert (indices.length != 0);
            this.privilege = privilege;
            this.actionMatcher = privilege.predicate();
            this.indices = indices;
            this.allowRestrictedIndices = allowRestrictedIndices;
            ConcurrentHashMap indexNameAutomatonMemo = new ConcurrentHashMap(1);
            if (allowRestrictedIndices) {
                this.indexNameMatcher = StringMatcher.of(indices);
                this.indexNameAutomaton = () -> indexNameAutomatonMemo.computeIfAbsent(indices, k -> Automatons.patterns(indices));
            } else {
                this.indexNameMatcher = StringMatcher.of(indices).and(name -> !restrictedIndices.isRestricted((String)name));
                this.indexNameAutomaton = () -> indexNameAutomatonMemo.computeIfAbsent(indices, k -> Automatons.minusAndMinimize(Automatons.patterns(indices), restrictedIndices.getAutomaton()));
            }
            this.fieldPermissions = Objects.requireNonNull(fieldPermissions);
            this.query = query;
        }

        public IndexPrivilege privilege() {
            return this.privilege;
        }

        public String[] indices() {
            return this.indices;
        }

        @Nullable
        public Set<BytesReference> getQuery() {
            return this.query;
        }

        public FieldPermissions getFieldPermissions() {
            return this.fieldPermissions;
        }

        private boolean checkAction(String action) {
            return this.actionMatcher.test(action);
        }

        private boolean checkIndex(String index) {
            assert (index != null);
            return this.indexNameMatcher.test(index);
        }

        boolean hasQuery() {
            return this.query != null;
        }

        public boolean allowRestrictedIndices() {
            return this.allowRestrictedIndices;
        }

        public Automaton getIndexMatcherAutomaton() {
            return this.indexNameAutomaton.get();
        }

        boolean isTotal() {
            return this.allowRestrictedIndices && this.indexNameMatcher.isTotal() && this.privilege == IndexPrivilege.ALL && this.query == null && false == this.fieldPermissions.hasFieldLevelSecurity();
        }

        public String toString() {
            return "Group{privilege=" + this.privilege + ", indices=" + Strings.arrayToCommaDelimitedString((Object[])this.indices) + ", fieldPermissions=" + this.fieldPermissions + ", query=" + this.query + ", allowRestrictedIndices=" + this.allowRestrictedIndices + "}";
        }
    }

    public static class IsResourceAuthorizedPredicate
    implements BiPredicate<String, IndexAbstraction> {
        private final BiPredicate<String, IndexAbstraction> biPredicate;

        public IsResourceAuthorizedPredicate(StringMatcher resourceNameMatcher, StringMatcher additionalNonDatastreamNameMatcher) {
            this((name, indexAbstraction) -> {
                assert (indexAbstraction == null || name.equals(indexAbstraction.getName()));
                return resourceNameMatcher.test((String)name) || !IsResourceAuthorizedPredicate.isPartOfDatastream(indexAbstraction) && additionalNonDatastreamNameMatcher.test((String)name);
            });
        }

        private IsResourceAuthorizedPredicate(BiPredicate<String, IndexAbstraction> biPredicate) {
            this.biPredicate = biPredicate;
        }

        public final IsResourceAuthorizedPredicate and(BiPredicate<? super String, ? super IndexAbstraction> other) {
            return new IsResourceAuthorizedPredicate(this.biPredicate.and(other));
        }

        public final boolean test(IndexAbstraction indexAbstraction) {
            return this.test(indexAbstraction.getName(), indexAbstraction);
        }

        @Override
        public boolean test(String name, @Nullable IndexAbstraction indexAbstraction) {
            return this.biPredicate.test(name, indexAbstraction);
        }

        private static boolean isPartOfDatastream(IndexAbstraction indexAbstraction) {
            return indexAbstraction != null && (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM || indexAbstraction.getParentDataStream() != null);
        }
    }

    private static class IndexResource {
        private final String name;
        @Nullable
        private final IndexAbstraction indexAbstraction;

        private IndexResource(String name, @Nullable IndexAbstraction abstraction) {
            assert (name != null) : "Resource name cannot be null";
            assert (abstraction == null || abstraction.getName().equals(name)) : "Index abstraction has unexpected name [" + abstraction.getName() + "] vs [" + name + "]";
            this.name = name;
            this.indexAbstraction = abstraction;
        }

        public boolean isPartOfDataStream() {
            if (this.indexAbstraction == null) {
                return false;
            }
            return switch (this.indexAbstraction.getType()) {
                case IndexAbstraction.Type.DATA_STREAM -> true;
                case IndexAbstraction.Type.CONCRETE_INDEX -> {
                    if (this.indexAbstraction.getParentDataStream() != null) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public boolean checkIndex(Group group) {
            DataStream ds;
            DataStream dataStream = ds = this.indexAbstraction == null ? null : this.indexAbstraction.getParentDataStream();
            if (ds != null && group.checkIndex(ds.getName())) {
                return true;
            }
            return group.checkIndex(this.name);
        }

        public int size() {
            if (this.indexAbstraction == null) {
                return 1;
            }
            if (this.indexAbstraction.getType() == IndexAbstraction.Type.CONCRETE_INDEX) {
                return 1;
            }
            return 1 + this.indexAbstraction.getIndices().size();
        }

        public Collection<String> resolveConcreteIndices() {
            if (this.indexAbstraction == null) {
                return List.of();
            }
            if (this.indexAbstraction.getType() == IndexAbstraction.Type.CONCRETE_INDEX) {
                return List.of(this.indexAbstraction.getName());
            }
            List indices = this.indexAbstraction.getIndices();
            ArrayList<String> concreteIndexNames = new ArrayList<String>(indices.size());
            for (Index idx : indices) {
                concreteIndexNames.add(idx.getName());
            }
            return concreteIndexNames;
        }

        public boolean canHaveBackingIndices() {
            return this.indexAbstraction != null && this.indexAbstraction.getType() != IndexAbstraction.Type.CONCRETE_INDEX;
        }
    }

    private static class DocumentLevelPermissions {
        public static final DocumentLevelPermissions ALLOW_ALL = new DocumentLevelPermissions();
        private Set<BytesReference> queries = null;
        private boolean allowAll = false;

        private DocumentLevelPermissions() {
        }

        private void addAll(Set<BytesReference> query) {
            if (!this.allowAll) {
                if (this.queries == null) {
                    this.queries = Sets.newHashSetWithExpectedSize((int)query.size());
                }
                this.queries.addAll(query);
            }
        }

        private boolean isAllowAll() {
            return this.allowAll;
        }

        static {
            DocumentLevelPermissions.ALLOW_ALL.allowAll = true;
        }
    }

    public static class Builder {
        RestrictedIndices restrictedIndices;
        List<Group> groups = new ArrayList<Group>();

        public Builder(RestrictedIndices restrictedIndices) {
            this.restrictedIndices = restrictedIndices;
        }

        public Builder addGroup(IndexPrivilege privilege, FieldPermissions fieldPermissions, @Nullable Set<BytesReference> query, boolean allowRestrictedIndices, String ... indices) {
            this.groups.add(new Group(privilege, fieldPermissions, query, allowRestrictedIndices, this.restrictedIndices, indices));
            return this;
        }

        public IndicesPermission build() {
            return new IndicesPermission(this.restrictedIndices, this.groups.toArray(Group.EMPTY_ARRAY));
        }
    }
}

