/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support;

import java.util.Collection;
import java.util.List;

public final class SecuritySettingsUtil {
    public static void verifyNonNullNotEmpty(String settingKey, String settingValue) {
        SecuritySettingsUtil.verifyNonNullNotEmpty(settingKey, settingValue, null);
    }

    public static void verifyNonNullNotEmpty(String settingKey, String settingValue, Collection<String> allowedValues) {
        assert (settingValue != null) : "Invalid null value for [" + settingKey + "].";
        if (settingValue.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty value for [" + settingKey + "].");
        }
        if (allowedValues != null && !allowedValues.contains(settingValue)) {
            throw new IllegalArgumentException("Invalid value [" + settingValue + "] for [" + settingKey + "]. Allowed values are " + allowedValues + ".");
        }
    }

    public static void verifyNonNullNotEmpty(String settingKey, List<String> settingValues) {
        SecuritySettingsUtil.verifyNonNullNotEmpty(settingKey, settingValues, null);
    }

    public static void verifyNonNullNotEmpty(String settingKey, List<String> settingValues, Collection<String> allowedValues) {
        assert (settingValues != null) : "Invalid null list of values for [" + settingKey + "].";
        if (settingValues.isEmpty()) {
            if (allowedValues == null) {
                throw new IllegalArgumentException("Invalid empty list for [" + settingKey + "].");
            }
            throw new IllegalArgumentException("Invalid empty list for [" + settingKey + "]. Allowed values are " + allowedValues + ".");
        }
        for (String settingValue : settingValues) {
            SecuritySettingsUtil.verifyNonNullNotEmpty(settingKey, settingValue, allowedValues);
        }
    }

    private SecuritySettingsUtil() {
        throw new IllegalAccessError("not allowed!");
    }
}

