/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.packageloader.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ModelPackageConfig;

public class GetTrainedModelPackageConfigAction
extends ActionType<Response> {
    public static final String NAME = "cluster:internal/xpack/ml/trained_models/package_loader/get_config";
    public static final GetTrainedModelPackageConfigAction INSTANCE = new GetTrainedModelPackageConfigAction();

    private GetTrainedModelPackageConfigAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse {
        private final ModelPackageConfig modelPackageConfig;

        public Response(ModelPackageConfig modelPackageConfig) {
            this.modelPackageConfig = modelPackageConfig;
        }

        public Response(StreamInput in) throws IOException {
            this.modelPackageConfig = new ModelPackageConfig(in);
        }

        public ModelPackageConfig getModelPackageConfig() {
            return this.modelPackageConfig;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.modelPackageConfig.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.modelPackageConfig, response.modelPackageConfig);
        }

        public int hashCode() {
            return Objects.hash(this.modelPackageConfig);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final String packagedModelId;

        public Request(String packagedModelId) {
            this.packagedModelId = packagedModelId;
        }

        public Request(StreamInput in) throws IOException {
            this.packagedModelId = in.readString();
        }

        public String getPackagedModelId() {
            return this.packagedModelId;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.packagedModelId);
        }

        public int hashCode() {
            return Objects.hash(this.packagedModelId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.packagedModelId, other.packagedModelId);
        }
    }
}

