/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;

public class TokenizationConfigUpdate
implements InferenceConfigUpdate {
    public static final String NAME = "tokenization_update";
    private final Tokenization.SpanSettings spanSettings;

    public TokenizationConfigUpdate(@Nullable Integer maxSequenceLength, @Nullable Integer span) {
        this(span == null ? new Tokenization.SpanSettings(maxSequenceLength) : new Tokenization.SpanSettings(maxSequenceLength, span));
    }

    private TokenizationConfigUpdate(Tokenization.SpanSettings spanSettings) {
        this.spanSettings = spanSettings;
    }

    public TokenizationConfigUpdate(StreamInput in) throws IOException {
        this.spanSettings = new Tokenization.SpanSettings(in);
    }

    public Tokenization.SpanSettings getSpanSettings() {
        return this.spanSettings;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.spanSettings.writeTo(out);
    }

    @Override
    public boolean isSupported(InferenceConfig config) {
        return true;
    }

    @Override
    public String getResultsField() {
        return null;
    }

    @Override
    public InferenceConfigUpdate.Builder<? extends InferenceConfigUpdate.Builder<?, ?>, ? extends InferenceConfigUpdate> newBuilder() {
        throw new UnsupportedOperationException("Tokenization update is not supported as a builder");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenizationConfigUpdate that = (TokenizationConfigUpdate)o;
        return Objects.equals(this.spanSettings, that.spanSettings);
    }

    public int hashCode() {
        return Objects.hash(this.spanSettings);
    }
}

