/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.results.ChunkedNlpInferenceResults;

public class ChunkedTextEmbeddingResults
extends ChunkedNlpInferenceResults {
    public static final String NAME = "chunked_text_embedding_result";
    private final String resultsField;
    private final List<EmbeddingChunk> chunks;

    public ChunkedTextEmbeddingResults(String resultsField, List<EmbeddingChunk> embeddings, boolean isTruncated) {
        super(isTruncated);
        this.resultsField = resultsField;
        this.chunks = embeddings;
    }

    public ChunkedTextEmbeddingResults(StreamInput in) throws IOException {
        super(in);
        this.resultsField = in.readString();
        this.chunks = in.readCollectionAsList(EmbeddingChunk::new);
    }

    public String getWriteableName() {
        return NAME;
    }

    public String getResultsField() {
        return this.resultsField;
    }

    public Object predictedValue() {
        throw new UnsupportedOperationException("[chunked_text_embedding_result] does not support a single predicted value");
    }

    public List<EmbeddingChunk> getChunks() {
        return this.chunks;
    }

    @Override
    void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(this.resultsField);
        for (EmbeddingChunk chunk : this.chunks) {
            chunk.toXContent(builder, params);
        }
        builder.endArray();
    }

    @Override
    void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.resultsField);
        out.writeCollection(this.chunks);
    }

    @Override
    void addMapFields(Map<String, Object> map) {
        map.put(this.resultsField, this.chunks.stream().map(EmbeddingChunk::asMap).collect(Collectors.toList()));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChunkedTextEmbeddingResults that = (ChunkedTextEmbeddingResults)o;
        return Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.chunks, that.chunks);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resultsField, this.chunks);
    }

    public record EmbeddingChunk(String matchedText, double[] embedding) implements Writeable,
    ToXContentObject
    {
        public EmbeddingChunk(StreamInput in) throws IOException {
            this(in.readString(), in.readDoubleArray());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.matchedText);
            out.writeDoubleArray(this.embedding);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ChunkedNlpInferenceResults.TEXT, this.matchedText);
            builder.field(ChunkedNlpInferenceResults.INFERENCE, (Object)this.embedding);
            builder.endObject();
            return builder;
        }

        public Map<String, Object> asMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ChunkedNlpInferenceResults.TEXT, this.matchedText);
            map.put(ChunkedNlpInferenceResults.INFERENCE, this.embedding);
            return map;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EmbeddingChunk that = (EmbeddingChunk)o;
            return Objects.equals(this.matchedText, that.matchedText) && Arrays.equals(this.embedding, that.embedding);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.matchedText, Arrays.hashCode(this.embedding));
        }
    }
}

