/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingInfoUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class UpdateTrainedModelAssignmentRoutingInfoAction
extends ActionType<AcknowledgedResponse> {
    public static final UpdateTrainedModelAssignmentRoutingInfoAction INSTANCE = new UpdateTrainedModelAssignmentRoutingInfoAction();
    public static final String NAME = "cluster:internal/xpack/ml/model_allocation/update";

    private UpdateTrainedModelAssignmentRoutingInfoAction() {
        super(NAME);
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final String nodeId;
        private final String deploymentId;
        private final RoutingInfoUpdate update;

        public Request(String nodeId, String deploymentId, RoutingInfoUpdate update) {
            this.nodeId = ExceptionsHelper.requireNonNull(nodeId, "node_id");
            this.deploymentId = ExceptionsHelper.requireNonNull(deploymentId, "deployment_id");
            this.update = ExceptionsHelper.requireNonNull(update, "update");
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.nodeId = in.readString();
            this.deploymentId = in.readString();
            this.update = new RoutingInfoUpdate(in);
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public RoutingInfoUpdate getUpdate() {
            return this.update;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.nodeId);
            out.writeString(this.deploymentId);
            this.update.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.nodeId, request.nodeId) && Objects.equals(this.deploymentId, request.deploymentId) && Objects.equals(this.update, request.update);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.deploymentId, this.update);
        }

        public String toString() {
            return "Request{nodeId='" + this.nodeId + "', deploymentId='" + this.deploymentId + "', update=" + this.update + "}";
        }
    }
}

