/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;

public class PutCalendarAction
extends ActionType<Response> {
    public static final PutCalendarAction INSTANCE = new PutCalendarAction();
    public static final String NAME = "cluster:admin/xpack/ml/calendars/put";

    private PutCalendarAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final Calendar calendar;

        public Response(Calendar calendar) {
            this.calendar = calendar;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.calendar.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.calendar.toXContent(builder, params);
        }

        public int hashCode() {
            return Objects.hash(this.calendar);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.calendar, other.calendar);
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        private Calendar calendar;

        public static Request parseRequest(String calendarId, XContentParser parser) {
            Calendar.Builder builder = (Calendar.Builder)Calendar.STRICT_PARSER.apply(parser, null);
            if (builder.getId() == null) {
                builder.setId(calendarId);
            } else if (!Strings.isNullOrEmpty((String)calendarId) && !calendarId.equals(builder.getId())) {
                throw new IllegalArgumentException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", Calendar.ID.getPreferredName(), builder.getId(), calendarId));
            }
            return new Request(builder.build());
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.calendar = new Calendar(in);
        }

        public Request(Calendar calendar) {
            this.calendar = ExceptionsHelper.requireNonNull(calendar, "calendar");
        }

        public Calendar getCalendar() {
            return this.calendar;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if ("_all".equals(this.calendar.getId())) {
                validationException = ValidateActions.addValidationError((String)"Cannot create a Calendar with the reserved name [_all]", validationException);
            }
            if (!MlStrings.isValidId(this.calendar.getId())) {
                validationException = ValidateActions.addValidationError((String)Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", Calendar.ID.getPreferredName(), this.calendar.getId()), (ActionRequestValidationException)validationException);
            }
            if (!MlStrings.hasValidLengthForId(this.calendar.getId())) {
                validationException = ValidateActions.addValidationError((String)Messages.getMessage("The job id cannot contain more than {0,number,integer} characters.", 64), (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.calendar.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.calendar.toXContent(builder, params);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.calendar);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.calendar, other.calendar);
        }
    }
}

