/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.SparseEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingUtils;
import org.elasticsearch.xpack.core.ml.inference.results.ChunkedTextExpansionResults;
import org.elasticsearch.xpack.core.ml.inference.results.TextExpansionResults;

public class ChunkedSparseEmbeddingResults
implements ChunkedInferenceServiceResults {
    public static final String NAME = "chunked_sparse_embedding_results";
    public static final String FIELD_NAME = "sparse_embedding_chunk";
    private final List<ChunkedTextExpansionResults.ChunkedResult> chunkedResults;

    public static ChunkedSparseEmbeddingResults ofMlResult(ChunkedTextExpansionResults mlInferenceResults) {
        return new ChunkedSparseEmbeddingResults(mlInferenceResults.getChunks());
    }

    public static List<ChunkedInferenceServiceResults> of(List<String> inputs, SparseEmbeddingResults sparseEmbeddingResults) {
        TextEmbeddingUtils.validateInputSizeAgainstEmbeddings(inputs, sparseEmbeddingResults.embeddings().size());
        ArrayList<ChunkedInferenceServiceResults> results = new ArrayList<ChunkedInferenceServiceResults>(inputs.size());
        for (int i = 0; i < inputs.size(); ++i) {
            results.add(ChunkedSparseEmbeddingResults.of(inputs.get(i), sparseEmbeddingResults.embeddings().get(i)));
        }
        return results;
    }

    public static ChunkedSparseEmbeddingResults of(String input, SparseEmbeddingResults.Embedding embedding) {
        List<TextExpansionResults.WeightedToken> weightedTokens = embedding.tokens().stream().map(weightedToken -> new TextExpansionResults.WeightedToken(weightedToken.token(), weightedToken.weight())).toList();
        return new ChunkedSparseEmbeddingResults(List.of(new ChunkedTextExpansionResults.ChunkedResult(input, weightedTokens)));
    }

    public ChunkedSparseEmbeddingResults(List<ChunkedTextExpansionResults.ChunkedResult> chunks) {
        this.chunkedResults = chunks;
    }

    public ChunkedSparseEmbeddingResults(StreamInput in) throws IOException {
        this.chunkedResults = in.readCollectionAsList(ChunkedTextExpansionResults.ChunkedResult::new);
    }

    public List<ChunkedTextExpansionResults.ChunkedResult> getChunkedResults() {
        return this.chunkedResults;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(FIELD_NAME);
        for (ChunkedTextExpansionResults.ChunkedResult chunk : this.chunkedResults) {
            chunk.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.chunkedResults);
    }

    public List<? extends InferenceResults> transformToCoordinationFormat() {
        throw new UnsupportedOperationException("Chunked results are not returned in the coordindated action");
    }

    public List<? extends InferenceResults> transformToLegacyFormat() {
        throw new UnsupportedOperationException("Chunked results are not returned in the legacy format");
    }

    public Map<String, Object> asMap() {
        return Map.of(FIELD_NAME, this.chunkedResults.stream().map(ChunkedTextExpansionResults.ChunkedResult::asMap).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkedSparseEmbeddingResults that = (ChunkedSparseEmbeddingResults)o;
        return Objects.equals(this.chunkedResults, that.chunkedResults);
    }

    public int hashCode() {
        return Objects.hash(this.chunkedResults);
    }
}

