/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class PauseFollowAction
extends ActionType<AcknowledgedResponse> {
    public static final PauseFollowAction INSTANCE = new PauseFollowAction();
    public static final String NAME = "cluster:admin/xpack/ccr/pause_follow";

    private PauseFollowAction() {
        super(NAME);
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final String followIndex;

        public Request(String followIndex) {
            this.followIndex = Objects.requireNonNull(followIndex, "followIndex");
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.followIndex = in.readString();
        }

        public String getFollowIndex() {
            return this.followIndex;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.followIndex);
        }
    }
}

