/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.crypto.SecretKeyFactory;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslClientAuthenticationMode;
import org.elasticsearch.common.ssl.SslVerificationMode;
import org.elasticsearch.core.Strings;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public class XPackSettings {
    public static final Setting<Boolean> CCR_ENABLED_SETTING = Setting.boolSetting((String)"xpack.ccr.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> SECURITY_ENABLED = Setting.boolSetting((String)"xpack.security.enabled", (boolean)true, (Setting.Validator)new Setting.Validator<Boolean>(){

        public void validate(Boolean value) {
        }

        public void validate(Boolean value, Map<Setting<?>, Object> settings, boolean isPresent) {
            boolean remoteClusterServerEnabled = (Boolean)settings.get(RemoteClusterPortSettings.REMOTE_CLUSTER_SERVER_ENABLED);
            if (remoteClusterServerEnabled && !value.booleanValue()) {
                throw new IllegalArgumentException(Strings.format((String)"Security [%s] must be enabled to use the remote cluster server feature", (Object[])new Object[]{SECURITY_ENABLED.getKey()}));
            }
        }

        public Iterator<Setting<?>> settings() {
            return List.of(RemoteClusterPortSettings.REMOTE_CLUSTER_SERVER_ENABLED).iterator();
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> WATCHER_ENABLED = Setting.boolSetting((String)"xpack.watcher.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> GRAPH_ENABLED = Setting.boolSetting((String)"xpack.graph.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> MACHINE_LEARNING_ENABLED = Setting.boolSetting((String)"xpack.ml.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> PROFILING_ENABLED = Setting.boolSetting((String)"xpack.profiling.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> APM_DATA_ENABLED = Setting.boolSetting((String)"xpack.apm_data.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> ENTERPRISE_SEARCH_ENABLED = Setting.boolSetting((String)"xpack.ent_search.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> AUDIT_ENABLED = Setting.boolSetting((String)"xpack.security.audit.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> DLS_FLS_ENABLED = Setting.boolSetting((String)"xpack.security.dls_fls.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> TRANSPORT_SSL_ENABLED = Setting.boolSetting((String)"xpack.security.transport.ssl.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> HTTP_SSL_ENABLED = Setting.boolSetting((String)"xpack.security.http.ssl.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> RESERVED_REALM_ENABLED_SETTING = Setting.boolSetting((String)"xpack.security.authc.reserved_realm.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> TOKEN_SERVICE_ENABLED_SETTING = Setting.boolSetting((String)"xpack.security.authc.token.enabled", HTTP_SSL_ENABLED, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> API_KEY_SERVICE_ENABLED_SETTING = Setting.boolSetting((String)"xpack.security.authc.api_key.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> FIPS_MODE_ENABLED = Setting.boolSetting((String)"xpack.security.fips_mode.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> FIPS_REQUIRED_PROVIDERS = Setting.stringListSetting((String)"xpack.security.fips_mode.required_providers", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> ENROLLMENT_ENABLED = Setting.boolSetting((String)"xpack.security.enrollment.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> SECURITY_AUTOCONFIGURATION_ENABLED = Setting.boolSetting((String)"xpack.security.autoconfiguration.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final List<String> JDK12_CIPHERS = List.of("TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256", "TLS_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA");
    public static final List<String> DEFAULT_CIPHERS = JDK12_CIPHERS;
    public static final Setting<String> PASSWORD_HASHING_ALGORITHM = XPackSettings.defaultStoredHashAlgorithmSetting("xpack.security.authc.password_hashing.algorithm", s -> {
        if (((Boolean)FIPS_MODE_ENABLED.get(s)).booleanValue()) {
            return Hasher.PBKDF2_STRETCH.name();
        }
        return Hasher.BCRYPT.name();
    });
    public static final Setting<String> SERVICE_TOKEN_HASHING_ALGORITHM = XPackSettings.defaultStoredHashAlgorithmSetting("xpack.security.authc.service_token_hashing.algorithm", s -> Hasher.PBKDF2_STRETCH.name());
    public static final List<String> DEFAULT_SUPPORTED_PROTOCOLS = Arrays.asList("TLSv1.3", "TLSv1.2", "TLSv1.1");
    public static final SslClientAuthenticationMode CLIENT_AUTH_DEFAULT = SslClientAuthenticationMode.REQUIRED;
    public static final SslClientAuthenticationMode HTTP_CLIENT_AUTH_DEFAULT = SslClientAuthenticationMode.NONE;
    public static final SslClientAuthenticationMode REMOTE_CLUSTER_CLIENT_AUTH_DEFAULT = SslClientAuthenticationMode.NONE;
    public static final SslVerificationMode VERIFICATION_MODE_DEFAULT = SslVerificationMode.FULL;
    public static final String HTTP_SSL_PREFIX = SecurityField.setting("http.ssl.");
    private static final SSLConfigurationSettings HTTP_SSL = SSLConfigurationSettings.withPrefix(HTTP_SSL_PREFIX, true);
    public static final String TRANSPORT_SSL_PREFIX = SecurityField.setting("transport.ssl.");
    private static final SSLConfigurationSettings TRANSPORT_SSL = SSLConfigurationSettings.withPrefix(TRANSPORT_SSL_PREFIX, true);
    public static final String REMOTE_CLUSTER_SERVER_SSL_PREFIX = SecurityField.setting("remote_cluster_server.ssl.");
    public static final String REMOTE_CLUSTER_CLIENT_SSL_PREFIX = SecurityField.setting("remote_cluster_client.ssl.");
    private static final SSLConfigurationSettings REMOTE_CLUSTER_SERVER_SSL = SSLConfigurationSettings.withPrefix(REMOTE_CLUSTER_SERVER_SSL_PREFIX, false);
    private static final SSLConfigurationSettings REMOTE_CLUSTER_CLIENT_SSL = SSLConfigurationSettings.withPrefix(REMOTE_CLUSTER_CLIENT_SSL_PREFIX, false);
    public static final Setting<Boolean> REMOTE_CLUSTER_SERVER_SSL_ENABLED = Setting.boolSetting((String)(REMOTE_CLUSTER_SERVER_SSL_PREFIX + "enabled"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> REMOTE_CLUSTER_CLIENT_SSL_ENABLED = Setting.boolSetting((String)(REMOTE_CLUSTER_CLIENT_SSL_PREFIX + "enabled"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    private XPackSettings() {
        throw new IllegalStateException("Utility class should not be instantiated");
    }

    public static Setting<String> defaultStoredHashAlgorithmSetting(String key, Function<Settings, String> defaultHashingAlgorithm) {
        return new Setting((Setting.Key)new Setting.SimpleKey(key), defaultHashingAlgorithm, Function.identity(), v -> {
            if (!Hasher.getAvailableAlgoStoredHash().contains(v.toLowerCase(Locale.ROOT))) {
                throw new IllegalArgumentException("Invalid algorithm: " + v + ". Valid values for password hashing are " + Hasher.getAvailableAlgoStoredHash().toString());
            }
            if (v.regionMatches(true, 0, "pbkdf2", 0, "pbkdf2".length())) {
                try {
                    SecretKeyFactory.getInstance("PBKDF2withHMACSHA512");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalArgumentException("Support for PBKDF2WithHMACSHA512 must be available in order to use any of the PBKDF2 algorithms for the [" + key + "] setting.", e);
                }
            }
        }, new Setting.Property[]{Setting.Property.NodeScope});
    }

    public static List<Setting<?>> getAllSettings() {
        ArrayList<Object> settings = new ArrayList<Object>();
        settings.addAll(HTTP_SSL.getEnabledSettings());
        settings.addAll(TRANSPORT_SSL.getEnabledSettings());
        settings.addAll(REMOTE_CLUSTER_SERVER_SSL.getEnabledSettings());
        settings.addAll(REMOTE_CLUSTER_CLIENT_SSL.getEnabledSettings());
        settings.add(SECURITY_ENABLED);
        settings.add(GRAPH_ENABLED);
        settings.add(MACHINE_LEARNING_ENABLED);
        settings.add(PROFILING_ENABLED);
        settings.add(APM_DATA_ENABLED);
        settings.add(ENTERPRISE_SEARCH_ENABLED);
        settings.add(AUDIT_ENABLED);
        settings.add(WATCHER_ENABLED);
        settings.add(DLS_FLS_ENABLED);
        settings.add(TRANSPORT_SSL_ENABLED);
        settings.add(HTTP_SSL_ENABLED);
        settings.add(REMOTE_CLUSTER_SERVER_SSL_ENABLED);
        settings.add(REMOTE_CLUSTER_CLIENT_SSL_ENABLED);
        settings.add(RESERVED_REALM_ENABLED_SETTING);
        settings.add(TOKEN_SERVICE_ENABLED_SETTING);
        settings.add(API_KEY_SERVICE_ENABLED_SETTING);
        settings.add(SecurityField.USER_SETTING);
        settings.add(PASSWORD_HASHING_ALGORITHM);
        settings.add(ENROLLMENT_ENABLED);
        settings.add(SECURITY_AUTOCONFIGURATION_ENABLED);
        settings.add(RealmSettings.DOMAIN_TO_REALM_ASSOC_SETTING);
        settings.add(RealmSettings.DOMAIN_UID_LITERAL_USERNAME_SETTING);
        settings.add(RealmSettings.DOMAIN_UID_SUFFIX_SETTING);
        return Collections.unmodifiableList(settings);
    }
}

