/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.license.ClusterStateLicenseService;
import org.elasticsearch.license.GetTrialStatusRequest;
import org.elasticsearch.license.GetTrialStatusResponse;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicensesMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetTrialStatusAction
extends TransportMasterNodeReadAction<GetTrialStatusRequest, GetTrialStatusResponse> {
    private final LicenseService licenseService;

    @Inject
    public TransportGetTrialStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, LicenseService licenseService) {
        super("cluster:admin/xpack/license/trial_status", transportService, clusterService, threadPool, actionFilters, GetTrialStatusRequest::new, indexNameExpressionResolver, GetTrialStatusResponse::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseService = licenseService;
    }

    protected void masterOperation(Task task, GetTrialStatusRequest request, ClusterState state, ActionListener<GetTrialStatusResponse> listener) throws Exception {
        if (this.licenseService instanceof ClusterStateLicenseService) {
            LicensesMetadata licensesMetadata = (LicensesMetadata)state.metadata().custom("licenses");
            listener.onResponse((Object)new GetTrialStatusResponse(licensesMetadata == null || licensesMetadata.isEligibleForTrial()));
        } else {
            listener.onResponse((Object)new GetTrialStatusResponse(false));
        }
    }

    protected ClusterBlockException checkBlock(GetTrialStatusRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

