/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectortile.feature;

import com.wdtinc.mapbox_vector_tile.VectorTile;
import com.wdtinc.mapbox_vector_tile.adapt.jts.IUserDataConverter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.JtsAdapter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.UserDataIgnoreConverter;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerProps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.SimpleFeatureFactory;
import org.elasticsearch.common.geo.SphericalMercatorUtils;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xpack.vectortile.feature.PatchedJtsAdapter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;

public class FeatureFactory {
    private final IUserDataConverter userDataIgnoreConverter = new UserDataIgnoreConverter();
    private final MvtLayerProps layerProps = new MvtLayerProps();
    private final MVTGeometryBuilder mvtGeometryBuilder;
    private final SimpleFeatureFactory simpleFeatureFactory;

    public FeatureFactory(int z, int x, int y, int extent, int padPixels) {
        GeometryFactory geomFactory = new GeometryFactory();
        double pixelPrecision = 4.007501668E7 / (double)((1L << z) * (long)extent);
        Rectangle r = SphericalMercatorUtils.recToSphericalMercator((Rectangle)GeoTileUtils.toBoundingBox((int)x, (int)y, (int)z));
        Envelope tileEnvelope = new Envelope(r.getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY());
        Envelope clipEnvelope = new Envelope(tileEnvelope);
        clipEnvelope.expandBy((double)padPixels * pixelPrecision, (double)padPixels * pixelPrecision);
        org.locationtech.jts.geom.Geometry clipTile = geomFactory.toGeometry(clipEnvelope);
        MvtCoordinateSequenceFilter sequenceFilter = new MvtCoordinateSequenceFilter(tileEnvelope, extent);
        this.mvtGeometryBuilder = new MVTGeometryBuilder(geomFactory, clipTile, pixelPrecision, sequenceFilter);
        this.simpleFeatureFactory = new SimpleFeatureFactory(z, x, y, extent);
    }

    public byte[] point(double lon, double lat) throws IOException {
        return this.simpleFeatureFactory.point(lon, lat);
    }

    public byte[] box(double minLon, double maxLon, double minLat, double maxLat) throws IOException {
        return this.simpleFeatureFactory.box(minLon, maxLon, minLat, maxLat);
    }

    public byte[] points(List<GeoPoint> multiPoint) {
        return this.simpleFeatureFactory.points(multiPoint);
    }

    public List<byte[]> getFeatures(Geometry geometry) {
        org.locationtech.jts.geom.Geometry mvtGeometry = (org.locationtech.jts.geom.Geometry)geometry.visit((GeometryVisitor)this.mvtGeometryBuilder);
        if (mvtGeometry == null) {
            return List.of();
        }
        List<VectorTile.Tile.Feature> features = PatchedJtsAdapter.toFeatures(JtsAdapter.flatFeatureList((org.locationtech.jts.geom.Geometry)mvtGeometry), this.layerProps, this.userDataIgnoreConverter);
        ArrayList<byte[]> byteFeatures = new ArrayList<byte[]>(features.size());
        features.forEach(f -> byteFeatures.add(f.toByteArray()));
        return byteFeatures;
    }

    private static class MvtCoordinateSequenceFilter
    implements CoordinateSequenceFilter {
        private final int extent;
        private final double pointXScale;
        private final double pointYScale;
        private final double pointXTranslate;
        private final double pointYTranslate;

        private MvtCoordinateSequenceFilter(Envelope tileEnvelope, int extent) {
            this.extent = extent;
            this.pointXScale = (double)extent / tileEnvelope.getWidth();
            this.pointYScale = (double)(-extent) / tileEnvelope.getHeight();
            this.pointXTranslate = -this.pointXScale * tileEnvelope.getMinX();
            this.pointYTranslate = -this.pointYScale * tileEnvelope.getMinY();
        }

        public void filter(CoordinateSequence seq, int i) {
            seq.setOrdinate(i, 0, (double)this.lon(seq.getOrdinate(i, 0)));
            seq.setOrdinate(i, 1, (double)this.lat(seq.getOrdinate(i, 1)));
        }

        public boolean isDone() {
            return false;
        }

        public boolean isGeometryChanged() {
            return true;
        }

        private int lat(double lat) {
            return (int)Math.round(this.pointYScale * lat + this.pointYTranslate) + this.extent;
        }

        private int lon(double lon) {
            return (int)Math.round(this.pointXScale * lon + this.pointXTranslate);
        }
    }

    private record MVTGeometryBuilder(GeometryFactory geomFactory, org.locationtech.jts.geom.Geometry clipTile, double pixelPrecision, CoordinateSequenceFilter sequenceFilter) implements GeometryVisitor<org.locationtech.jts.geom.Geometry, IllegalArgumentException>
    {
        public org.locationtech.jts.geom.Geometry visit(Circle circle) {
            throw new IllegalArgumentException("Circle is not supported");
        }

        public org.locationtech.jts.geom.Geometry visit(GeometryCollection<?> collection) {
            return this.buildCollection(collection);
        }

        public org.locationtech.jts.geom.Geometry visit(LinearRing ring) throws RuntimeException {
            throw new IllegalArgumentException("LinearRing is not supported");
        }

        public org.locationtech.jts.geom.Geometry visit(org.elasticsearch.geometry.Point point) throws RuntimeException {
            return this.toMVTGeometry((org.locationtech.jts.geom.Geometry)this.buildMercatorPoint(point));
        }

        public org.locationtech.jts.geom.Geometry visit(org.elasticsearch.geometry.MultiPoint multiPoint) throws RuntimeException {
            return this.toMVTGeometry((org.locationtech.jts.geom.Geometry)this.buildMercatorMultiPoint(multiPoint));
        }

        public org.locationtech.jts.geom.Geometry visit(Line line) {
            return this.toMVTGeometry((org.locationtech.jts.geom.Geometry)this.buildMercatorLine(line));
        }

        public org.locationtech.jts.geom.Geometry visit(MultiLine multiLine) throws RuntimeException {
            return this.buildCollection((GeometryCollection<?>)multiLine);
        }

        public org.locationtech.jts.geom.Geometry visit(org.elasticsearch.geometry.Polygon polygon) throws RuntimeException {
            return this.toMVTGeometry((org.locationtech.jts.geom.Geometry)this.buildMercatorPolygon(polygon));
        }

        public org.locationtech.jts.geom.Geometry visit(MultiPolygon multiPolygon) throws RuntimeException {
            return this.buildCollection((GeometryCollection<?>)multiPolygon);
        }

        public org.locationtech.jts.geom.Geometry visit(Rectangle rectangle) throws RuntimeException {
            return this.toMVTGeometry(this.buildMercatorRectangle(rectangle));
        }

        private org.locationtech.jts.geom.Geometry toMVTGeometry(org.locationtech.jts.geom.Geometry geometry) {
            if ((geometry = MVTGeometryBuilder.clipGeometry(this.clipTile, geometry)) == null) {
                return null;
            }
            geometry = TopologyPreservingSimplifier.simplify((org.locationtech.jts.geom.Geometry)geometry, (double)this.pixelPrecision);
            geometry.apply(this.sequenceFilter);
            return geometry;
        }

        private org.locationtech.jts.geom.Geometry buildCollection(GeometryCollection<?> collection) {
            ArrayList<org.locationtech.jts.geom.Geometry> geoms = new ArrayList<org.locationtech.jts.geom.Geometry>(collection.size());
            for (int i = 0; i < collection.size(); ++i) {
                org.locationtech.jts.geom.Geometry geometry = (org.locationtech.jts.geom.Geometry)collection.get(i).visit((GeometryVisitor)this);
                if (geometry == null) continue;
                for (int j = 0; j < geometry.getNumGeometries(); ++j) {
                    geoms.add(geometry.getGeometryN(j));
                }
            }
            return this.geomFactory.buildGeometry(geoms);
        }

        private Polygon buildMercatorPolygon(org.elasticsearch.geometry.Polygon polygon) {
            org.locationtech.jts.geom.LinearRing outerShell = this.buildMercatorLinearRing(polygon.getPolygon());
            if (polygon.getNumberOfHoles() == 0) {
                return this.geomFactory.createPolygon(outerShell);
            }
            org.locationtech.jts.geom.LinearRing[] holes = new org.locationtech.jts.geom.LinearRing[polygon.getNumberOfHoles()];
            for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                holes[i] = this.buildMercatorLinearRing(polygon.getHole(i));
            }
            return this.geomFactory.createPolygon(outerShell, holes);
        }

        private org.locationtech.jts.geom.LinearRing buildMercatorLinearRing(LinearRing ring) {
            return this.geomFactory.createLinearRing(MVTGeometryBuilder.buildMercatorCoordinates((Line)ring));
        }

        private LineString buildMercatorLine(Line line) {
            return this.geomFactory.createLineString(MVTGeometryBuilder.buildMercatorCoordinates(line));
        }

        private static Coordinate[] buildMercatorCoordinates(Line line) {
            Coordinate[] coordinates = new Coordinate[line.length()];
            for (int i = 0; i < line.length(); ++i) {
                double x = SphericalMercatorUtils.lonToSphericalMercator((double)line.getX(i));
                double y = SphericalMercatorUtils.latToSphericalMercator((double)line.getY(i));
                coordinates[i] = new Coordinate(x, y);
            }
            return coordinates;
        }

        private org.locationtech.jts.geom.Geometry buildMercatorRectangle(Rectangle rectangle) {
            org.locationtech.jts.geom.Geometry geometry;
            double xMin = SphericalMercatorUtils.lonToSphericalMercator((double)rectangle.getMinX());
            double yMin = SphericalMercatorUtils.latToSphericalMercator((double)rectangle.getMinY());
            double xMax = SphericalMercatorUtils.lonToSphericalMercator((double)rectangle.getMaxX());
            double yMax = SphericalMercatorUtils.latToSphericalMercator((double)rectangle.getMaxY());
            if (rectangle.getMinX() > rectangle.getMaxX()) {
                Envelope westEnvelope = new Envelope(-2.003750834E7, xMax, yMin, yMax);
                Envelope eastEnvelope = new Envelope(xMin, 2.003750834E7, yMin, yMax);
                geometry = this.geomFactory.buildGeometry(List.of(this.geomFactory.toGeometry(westEnvelope), this.geomFactory.toGeometry(eastEnvelope)));
            } else {
                Envelope envelope = new Envelope(xMin, xMax, yMin, yMax);
                geometry = this.geomFactory.toGeometry(envelope);
            }
            return geometry;
        }

        private Point buildMercatorPoint(org.elasticsearch.geometry.Point point) {
            double x = SphericalMercatorUtils.lonToSphericalMercator((double)point.getX());
            double y = SphericalMercatorUtils.latToSphericalMercator((double)point.getY());
            return this.geomFactory.createPoint(new Coordinate(x, y));
        }

        private MultiPoint buildMercatorMultiPoint(org.elasticsearch.geometry.MultiPoint multiPoint) {
            Point[] points = new Point[multiPoint.size()];
            for (int i = 0; i < multiPoint.size(); ++i) {
                points[i] = this.buildMercatorPoint((org.elasticsearch.geometry.Point)multiPoint.get(i));
            }
            Arrays.sort(points, Comparator.comparingDouble(Point::getX).thenComparingDouble(Point::getY));
            return this.geomFactory.createMultiPoint(points);
        }

        private static org.locationtech.jts.geom.Geometry clipGeometry(org.locationtech.jts.geom.Geometry tile, org.locationtech.jts.geom.Geometry geometry) {
            Envelope geometryEnvelope;
            Envelope tileEnvelope = tile.getEnvelopeInternal();
            if (!tileEnvelope.intersects(geometryEnvelope = geometry.getEnvelopeInternal())) {
                return null;
            }
            if (tileEnvelope.contains(geometryEnvelope)) {
                return geometry;
            }
            try {
                IntersectionMatrix matrix = tile.relate(geometry);
                if (matrix.isWithin()) {
                    return tile.copy();
                }
                if (matrix.isIntersects()) {
                    return tile.copy().intersection(geometry);
                }
                assert (tile.copy().intersection(geometry).isEmpty());
                return null;
            }
            catch (TopologyException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }
}

