/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.search.Query;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.support.ApiKeyFieldNameTranslators;

public class ApiKeyBoolQueryBuilder
extends BoolQueryBuilder {
    private static final Set<String> ALLOWED_EXACT_INDEX_FIELD_NAMES = Set.of("_id", "doc_type", "name", "type", "runtime_key_type", "api_key_invalidated", "invalidation_time", "creation_time", "expiration_time", "metadata_flattened", "creator.principal", "creator.realm");

    private ApiKeyBoolQueryBuilder() {
    }

    public static ApiKeyBoolQueryBuilder build(QueryBuilder queryBuilder, Consumer<String> fieldNameVisitor, @Nullable Authentication authentication) {
        ApiKeyBoolQueryBuilder finalQuery = new ApiKeyBoolQueryBuilder();
        if (queryBuilder != null) {
            QueryBuilder processedQuery = ApiKeyFieldNameTranslators.translateQueryBuilderFields(queryBuilder, fieldNameVisitor);
            finalQuery.must(processedQuery);
        }
        finalQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"doc_type", (String)"api_key"));
        fieldNameVisitor.accept("doc_type");
        if (authentication != null) {
            if (authentication.isApiKey()) {
                String apiKeyId = (String)authentication.getAuthenticatingSubject().getMetadata().get("_security_api_key_id");
                assert (apiKeyId != null) : "api key id must be present in the metadata";
                finalQuery.filter((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{apiKeyId}));
            } else {
                finalQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"creator.principal", (String)authentication.getEffectiveSubject().getUser().principal()));
                fieldNameVisitor.accept("creator.principal");
                String[] realms = ApiKeyService.getOwnersRealmNames(authentication);
                QueryBuilder realmsQuery = ApiKeyService.filterForRealmNames(realms);
                fieldNameVisitor.accept("creator.realm");
                assert (realmsQuery != null);
                finalQuery.filter(realmsQuery);
            }
        }
        return finalQuery;
    }

    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        context.setAllowedFields(ApiKeyBoolQueryBuilder::isIndexFieldNameAllowed);
        return super.doToQuery(context);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        if (queryRewriteContext instanceof SearchExecutionContext) {
            ((SearchExecutionContext)queryRewriteContext).setAllowedFields(ApiKeyBoolQueryBuilder::isIndexFieldNameAllowed);
        }
        return super.doRewrite(queryRewriteContext);
    }

    static boolean isIndexFieldNameAllowed(String fieldName) {
        return ALLOWED_EXACT_INDEX_FIELD_NAMES.contains(fieldName) || fieldName.startsWith("metadata_flattened.");
    }
}

