/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.RBACEngine;

public interface AuthorizationDenialMessages {
    public String actionDenied(Authentication var1, @Nullable AuthorizationEngine.AuthorizationInfo var2, String var3, TransportRequest var4, @Nullable String var5);

    public String runAsDenied(Authentication var1, @Nullable AuthorizationEngine.AuthorizationInfo var2, String var3);

    public String remoteActionDenied(Authentication var1, @Nullable AuthorizationEngine.AuthorizationInfo var2, String var3, String var4);

    public static class Default
    implements AuthorizationDenialMessages {
        @Override
        public String runAsDenied(Authentication authentication, @Nullable AuthorizationEngine.AuthorizationInfo authorizationInfo, String action) {
            assert (authentication.isRunAs()) : "constructing run as denied message but authentication for action was not run as";
            String userText = this.authenticatedUserDescription(authentication);
            String actionIsUnauthorizedMessage = this.actionIsUnauthorizedMessage(action, userText);
            String unauthorizedToRunAsMessage = "because " + userText + " is unauthorized to run as [" + authentication.getEffectiveSubject().getUser().principal() + "]";
            return actionIsUnauthorizedMessage + this.rolesDescription(authentication.getAuthenticatingSubject(), authorizationInfo.getAuthenticatedUserAuthorizationInfo()) + ", " + unauthorizedToRunAsMessage;
        }

        @Override
        public String actionDenied(Authentication authentication, @Nullable AuthorizationEngine.AuthorizationInfo authorizationInfo, String action, TransportRequest request, @Nullable String context) {
            Collection<String> privileges;
            String userText = this.successfulAuthenticationDescription(authentication, authorizationInfo);
            String remoteClusterText = authentication.isCrossClusterAccess() ? this.remoteClusterText(null) : "";
            Object message = this.actionIsUnauthorizedMessage(action, remoteClusterText, userText);
            if (context != null) {
                message = (String)message + " " + context;
            }
            if (ClusterPrivilegeResolver.isClusterAction((String)action)) {
                Collection<String> privileges2 = this.findClusterPrivilegesThatGrant(authentication, action, request);
                if (privileges2 != null && privileges2.size() > 0) {
                    message = (String)message + ", this action is granted by the cluster privileges [" + Strings.collectionToCommaDelimitedString(privileges2) + "]";
                }
            } else if (AuthorizationService.isIndexAction(action) && (privileges = this.findIndexPrivilegesThatGrant(action)) != null && privileges.size() > 0) {
                message = (String)message + ", this action is granted by the index privileges [" + Strings.collectionToCommaDelimitedString(privileges) + "]";
            }
            return message;
        }

        @Override
        public String remoteActionDenied(Authentication authentication, @Nullable AuthorizationEngine.AuthorizationInfo authorizationInfo, String action, String clusterAlias) {
            assert (AuthorizationService.isIndexAction(action));
            String userText = this.successfulAuthenticationDescription(authentication, authorizationInfo);
            String remoteClusterText = this.remoteClusterText(clusterAlias);
            return this.actionIsUnauthorizedMessage(action, remoteClusterText, userText) + " because no remote indices privileges apply for the target cluster";
        }

        protected Collection<String> findClusterPrivilegesThatGrant(Authentication authentication, String action, TransportRequest request) {
            return ClusterPrivilegeResolver.findPrivilegesThatGrant((String)action, (TransportRequest)request, (Authentication)authentication);
        }

        protected Collection<String> findIndexPrivilegesThatGrant(String action) {
            return IndexPrivilege.findPrivilegesThatGrant((String)action);
        }

        private String remoteClusterText(@Nullable String clusterAlias) {
            return Strings.format((String)"towards remote cluster%s ", (Object[])new Object[]{clusterAlias == null ? "" : " [" + clusterAlias + "]"});
        }

        private String authenticatedUserDescription(Authentication authentication) {
            String userText = (authentication.isServiceAccount() ? "service account" : "user") + " [" + authentication.getAuthenticatingSubject().getUser().principal() + "]";
            if (authentication.isAuthenticatedAsApiKey() || authentication.isCrossClusterAccess()) {
                String apiKeyId = (String)authentication.getAuthenticatingSubject().getMetadata().get("_security_api_key_id");
                assert (apiKeyId != null) : "api key id must be present in the metadata";
                userText = "API key id [" + apiKeyId + "] of " + userText;
                if (authentication.isCrossClusterAccess()) {
                    Authentication crossClusterAccessAuthentication = (Authentication)authentication.getAuthenticatingSubject().getMetadata().get("_security_cross_cluster_access_authentication");
                    assert (crossClusterAccessAuthentication != null) : "cross cluster access authentication must be present in the metadata";
                    userText = this.successfulAuthenticationDescription(crossClusterAccessAuthentication, null) + " authenticated by " + userText;
                }
            }
            return userText;
        }

        String rolesDescription(Subject subject, @Nullable AuthorizationEngine.AuthorizationInfo authorizationInfo) {
            if (subject.getType() != Subject.Type.USER) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            List<String> effectiveRoleNames = this.extractEffectiveRoleNames(authorizationInfo);
            if (effectiveRoleNames == null) {
                sb.append(" with assigned roles [").append(Strings.arrayToCommaDelimitedString((Object[])subject.getUser().roles())).append("]");
            } else {
                sb.append(" with effective roles [").append(Strings.collectionToCommaDelimitedString(effectiveRoleNames)).append("]");
                Set<String> assignedRoleNames = Set.of(subject.getUser().roles());
                SortedSet unfoundedRoleNames = Sets.sortedDifference(assignedRoleNames, Set.copyOf(effectiveRoleNames));
                if (!unfoundedRoleNames.isEmpty()) {
                    sb.append(" (assigned roles [").append(Strings.collectionToCommaDelimitedString((Iterable)unfoundedRoleNames)).append("] were not found)");
                }
            }
            return sb.toString();
        }

        String successfulAuthenticationDescription(Authentication authentication, @Nullable AuthorizationEngine.AuthorizationInfo authorizationInfo) {
            Object userText = this.authenticatedUserDescription(authentication);
            if (authentication.isRunAs()) {
                userText = (String)userText + " run as [" + authentication.getEffectiveSubject().getUser().principal() + "]";
            }
            userText = (String)userText + this.rolesDescription(authentication.getEffectiveSubject(), authorizationInfo);
            return userText;
        }

        private List<String> extractEffectiveRoleNames(@Nullable AuthorizationEngine.AuthorizationInfo authorizationInfo) {
            if (authorizationInfo == null) {
                return null;
            }
            Map info = authorizationInfo.asMap();
            Object roleNames = info.get("user.roles");
            if (!(roleNames instanceof String[])) {
                assert (!(authorizationInfo instanceof RBACEngine.RBACAuthorizationInfo)) : "unexpected user.roles field [" + roleNames + "] for RBACAuthorizationInfo";
                return null;
            }
            return Arrays.stream((String[])roleNames).sorted().toList();
        }

        private String actionIsUnauthorizedMessage(String action, String userText) {
            return this.actionIsUnauthorizedMessage(action, "", userText);
        }

        private String actionIsUnauthorizedMessage(String action, String remoteClusterText, String userText) {
            return "action [" + action + "] " + remoteClusterText + "is unauthorized for " + userText;
        }
    }
}

