/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.support.DnRoleMapperSettings;
import org.elasticsearch.xpack.security.authc.support.DnRoleMapper;

public class RoleMappingFileBootstrapCheck
implements BootstrapCheck {
    private final RealmConfig realmConfig;
    private final Path path;

    RoleMappingFileBootstrapCheck(RealmConfig config, Path path) {
        this.realmConfig = config;
        this.path = path;
    }

    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        try {
            DnRoleMapper.parseFile(this.path, LogManager.getLogger(this.getClass()), this.realmConfig.type(), this.realmConfig.name(), true);
            return BootstrapCheck.BootstrapCheckResult.success();
        }
        catch (Exception e) {
            return BootstrapCheck.BootstrapCheckResult.failure((String)e.getMessage());
        }
    }

    public boolean alwaysEnforce() {
        return true;
    }

    public static BootstrapCheck create(RealmConfig realmConfig) {
        if (realmConfig.enabled() && realmConfig.hasSetting(DnRoleMapperSettings.ROLE_MAPPING_FILE_SETTING)) {
            Path file = DnRoleMapper.resolveFile(realmConfig);
            return new RoleMappingFileBootstrapCheck(realmConfig, file);
        }
        return null;
    }

    public ReferenceDocs referenceDocs() {
        return ReferenceDocs.BOOTSTRAP_CHECK_ROLE_MAPPINGS;
    }
}

