/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.CrossClusterAccessSubjectInfo;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.Authenticator;
import org.elasticsearch.xpack.security.authc.CrossClusterAccessHeaders;

public class CrossClusterAccessAuthenticationService {
    private static final Logger logger = LogManager.getLogger(CrossClusterAccessAuthenticationService.class);
    private final ClusterService clusterService;
    private final ApiKeyService apiKeyService;
    private final AuthenticationService authenticationService;

    public CrossClusterAccessAuthenticationService(ClusterService clusterService, ApiKeyService apiKeyService, AuthenticationService authenticationService) {
        this.clusterService = clusterService;
        this.apiKeyService = apiKeyService;
        this.authenticationService = authenticationService;
    }

    public void authenticate(String action, TransportRequest request, ActionListener<Authentication> listener) {
        Authenticator.Context authcContext;
        CrossClusterAccessHeaders crossClusterAccessHeaders;
        ThreadContext threadContext = this.clusterService.threadPool().getThreadContext();
        try {
            crossClusterAccessHeaders = CrossClusterAccessHeaders.readFromContext(threadContext);
            ApiKeyService.ApiKeyCredentials apiKeyCredentials = crossClusterAccessHeaders.credentials();
            assert (ApiKey.Type.CROSS_CLUSTER == apiKeyCredentials.getExpectedType());
            authcContext = this.authenticationService.newContext(action, request, apiKeyCredentials);
        }
        catch (Exception ex) {
            CrossClusterAccessAuthenticationService.withRequestProcessingFailure(this.authenticationService.newContext(action, request, null), ex, listener);
            return;
        }
        try {
            this.apiKeyService.ensureEnabled();
        }
        catch (Exception ex) {
            CrossClusterAccessAuthenticationService.withRequestProcessingFailure(authcContext, ex, listener);
            return;
        }
        if (this.getMinTransportVersion().before((VersionId)RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY)) {
            CrossClusterAccessAuthenticationService.withRequestProcessingFailure(authcContext, new IllegalArgumentException("all nodes must have version [" + RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY.toReleaseVersion() + "] or higher to support cross cluster requests through the dedicated remote cluster port"), listener);
            return;
        }
        assert (threadContext.getHeaders().keySet().stream().noneMatch(ClientHelper.SECURITY_HEADER_FILTERS::contains));
        try (ThreadContext.StoredContext ignored = threadContext.newStoredContext(Collections.emptyList(), List.of("_cross_cluster_access_credentials", "_cross_cluster_access_subject_info"));){
            Supplier storedContextSupplier = threadContext.newRestorableContext(false);
            this.authenticationService.authenticate(authcContext, (ActionListener<Authentication>)new ContextPreservingActionListener(storedContextSupplier, ActionListener.wrap(authentication -> {
                assert (authentication.isApiKey()) : "initial authentication for cross cluster access must be by API key";
                assert (!authentication.isRunAs()) : "initial authentication for cross cluster access cannot be run-as";
                try {
                    CrossClusterAccessSubjectInfo subjectInfo = crossClusterAccessHeaders.getCleanAndValidatedSubjectInfo();
                    CrossClusterAccessAuthenticationService.writeAuthToContext(authcContext, authentication.toCrossClusterAccess(subjectInfo), listener);
                }
                catch (Exception ex) {
                    CrossClusterAccessAuthenticationService.withRequestProcessingFailure(authcContext, ex, listener);
                }
            }, arg_0 -> listener.onFailure(arg_0))));
        }
    }

    public void tryAuthenticate(Map<String, String> headers, ActionListener<Void> listener) {
        ApiKeyService.ApiKeyCredentials credentials;
        try {
            credentials = this.extractApiKeyCredentialsFromHeaders(headers);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        this.tryAuthenticate(credentials, listener);
    }

    public void tryAuthenticate(ApiKeyService.ApiKeyCredentials credentials, ActionListener<Void> listener) {
        Objects.requireNonNull(credentials);
        this.apiKeyService.tryAuthenticate(this.clusterService.threadPool().getThreadContext(), credentials, (ActionListener<AuthenticationResult<User>>)ActionListener.wrap(authResult -> {
            if (authResult.isAuthenticated()) {
                logger.trace("Cross cluster credentials authentication successful for [{}]", (Object)credentials.principal());
                listener.onResponse(null);
                return;
            }
            if (authResult.getStatus() == AuthenticationResult.Status.TERMINATE) {
                Exception e = authResult.getException() != null ? authResult.getException() : Exceptions.authenticationError((String)authResult.getMessage(), (Object[])new Object[0]);
                logger.debug(() -> "API key service terminated authentication", (Throwable)e);
                listener.onFailure(e);
            } else {
                if (authResult.getMessage() != null) {
                    if (authResult.getException() != null) {
                        logger.warn(() -> Strings.format((String)"Authentication using apikey failed - %s", (Object[])new Object[]{authResult.getMessage()}), (Throwable)authResult.getException());
                    } else {
                        logger.warn("Authentication using apikey failed - {}", (Object)authResult.getMessage());
                    }
                }
                listener.onFailure((Exception)((Object)Exceptions.authenticationError((String)authResult.getMessage(), (Throwable)authResult.getException(), (Object[])new Object[0])));
            }
        }, e -> listener.onFailure((Exception)((Object)Exceptions.authenticationError((String)"failed to authenticate cross cluster credentials", (Throwable)e, (Object[])new Object[0])))));
    }

    public ApiKeyService.ApiKeyCredentials extractApiKeyCredentialsFromHeaders(Map<String, String> headers) {
        try {
            String credentials;
            this.apiKeyService.ensureEnabled();
            String string = credentials = headers == null ? null : headers.get("_cross_cluster_access_credentials");
            if (credentials == null) {
                throw CrossClusterAccessAuthenticationService.requiredHeaderMissingException("_cross_cluster_access_credentials");
            }
            return CrossClusterAccessHeaders.parseCredentialsHeader(credentials);
        }
        catch (Exception ex) {
            throw Exceptions.authenticationError((String)"failed to extract credentials from headers", (Throwable)ex, (Object[])new Object[0]);
        }
    }

    public static IllegalArgumentException requiredHeaderMissingException(String headerKey) {
        return new IllegalArgumentException("Cross cluster requests through the dedicated remote cluster server port require transport header [" + headerKey + "] but none found. Please ensure you have configured remote cluster credentials on the cluster originating the request.");
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    private TransportVersion getMinTransportVersion() {
        return this.clusterService.state().getMinTransportVersion();
    }

    private static void withRequestProcessingFailure(Authenticator.Context context, Exception ex, ActionListener<Authentication> listener) {
        logger.debug(() -> Strings.format((String)"Failed to authenticate cross cluster access for request [%s]", (Object[])new Object[]{context.getRequest()}), (Throwable)ex);
        ElasticsearchSecurityException ese = context.getRequest().exceptionProcessingRequest(ex, context.getMostRecentAuthenticationToken());
        context.addUnsuccessfulMessageToMetadata(ese);
        listener.onFailure((Exception)((Object)ese));
    }

    private static void writeAuthToContext(Authenticator.Context context, Authentication authentication, ActionListener<Authentication> listener) {
        try {
            authentication.writeToContext(context.getThreadContext());
            context.getRequest().authenticationSuccess(authentication);
        }
        catch (Exception e) {
            logger.debug(() -> Strings.format((String)"Failed to store authentication [%s] for cross cluster request [%s]", (Object[])new Object[]{authentication, context.getRequest()}), (Throwable)e);
            CrossClusterAccessAuthenticationService.withRequestProcessingFailure(context, e, listener);
            return;
        }
        logger.trace("Established authentication [{}] for cross cluster request [{}]", (Object)authentication, (Object)context.getRequest());
        listener.onResponse((Object)authentication);
    }
}

