/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.security.action.role.PutRoleRequest;
import org.elasticsearch.xpack.core.security.action.role.PutRoleResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.support.DLSRoleQueryValidator;
import org.elasticsearch.xpack.security.authz.ReservedRoleNameChecker;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;

public class TransportPutRoleAction
extends TransportAction<PutRoleRequest, PutRoleResponse> {
    private final NativeRolesStore rolesStore;
    private final NamedXContentRegistry xContentRegistry;
    private final ReservedRoleNameChecker reservedRoleNameChecker;

    @Inject
    public TransportPutRoleAction(ActionFilters actionFilters, NativeRolesStore rolesStore, TransportService transportService, NamedXContentRegistry xContentRegistry, ReservedRoleNameChecker reservedRoleNameChecker) {
        super("cluster:admin/xpack/security/role/put", actionFilters, transportService.getTaskManager());
        this.rolesStore = rolesStore;
        this.xContentRegistry = xContentRegistry;
        this.reservedRoleNameChecker = reservedRoleNameChecker;
    }

    protected void doExecute(Task task, PutRoleRequest request, ActionListener<PutRoleResponse> listener) {
        Exception validationException = this.validateRequest(request);
        if (validationException != null) {
            listener.onFailure(validationException);
        } else {
            this.rolesStore.putRole(request, request.roleDescriptor(), (ActionListener<Boolean>)listener.safeMap(created -> {
                if (created.booleanValue()) {
                    this.logger.info("added role [{}]", (Object)request.name());
                } else {
                    this.logger.info("updated role [{}]", (Object)request.name());
                }
                return new PutRoleResponse(created.booleanValue());
            }));
        }
    }

    private Exception validateRequest(PutRoleRequest request) {
        ActionRequestValidationException validationException = request.validate();
        if (validationException != null) {
            return validationException;
        }
        if (this.reservedRoleNameChecker.isReserved(request.name())) {
            throw ValidateActions.addValidationError((String)("Role [" + request.name() + "] is reserved and may not be used."), null);
        }
        try {
            DLSRoleQueryValidator.validateQueryField((RoleDescriptor.IndicesPrivileges[])request.roleDescriptor().getIndicesPrivileges(), (NamedXContentRegistry)this.xContentRegistry);
        }
        catch (IllegalArgumentException | ElasticsearchException e) {
            return e;
        }
        return null;
    }
}

