/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.profile;

import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.common.ResultsAndErrors;
import org.elasticsearch.xpack.core.security.action.profile.GetProfilesRequest;
import org.elasticsearch.xpack.core.security.action.profile.GetProfilesResponse;
import org.elasticsearch.xpack.core.security.action.profile.Profile;
import org.elasticsearch.xpack.security.profile.ProfileService;

public class TransportGetProfilesAction
extends HandledTransportAction<GetProfilesRequest, GetProfilesResponse> {
    private final ProfileService profileService;

    @Inject
    public TransportGetProfilesAction(TransportService transportService, ActionFilters actionFilters, ProfileService profileService) {
        super("cluster:admin/xpack/security/profile/get", transportService, actionFilters, GetProfilesRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.profileService = profileService;
    }

    protected void doExecute(Task task, GetProfilesRequest request, ActionListener<GetProfilesResponse> listener) {
        this.profileService.getProfiles(request.getUids(), request.getDataKeys(), (ActionListener<ResultsAndErrors<Profile>>)listener.map(resultsAndError -> new GetProfilesResponse(List.copyOf(resultsAndError.results()), resultsAndError.errors())));
    }
}

