/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.history;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor2;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.ilm.history.ILMHistoryItem;

public class ILMHistoryStore
implements Closeable {
    private static final Logger logger = LogManager.getLogger(ILMHistoryStore.class);
    public static final Setting<ByteSizeValue> MAX_BULK_REQUEST_BYTE_IN_FLIGHT_SETTING = Setting.byteSizeSetting((String)"es.indices.lifecycle.history.bulk.request.bytes.in.flight", (ByteSizeValue)ByteSizeValue.ofMb((long)100L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final String ILM_HISTORY_DATA_STREAM = "ilm-history-7";
    private static int ILM_HISTORY_BULK_SIZE = StrictMath.toIntExact(ByteSizeValue.parseBytesSizeValue((String)System.getProperty("es.indices.lifecycle.history.bulk.size", "50MB"), (String)"es.indices.lifecycle.history.bulk.size").getBytes());
    private volatile boolean ilmHistoryEnabled = true;
    private final BulkProcessor2 processor;

    public ILMHistoryStore(Client client, ClusterService clusterService, ThreadPool threadPool) {
        this(client, clusterService, threadPool, (ActionListener<BulkResponse>)ActionListener.noop(), TimeValue.timeValueSeconds((long)5L));
    }

    ILMHistoryStore(Client client, final ClusterService clusterService, ThreadPool threadPool, final ActionListener<BulkResponse> listener, TimeValue flushInterval) {
        this.setIlmHistoryEnabled((Boolean)LifecycleSettings.LIFECYCLE_HISTORY_INDEX_ENABLED_SETTING.get(clusterService.getSettings()));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(LifecycleSettings.LIFECYCLE_HISTORY_INDEX_ENABLED_SETTING, this::setIlmHistoryEnabled);
        this.processor = BulkProcessor2.builder((arg_0, arg_1) -> ((OriginSettingClient)new OriginSettingClient(client, "index_lifecycle")).bulk(arg_0, arg_1), (BulkProcessor2.Listener)new BulkProcessor2.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
                if (!clusterService.state().getMetadata().templatesV2().containsKey(ILMHistoryStore.ILM_HISTORY_DATA_STREAM)) {
                    ElasticsearchException e = new ElasticsearchException("no ILM history template", new Object[0]);
                    logger.warn(() -> Strings.format((String)"unable to index the following ILM history items:\n%s", (Object[])new Object[]{request.requests().stream().filter(dwr -> dwr instanceof IndexRequest).map(dwr -> (IndexRequest)dwr).map(IndexRequest::sourceAsMap).map(Object::toString).collect(Collectors.joining("\n"))}), (Throwable)e);
                    throw new ElasticsearchException((Throwable)e);
                }
                if (logger.isTraceEnabled()) {
                    logger.info("about to index: {}", (Object)request.requests().stream().map(dwr -> ((IndexRequest)dwr).sourceAsMap()).map(Objects::toString).collect(Collectors.joining(",")));
                }
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                long items = request.numberOfActions();
                if (logger.isTraceEnabled()) {
                    logger.trace("indexed [{}] items into ILM history index [{}]", (Object)items, (Object)Arrays.stream(response.getItems()).map(BulkItemResponse::getIndex).distinct().collect(Collectors.joining(",")));
                }
                if (response.hasFailures()) {
                    Map<String, String> failures = Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).collect(Collectors.toMap(BulkItemResponse::getId, BulkItemResponse::getFailureMessage, (msg1, msg2) -> Objects.equals(msg1, msg2) ? msg1 : msg1 + "," + msg2));
                    logger.error("failures: [{}]", failures);
                }
                listener.onResponse((Object)response);
            }

            public void afterBulk(long executionId, BulkRequest request, Exception failure) {
                long items = request.numberOfActions();
                logger.error(() -> "failed to index " + items + " items into ILM history index", (Throwable)failure);
                listener.onFailure(failure);
            }
        }, (ThreadPool)threadPool).setBulkActions(-1).setBulkSize(ByteSizeValue.ofBytes((long)ILM_HISTORY_BULK_SIZE)).setFlushInterval(flushInterval).setMaxBytesInFlight((ByteSizeValue)MAX_BULK_REQUEST_BYTE_IN_FLIGHT_SETTING.get(clusterService.getSettings())).setMaxNumberOfRetries(3).build();
    }

    public void putAsync(ILMHistoryItem item) {
        if (!this.ilmHistoryEnabled) {
            logger.trace("not recording ILM history item because [{}] is [false]: [{}]", (Object)LifecycleSettings.LIFECYCLE_HISTORY_INDEX_ENABLED_SETTING.getKey(), (Object)item);
            return;
        }
        logger.trace("queueing ILM history item for indexing [{}]: [{}]", (Object)ILM_HISTORY_DATA_STREAM, (Object)item);
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            item.toXContent(builder, ToXContent.EMPTY_PARAMS);
            IndexRequest request = new IndexRequest(ILM_HISTORY_DATA_STREAM).source(builder).opType(DocWriteRequest.OpType.CREATE);
            this.processor.add(request);
        }
        catch (Exception e) {
            logger.error(() -> Strings.format((String)"failed to send ILM history item to index [%s]: [%s]", (Object[])new Object[]{ILM_HISTORY_DATA_STREAM, item}), (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.processor.awaitClose(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("failed to shut down ILM history bulk processor after 10 seconds", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public void setIlmHistoryEnabled(boolean ilmHistoryEnabled) {
        this.ilmHistoryEnabled = ilmHistoryEnabled;
    }
}

