/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequestBuilder;
import org.elasticsearch.action.support.CountDownActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.scheduler.SchedulerEngine;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicy;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleStats;
import org.elasticsearch.xpack.core.slm.SnapshotRetentionConfiguration;
import org.elasticsearch.xpack.slm.SnapshotLifecycleService;
import org.elasticsearch.xpack.slm.TransportSLMGetExpiredSnapshotsAction;
import org.elasticsearch.xpack.slm.UpdateSnapshotLifecycleStatsTask;
import org.elasticsearch.xpack.slm.history.SnapshotHistoryItem;
import org.elasticsearch.xpack.slm.history.SnapshotHistoryStore;

public class SnapshotRetentionTask
implements SchedulerEngine.Listener {
    private static final Logger logger = LogManager.getLogger(SnapshotRetentionTask.class);
    private static final Set<SnapshotState> RETAINABLE_STATES = EnumSet.of(SnapshotState.SUCCESS, SnapshotState.FAILED, SnapshotState.PARTIAL);
    private final Client client;
    private final ClusterService clusterService;
    private final LongSupplier nowNanoSupplier;
    private final SnapshotHistoryStore historyStore;
    private final Set<SnapshotId> runningDeletions = Collections.synchronizedSet(new HashSet());

    public SnapshotRetentionTask(Client client, ClusterService clusterService, LongSupplier nowNanoSupplier, SnapshotHistoryStore historyStore) {
        this.client = new OriginSettingClient(client, "index_lifecycle");
        this.clusterService = clusterService;
        this.nowNanoSupplier = nowNanoSupplier;
        this.historyStore = historyStore;
    }

    public void triggered(SchedulerEngine.Event event) {
        assert (event.getJobName().equals("slm-retention-job") || event.getJobName().equals("slm-execute-manual-retention-job")) : "expected id to be slm-retention-job or slm-execute-manual-retention-job but it was " + event.getJobName();
        ClusterState state = this.clusterService.state();
        if (SnapshotLifecycleService.slmStoppedOrStopping(state) && !event.getJobName().equals("slm-execute-manual-retention-job")) {
            logger.debug("skipping SLM retention as SLM is currently stopped or stopping");
            return;
        }
        final SnapshotLifecycleStats slmStats = new SnapshotLifecycleStats();
        final Consumer<Exception> failureHandler = e -> {
            try {
                logger.error("error during snapshot retention task", (Throwable)e);
                slmStats.retentionFailed();
                this.updateStateWithStats(slmStats);
            }
            finally {
                logger.info("SLM retention snapshot cleanup task completed with error");
            }
        };
        try {
            logger.info("starting SLM retention snapshot cleanup task");
            slmStats.retentionRun();
            Map<String, SnapshotLifecyclePolicy> policiesWithRetention = SnapshotRetentionTask.getAllPoliciesWithRetentionEnabled(state);
            logger.trace("policies with retention enabled: {}", policiesWithRetention.keySet());
            Set<String> repositioriesToFetch = policiesWithRetention.values().stream().map(SnapshotLifecyclePolicy::getRepository).collect(Collectors.toSet());
            logger.trace("fetching snapshots from repositories: {}", repositioriesToFetch);
            if (repositioriesToFetch.isEmpty()) {
                logger.info("there are no repositories to fetch, SLM retention snapshot cleanup task complete");
                return;
            }
            this.getSnapshotsEligibleForDeletion(repositioriesToFetch, policiesWithRetention, new ActionListener<Map<String, List<Tuple<SnapshotId, String>>>>(){

                public void onResponse(Map<String, List<Tuple<SnapshotId, String>>> snapshotsToBeDeleted) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("snapshots eligible for deletion: [{}]", snapshotsToBeDeleted);
                    }
                    SnapshotRetentionTask.this.deleteSnapshots(snapshotsToBeDeleted, slmStats, (ActionListener<Void>)ActionListener.running(() -> {
                        SnapshotRetentionTask.this.updateStateWithStats(slmStats);
                        logger.info("SLM retention snapshot cleanup task complete");
                    }));
                }

                public void onFailure(Exception e) {
                    failureHandler.accept(e);
                }
            });
        }
        catch (Exception e2) {
            failureHandler.accept(e2);
        }
    }

    static Map<String, SnapshotLifecyclePolicy> getAllPoliciesWithRetentionEnabled(ClusterState state) {
        SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle");
        if (snapMeta == null) {
            return Collections.emptyMap();
        }
        return snapMeta.getSnapshotConfigurations().entrySet().stream().filter(e -> ((SnapshotLifecyclePolicyMetadata)e.getValue()).getPolicy().getRetentionPolicy() != null).filter(e -> !((SnapshotLifecyclePolicyMetadata)e.getValue()).getPolicy().getRetentionPolicy().equals((Object)SnapshotRetentionConfiguration.EMPTY)).collect(Collectors.toMap(Map.Entry::getKey, e -> ((SnapshotLifecyclePolicyMetadata)e.getValue()).getPolicy()));
    }

    void getSnapshotsEligibleForDeletion(Collection<String> repositories, Map<String, SnapshotLifecyclePolicy> policies, ActionListener<Map<String, List<Tuple<SnapshotId, String>>>> listener) {
        this.client.execute(TransportSLMGetExpiredSnapshotsAction.INSTANCE, (ActionRequest)new TransportSLMGetExpiredSnapshotsAction.Request(repositories, policies), listener.delegateFailureAndWrap((l, m) -> l.onResponse(m.snapshotsToDelete())));
    }

    void deleteSnapshots(Map<String, List<Tuple<SnapshotId, String>>> snapshotsToDelete, SnapshotLifecycleStats slmStats, ActionListener<Void> listener) {
        int count = snapshotsToDelete.values().stream().mapToInt(List::size).sum();
        if (count == 0) {
            listener.onResponse(null);
            logger.debug("no snapshots are eligible for deletion");
            return;
        }
        logger.info("starting snapshot retention deletion for [{}] snapshots", (Object)count);
        long startTime = this.nowNanoSupplier.getAsLong();
        AtomicInteger deleted = new AtomicInteger(0);
        AtomicInteger failed = new AtomicInteger(0);
        CountDownActionListener allDeletesListener = new CountDownActionListener(snapshotsToDelete.size(), ActionListener.runAfter(listener, () -> {
            TimeValue totalElapsedTime = TimeValue.timeValueNanos((long)(this.nowNanoSupplier.getAsLong() - startTime));
            logger.debug("total elapsed time for deletion of [{}] snapshots: {}", (Object)deleted, (Object)totalElapsedTime);
            slmStats.deletionTime(totalElapsedTime);
        }));
        for (Map.Entry<String, List<Tuple<SnapshotId, String>>> entry : snapshotsToDelete.entrySet()) {
            String repo = entry.getKey();
            List<Tuple<SnapshotId, String>> snapshots = entry.getValue();
            if (snapshots.isEmpty()) continue;
            this.deleteSnapshots(slmStats, deleted, failed, repo, snapshots, (ActionListener<Void>)allDeletesListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSnapshots(SnapshotLifecycleStats slmStats, AtomicInteger deleted, AtomicInteger failed, String repo, List<Tuple<SnapshotId, String>> snapshots, ActionListener<Void> listener) {
        CountDownActionListener allDeletesListener = new CountDownActionListener(snapshots.size(), listener);
        for (Tuple<SnapshotId, String> info : snapshots) {
            SnapshotId snapshotId = (SnapshotId)info.v1();
            if (!this.runningDeletions.add(snapshotId)) {
                allDeletesListener.onResponse(null);
                continue;
            }
            boolean success = false;
            try {
                String policyId = (String)info.v2();
                long deleteStartTime = this.nowNanoSupplier.getAsLong();
                this.deleteSnapshot(policyId, repo, snapshotId, slmStats, (ActionListener<AcknowledgedResponse>)ActionListener.runAfter((ActionListener)ActionListener.wrap(arg_0 -> this.lambda$deleteSnapshots$6(deleted, snapshotId, policyId, repo, (ActionListener)allDeletesListener, arg_0), arg_0 -> this.lambda$deleteSnapshots$8(failed, snapshotId, policyId, repo, (ActionListener)allDeletesListener, arg_0)), () -> {
                    this.runningDeletions.remove(snapshotId);
                    long finishTime = this.nowNanoSupplier.getAsLong();
                    TimeValue deletionTime = TimeValue.timeValueNanos((long)(finishTime - deleteStartTime));
                    logger.debug("elapsed time for deletion of [{}] snapshot: {}", (Object)snapshotId, (Object)deletionTime);
                }));
                success = true;
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
            finally {
                if (success) continue;
                this.runningDeletions.remove(snapshotId);
            }
        }
    }

    void deleteSnapshot(String slmPolicy, String repo, SnapshotId snapshot, SnapshotLifecycleStats slmStats, ActionListener<AcknowledgedResponse> listener) {
        logger.info("[{}] snapshot retention deleting snapshot [{}]", (Object)repo, (Object)snapshot);
        ((DeleteSnapshotRequestBuilder)this.client.admin().cluster().prepareDeleteSnapshot(repo, new String[]{snapshot.getName()}).setMasterNodeTimeout(TimeValue.MAX_VALUE)).execute(ActionListener.wrap(acknowledgedResponse -> {
            slmStats.snapshotDeleted(slmPolicy);
            listener.onResponse(acknowledgedResponse);
        }, e -> {
            try {
                logger.warn(() -> Strings.format((String)"[%s] failed to delete snapshot [%s] for retention", (Object[])new Object[]{repo, snapshot}), (Throwable)e);
                slmStats.snapshotDeleteFailure(slmPolicy);
            }
            finally {
                listener.onFailure(e);
            }
        }));
    }

    void updateStateWithStats(SnapshotLifecycleStats newStats) {
        this.submitUnbatchedTask("update_slm_stats", new UpdateSnapshotLifecycleStatsTask(newStats));
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$deleteSnapshots$8(AtomicInteger failed, SnapshotId snapshotId, String policyId, String repo, ActionListener allDeletesListener, Exception e) {
        failed.incrementAndGet();
        try {
            SnapshotHistoryItem result = SnapshotHistoryItem.deletionFailureRecord(Instant.now().toEpochMilli(), snapshotId.getName(), policyId, repo, e);
            this.historyStore.putAsync(result);
        }
        catch (IOException ex) {
            logger.error(() -> Strings.format((String)"failed to record snapshot deletion failure for snapshot lifecycle policy [%s]", (Object[])new Object[]{policyId}), (Throwable)ex);
        }
        finally {
            allDeletesListener.onFailure(e);
        }
    }

    private /* synthetic */ void lambda$deleteSnapshots$6(AtomicInteger deleted, SnapshotId snapshotId, String policyId, String repo, ActionListener allDeletesListener, AcknowledgedResponse acknowledgedResponse) throws Exception {
        deleted.incrementAndGet();
        assert (acknowledgedResponse.isAcknowledged());
        this.historyStore.putAsync(SnapshotHistoryItem.deletionSuccessRecord(Instant.now().toEpochMilli(), snapshotId.getName(), policyId, repo));
        allDeletesListener.onResponse(null);
    }
}

