/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.action;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.datastreams.DataStreamsActionUtil;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.datastreams.lifecycle.action.GetDataStreamLifecycleAction;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetDataStreamLifecycleAction
extends TransportMasterNodeReadAction<GetDataStreamLifecycleAction.Request, GetDataStreamLifecycleAction.Response> {
    private final ClusterSettings clusterSettings;

    @Inject
    public TransportGetDataStreamLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(GetDataStreamLifecycleAction.INSTANCE.name(), transportService, clusterService, threadPool, actionFilters, GetDataStreamLifecycleAction.Request::new, indexNameExpressionResolver, GetDataStreamLifecycleAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterSettings = clusterService.getClusterSettings();
    }

    protected void masterOperation(Task task, GetDataStreamLifecycleAction.Request request, ClusterState state, ActionListener<GetDataStreamLifecycleAction.Response> listener) {
        List results = DataStreamsActionUtil.getDataStreamNames((IndexNameExpressionResolver)this.indexNameExpressionResolver, (ClusterState)state, (String[])request.getNames(), (IndicesOptions)request.indicesOptions());
        Map dataStreams = state.metadata().dataStreams();
        listener.onResponse((Object)new GetDataStreamLifecycleAction.Response(results.stream().map(dataStreams::get).filter(Objects::nonNull).map(dataStream -> new GetDataStreamLifecycleAction.Response.DataStreamLifecycle(dataStream.getName(), dataStream.getLifecycle())).sorted(Comparator.comparing(GetDataStreamLifecycleAction.Response.DataStreamLifecycle::dataStreamName)).toList(), request.includeDefaults() ? (RolloverConfiguration)this.clusterSettings.get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING) : null, DataStreamGlobalRetention.getFromClusterState((ClusterState)state)));
    }

    protected ClusterBlockException checkBlock(GetDataStreamLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

