/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.xpack.enrich.AbstractEnrichProcessor;

public final class GeoMatchProcessor
extends AbstractEnrichProcessor {
    private final ShapeRelation shapeRelation;
    private final GeometryParser parser;

    GeoMatchProcessor(String tag, String description, BiConsumer<SearchRequest, BiConsumer<List<Map<?, ?>>, Exception>> searchRunner, String policyName, TemplateScript.Factory field, TemplateScript.Factory targetField, boolean overrideEnabled, boolean ignoreMissing, String matchField, int maxMatches, ShapeRelation shapeRelation, Orientation orientation) {
        super(tag, description, searchRunner, policyName, field, targetField, ignoreMissing, overrideEnabled, matchField, maxMatches);
        this.shapeRelation = shapeRelation;
        this.parser = new GeometryParser(orientation.getAsBoolean(), true, true);
    }

    @Override
    public QueryBuilder getQueryBuilder(Object fieldValue) {
        Geometry queryGeometry = this.parser.parseGeometry(fieldValue);
        GeoShapeQueryBuilder shapeQuery = new GeoShapeQueryBuilder(this.matchField, queryGeometry);
        shapeQuery.relation(this.shapeRelation);
        return shapeQuery;
    }

    public ShapeRelation getShapeRelation() {
        return this.shapeRelation;
    }
}

