/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.querydsl.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.XYDocValuesField;
import org.apache.lucene.document.XYPointField;
import org.apache.lucene.document.XYShape;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.geo.LuceneGeometriesUtils;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.lucene.spatial.CartesianShapeDocValuesQuery;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;

public class SpatialRelatesQuery
extends org.elasticsearch.xpack.ql.querydsl.query.Query {
    private final String field;
    private final ShapeField.QueryRelation queryRelation;
    private final Geometry shape;
    private final DataType dataType;

    public SpatialRelatesQuery(Source source, String field, ShapeField.QueryRelation queryRelation, Geometry shape, DataType dataType) {
        super(source);
        this.field = field;
        this.queryRelation = queryRelation;
        this.shape = shape;
        this.dataType = dataType;
    }

    public boolean containsNestedField(String path, String field) {
        return false;
    }

    public org.elasticsearch.xpack.ql.querydsl.query.Query addNestedField(String path, String field, String format, boolean hasDocValues) {
        return null;
    }

    public void enrichNestedSort(NestedSortBuilder sort) {
    }

    public QueryBuilder asBuilder() {
        return EsqlDataTypes.isSpatialGeo(this.dataType) ? new GeoShapeQueryBuilder() : new CartesianShapeQueryBuilder();
    }

    protected String innerToString() {
        throw new IllegalArgumentException("SpatialRelatesQuery.innerToString() not implemented");
    }

    public int hashCode() {
        return Objects.hash(this.field, this.queryRelation, this.shape, this.dataType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SpatialRelatesQuery other = (SpatialRelatesQuery)((Object)obj);
        return Objects.equals(this.field, other.field) && Objects.equals(this.queryRelation, other.queryRelation) && Objects.equals(this.shape, other.shape) && Objects.equals(this.dataType, other.dataType);
    }

    public ShapeRelation shapeRelation() {
        return switch (this.queryRelation) {
            default -> throw new IncompatibleClassChangeError();
            case ShapeField.QueryRelation.INTERSECTS -> ShapeRelation.INTERSECTS;
            case ShapeField.QueryRelation.DISJOINT -> ShapeRelation.DISJOINT;
            case ShapeField.QueryRelation.WITHIN -> ShapeRelation.WITHIN;
            case ShapeField.QueryRelation.CONTAINS -> ShapeRelation.CONTAINS;
        };
    }

    private class GeoShapeQueryBuilder
    extends ShapeQueryBuilder {
        public final String NAME = "geo_shape";

        private GeoShapeQueryBuilder() {
            this.NAME = "geo_shape";
        }

        public String getWriteableName() {
            return "GeoShapeQueryBuilder";
        }

        @Override
        Query buildShapeQuery(SearchExecutionContext context, MappedFieldType fieldType) {
            if (!(fieldType instanceof GeoShapeQueryable)) {
                throw new QueryShardException((QueryRewriteContext)context, "Field [" + SpatialRelatesQuery.this.field + "] is of unsupported type [" + fieldType.typeName() + "] for [geo_shape] query", new Object[0]);
            }
            GeoShapeQueryable ft = (GeoShapeQueryable)fieldType;
            return new ConstantScoreQuery(ft.geoShapeQuery(context, fieldType.name(), SpatialRelatesQuery.this.shapeRelation(), SpatialRelatesQuery.this.shape));
        }
    }

    private class CartesianShapeQueryBuilder
    extends ShapeQueryBuilder {
        private CartesianShapeQueryBuilder() {
        }

        public String getWriteableName() {
            return "CartesianShapeQueryBuilder";
        }

        @Override
        Query buildShapeQuery(SearchExecutionContext context, MappedFieldType fieldType) {
            Query innerQuery = SpatialRelatesQuery.this.dataType == EsqlDataTypes.CARTESIAN_POINT ? CartesianShapeQueryBuilder.pointShapeQuery(SpatialRelatesQuery.this.shape, fieldType.name(), SpatialRelatesQuery.this.queryRelation, context) : CartesianShapeQueryBuilder.shapeShapeQuery(SpatialRelatesQuery.this.shape, fieldType.name(), SpatialRelatesQuery.this.queryRelation, context);
            return new ConstantScoreQuery(innerQuery);
        }

        private static Query pointShapeQuery(Geometry geometry, String fieldName, ShapeField.QueryRelation relation, SearchExecutionContext context) {
            boolean hasDocValues = context.getFieldType(fieldName).hasDocValues();
            if (geometry == null || geometry.isEmpty()) {
                throw new QueryShardException((QueryRewriteContext)context, "Invalid/empty geometry", new Object[0]);
            }
            if (geometry.type() != ShapeType.POINT && relation == ShapeField.QueryRelation.CONTAINS) {
                return new MatchNoDocsQuery("A point field can never contain a non-point geometry");
            }
            XYGeometry[] luceneGeometries = LuceneGeometriesUtils.toXYGeometry((Geometry)geometry, t -> {});
            Query intersects = XYPointField.newGeometryQuery((String)fieldName, (XYGeometry[])luceneGeometries);
            if (relation == ShapeField.QueryRelation.DISJOINT) {
                BooleanQuery.Builder bool = new BooleanQuery.Builder();
                Query exists = ExistsQueryBuilder.newFilter((SearchExecutionContext)context, (String)fieldName, (boolean)false);
                bool.add(exists, BooleanClause.Occur.MUST);
                bool.add(intersects, BooleanClause.Occur.MUST_NOT);
                return bool.build();
            }
            if (hasDocValues) {
                Query queryDocValues = XYDocValuesField.newSlowGeometryQuery((String)fieldName, (XYGeometry[])luceneGeometries);
                intersects = new IndexOrDocValuesQuery(intersects, queryDocValues);
            }
            return intersects;
        }

        private static Query shapeShapeQuery(Geometry geometry, String fieldName, ShapeField.QueryRelation relation, SearchExecutionContext context) {
            XYGeometry[] luceneGeometries;
            boolean hasDocValues = context.getFieldType(fieldName).hasDocValues();
            if (relation == ShapeField.QueryRelation.CONTAINS && context.indexVersionCreated().before((VersionId)IndexVersions.V_7_5_0)) {
                throw new QueryShardException((QueryRewriteContext)context, relation + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
            }
            if (geometry == null || geometry.isEmpty()) {
                throw new QueryShardException((QueryRewriteContext)context, "Invalid/empty geometry", new Object[0]);
            }
            try {
                luceneGeometries = LuceneGeometriesUtils.toXYGeometry((Geometry)geometry, t -> {});
            }
            catch (IllegalArgumentException e) {
                throw new QueryShardException((QueryRewriteContext)context, "Exception creating query on Field [" + fieldName + "] " + e.getMessage(), (Throwable)e, new Object[0]);
            }
            Query query = XYShape.newGeometryQuery((String)fieldName, (ShapeField.QueryRelation)relation, (XYGeometry[])luceneGeometries);
            if (hasDocValues) {
                CartesianShapeDocValuesQuery queryDocValues = new CartesianShapeDocValuesQuery(fieldName, relation, luceneGeometries);
                query = new IndexOrDocValuesQuery(query, (Query)queryDocValues);
            }
            return query;
        }
    }

    public abstract class ShapeQueryBuilder
    implements QueryBuilder {
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            throw new UnsupportedOperationException("Unimplemented: toXContent()");
        }

        public TransportVersion getMinimalSupportedVersion() {
            throw new UnsupportedOperationException("Unimplemented: toXContent()");
        }

        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException("Unimplemented: toXContent()");
        }

        public Query toQuery(SearchExecutionContext context) throws IOException {
            MappedFieldType fieldType = context.getFieldType(SpatialRelatesQuery.this.field);
            if (fieldType == null) {
                throw new QueryShardException((QueryRewriteContext)context, "failed to find type for field [" + SpatialRelatesQuery.this.field + "]", new Object[0]);
            }
            return this.buildShapeQuery(context, fieldType);
        }

        abstract Query buildShapeQuery(SearchExecutionContext var1, MappedFieldType var2);

        public QueryBuilder queryName(String queryName) {
            throw new UnsupportedOperationException("Unimplemented: String");
        }

        public String queryName() {
            throw new UnsupportedOperationException("Unimplemented: queryName");
        }

        public float boost() {
            return 0.0f;
        }

        public QueryBuilder boost(float boost) {
            throw new UnsupportedOperationException("Unimplemented: float");
        }

        public String getName() {
            throw new UnsupportedOperationException("Unimplemented: getName");
        }

        public String fieldName() {
            return SpatialRelatesQuery.this.field;
        }

        public ShapeRelation relation() {
            return SpatialRelatesQuery.this.shapeRelation();
        }

        public Geometry shape() {
            return SpatialRelatesQuery.this.shape;
        }
    }
}

