/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.esql.io.stream.PlanNameRegistry;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;

final class DataNodeRequest
extends TransportRequest
implements IndicesRequest {
    private static final PlanNameRegistry planNameRegistry = new PlanNameRegistry();
    private final String sessionId;
    private final EsqlConfiguration configuration;
    private final String clusterAlias;
    private final List<ShardId> shardIds;
    private final Map<Index, AliasFilter> aliasFilters;
    private final PhysicalPlan plan;
    private String[] indices;

    DataNodeRequest(String sessionId, EsqlConfiguration configuration, String clusterAlias, List<ShardId> shardIds, Map<Index, AliasFilter> aliasFilters, PhysicalPlan plan) {
        this.sessionId = sessionId;
        this.configuration = configuration;
        this.clusterAlias = clusterAlias;
        this.shardIds = shardIds;
        this.aliasFilters = aliasFilters;
        this.plan = plan;
    }

    DataNodeRequest(StreamInput in) throws IOException {
        super(in);
        this.sessionId = in.readString();
        this.configuration = new EsqlConfiguration(in);
        this.clusterAlias = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_CLUSTER_ALIAS) ? in.readString() : "";
        this.shardIds = in.readCollectionAsList(ShardId::new);
        this.aliasFilters = in.readMap(Index::new, AliasFilter::readFrom);
        this.plan = new PlanStreamInput(in, planNameRegistry, in.namedWriteableRegistry(), this.configuration).readPhysicalPlanNode();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.sessionId);
        this.configuration.writeTo(out);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_CLUSTER_ALIAS)) {
            out.writeString(this.clusterAlias);
        }
        out.writeCollection(this.shardIds);
        out.writeMap(this.aliasFilters);
        new PlanStreamOutput(out, planNameRegistry).writePhysicalPlanNode(this.plan);
    }

    public String[] indices() {
        if (this.indices == null) {
            this.indices = (String[])this.shardIds.stream().map(ShardId::getIndexName).distinct().toArray(String[]::new);
        }
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        if (!parentTaskId.isSet()) {
            assert (false) : "DataNodeRequest must have a parent task";
            throw new IllegalStateException("DataNodeRequest must have a parent task");
        }
        return new CancellableTask(id, type, action, "", parentTaskId, headers){

            public String getDescription() {
                return DataNodeRequest.this.getDescription();
            }
        };
    }

    String sessionId() {
        return this.sessionId;
    }

    EsqlConfiguration configuration() {
        return this.configuration;
    }

    QueryPragmas pragmas() {
        return this.configuration.pragmas();
    }

    String clusterAlias() {
        return this.clusterAlias;
    }

    List<ShardId> shardIds() {
        return this.shardIds;
    }

    Map<Index, AliasFilter> aliasFilters() {
        return this.aliasFilters;
    }

    PhysicalPlan plan() {
        return this.plan;
    }

    public String getDescription() {
        return "shards=" + this.shardIds + " plan=" + this.plan;
    }

    public String toString() {
        return "DataNodeRequest{" + this.getDescription() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DataNodeRequest request = (DataNodeRequest)((Object)o);
        return this.sessionId.equals(request.sessionId) && this.configuration.equals((Object)request.configuration) && this.clusterAlias.equals(request.clusterAlias) && this.shardIds.equals(request.shardIds) && this.aliasFilters.equals(request.aliasFilters) && this.plan.equals((Object)request.plan) && this.getParentTask().equals((Object)request.getParentTask());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sessionId, this.configuration, this.clusterAlias, this.shardIds, this.aliasFilters, this.plan});
    }
}

