/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.transport.TransportResponse;

final class ComputeResponse
extends TransportResponse {
    private final List<DriverProfile> profiles;

    ComputeResponse(List<DriverProfile> profiles) {
        this.profiles = profiles;
    }

    ComputeResponse(StreamInput in) throws IOException {
        super(in);
        this.profiles = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0) ? (in.readBoolean() ? in.readCollectionAsImmutableList(DriverProfile::new) : null) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
            if (this.profiles == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeCollection(this.profiles);
            }
        }
    }

    public List<DriverProfile> getProfiles() {
        return this.profiles;
    }
}

