/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.InsensitiveEquals;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.CIDRMatch;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NullEquals;
import org.elasticsearch.xpack.esql.querydsl.query.SpatialRelatesQuery;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.TypedAttribute;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.planner.ExpressionTranslator;
import org.elasticsearch.xpack.ql.planner.ExpressionTranslators;
import org.elasticsearch.xpack.ql.planner.TranslatorHandler;
import org.elasticsearch.xpack.ql.querydsl.query.MatchAll;
import org.elasticsearch.xpack.ql.querydsl.query.NotQuery;
import org.elasticsearch.xpack.ql.querydsl.query.Query;
import org.elasticsearch.xpack.ql.querydsl.query.RangeQuery;
import org.elasticsearch.xpack.ql.querydsl.query.TermQuery;
import org.elasticsearch.xpack.ql.querydsl.query.TermsQuery;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.Check;
import org.elasticsearch.xpack.ql.util.NumericUtils;
import org.elasticsearch.xpack.versionfield.Version;

public final class EsqlExpressionTranslators {
    public static final List<ExpressionTranslator<?>> QUERY_TRANSLATORS = List.of(new ExpressionTranslator[]{new EqualsIgnoreCaseTranslator(), new BinaryComparisons(), new SpatialRelatesTranslator(), new ExpressionTranslators.Ranges(), new ExpressionTranslators.BinaryLogic(), new ExpressionTranslators.IsNulls(), new ExpressionTranslators.IsNotNulls(), new ExpressionTranslators.Nots(), new ExpressionTranslators.Likes(), new ExpressionTranslators.InComparisons(), new ExpressionTranslators.StringQueries(), new ExpressionTranslators.Matches(), new ExpressionTranslators.MultiMatches(), new Scalars()});

    public static Query toQuery(Expression e, TranslatorHandler handler) {
        Query translation = null;
        for (ExpressionTranslator<?> translator : QUERY_TRANSLATORS) {
            translation = translator.translate(e, handler);
            if (translation == null) continue;
            return translation;
        }
        throw new QlIllegalArgumentException("Don't know how to translate {} {}", new Object[]{e.nodeName(), e});
    }

    public static class EqualsIgnoreCaseTranslator
    extends ExpressionTranslator<InsensitiveEquals> {
        protected Query asQuery(InsensitiveEquals bc, TranslatorHandler handler) {
            return EqualsIgnoreCaseTranslator.doTranslate(bc, handler);
        }

        public static Query doTranslate(InsensitiveEquals bc, TranslatorHandler handler) {
            EqualsIgnoreCaseTranslator.checkInsensitiveComparison(bc);
            return handler.wrapFunctionQuery((ScalarFunction)bc, bc.left(), () -> EqualsIgnoreCaseTranslator.translate(bc));
        }

        public static void checkInsensitiveComparison(InsensitiveEquals bc) {
            Check.isTrue((boolean)bc.right().foldable(), (String)"Line {}:{}: Comparisons against fields are not (currently) supported; offender [{}] in [{}]", (Object[])new Object[]{bc.right().sourceLocation().getLineNumber(), bc.right().sourceLocation().getColumnNumber(), Expressions.name((Expression)bc.right()), bc.symbol()});
        }

        static Query translate(InsensitiveEquals bc) {
            TypedAttribute attribute = EqualsIgnoreCaseTranslator.checkIsPushableAttribute((Expression)bc.left());
            Source source = bc.source();
            BytesRef value = BytesRefs.toBytesRef((Object)ExpressionTranslators.valueOf((Expression)bc.right()));
            String name = EqualsIgnoreCaseTranslator.pushableAttributeName((TypedAttribute)attribute);
            return new TermQuery(source, name, (Object)value.utf8ToString(), true);
        }
    }

    public static class BinaryComparisons
    extends ExpressionTranslator<BinaryComparison> {
        private static final BigDecimal HALF_FLOAT_MAX = BigDecimal.valueOf(65504L);
        private static final BigDecimal UNSIGNED_LONG_MAX = BigDecimal.valueOf(2L).pow(64).subtract(BigDecimal.ONE);

        protected Query asQuery(BinaryComparison bc, TranslatorHandler handler) {
            ExpressionTranslators.BinaryComparisons.checkBinaryComparison((BinaryComparison)bc);
            Query translated = BinaryComparisons.translateOutOfRangeComparisons(bc);
            if (translated != null) {
                return handler.wrapFunctionQuery((ScalarFunction)bc, bc.left(), () -> translated);
            }
            return handler.wrapFunctionQuery((ScalarFunction)bc, bc.left(), () -> BinaryComparisons.translate(bc, handler));
        }

        static Query translate(BinaryComparison bc, TranslatorHandler handler) {
            Object result;
            Check.isTrue((boolean)bc.right().foldable(), (String)"Line {}:{}: Comparisons against fields are not (currently) supported; offender [{}] in [{}]", (Object[])new Object[]{bc.right().sourceLocation().getLineNumber(), bc.right().sourceLocation().getColumnNumber(), Expressions.name((Expression)bc.right()), bc.symbol()});
            TypedAttribute attribute = BinaryComparisons.checkIsPushableAttribute((Expression)bc.left());
            Source source = bc.source();
            String name = handler.nameOf((Expression)attribute);
            Object value = result = bc.right().fold();
            String format = null;
            boolean isDateLiteralComparison = false;
            if (value instanceof ZonedDateTime || value instanceof OffsetTime) {
                DateFormatter formatter;
                if (value instanceof ZonedDateTime) {
                    formatter = EsqlDataTypeConverter.DEFAULT_DATE_TIME_FORMATTER;
                    value = formatter.format((TemporalAccessor)((ZonedDateTime)value));
                } else {
                    formatter = EsqlDataTypeConverter.HOUR_MINUTE_SECOND;
                    value = formatter.format((TemporalAccessor)((OffsetTime)value));
                }
                format = formatter.pattern();
                isDateLiteralComparison = true;
            } else if (attribute.dataType() == DataTypes.IP && value instanceof BytesRef) {
                BytesRef bytesRef = (BytesRef)value;
                value = EsqlDataTypeConverter.ipToString(bytesRef);
            } else if (attribute.dataType() == DataTypes.VERSION) {
                if (value instanceof BytesRef) {
                    BytesRef bytesRef = (BytesRef)value;
                    value = EsqlDataTypeConverter.versionToString(bytesRef);
                } else if (value instanceof Version) {
                    Version version = (Version)value;
                    value = EsqlDataTypeConverter.versionToString(version);
                }
            } else if (attribute.dataType() == DataTypes.UNSIGNED_LONG && value instanceof Long) {
                Long ul = (Long)value;
                value = NumericUtils.unsignedLongAsNumber((long)ul);
            }
            ZoneId zoneId = null;
            if (DataTypes.isDateTime((DataType)attribute.dataType())) {
                zoneId = bc.zoneId();
            }
            if (bc instanceof GreaterThan) {
                return new RangeQuery(source, name, value, false, null, false, format, zoneId);
            }
            if (bc instanceof GreaterThanOrEqual) {
                return new RangeQuery(source, name, value, true, null, false, format, zoneId);
            }
            if (bc instanceof LessThan) {
                return new RangeQuery(source, name, null, false, value, false, format, zoneId);
            }
            if (bc instanceof LessThanOrEqual) {
                return new RangeQuery(source, name, null, false, value, true, format, zoneId);
            }
            if (bc instanceof Equals || bc instanceof NullEquals || bc instanceof NotEquals) {
                name = BinaryComparisons.pushableAttributeName((TypedAttribute)attribute);
                Object query = isDateLiteralComparison ? new RangeQuery(source, name, value, true, value, true, format, zoneId) : new TermQuery(source, name, value);
                if (bc instanceof NotEquals) {
                    query = new NotQuery(source, (Query)query);
                }
                return query;
            }
            throw new QlIllegalArgumentException("Don't know how to translate binary comparison [{}] in [{}]", new Object[]{bc.right().nodeString(), bc});
        }

        private static Query translateOutOfRangeComparisons(BinaryComparison bc) {
            boolean matchAllOrNone;
            Number num;
            if (!(bc.left() instanceof FieldAttribute && bc.left().dataType().isNumeric() && bc.right().foldable())) {
                return null;
            }
            Source source = bc.source();
            Object value = ExpressionTranslators.valueOf((Expression)bc.right());
            if (value instanceof List) {
                return new MatchAll(source).negate(source);
            }
            DataType valueType = bc.right().dataType();
            DataType attributeDataType = bc.left().dataType();
            if (valueType == DataTypes.UNSIGNED_LONG && value instanceof Long) {
                Long ul = (Long)value;
                value = NumericUtils.unsignedLongAsNumber((long)ul);
            }
            if (BinaryComparisons.isInRange(attributeDataType, valueType, num = (Number)value)) {
                return null;
            }
            if (Double.isNaN(((Number)value).doubleValue())) {
                return new MatchAll(source).negate(source);
            }
            if (bc instanceof GreaterThan || bc instanceof GreaterThanOrEqual) {
                matchAllOrNone = !(num.doubleValue() > 0.0);
            } else if (bc instanceof LessThan || bc instanceof LessThanOrEqual) {
                matchAllOrNone = num.doubleValue() > 0.0;
            } else if (bc instanceof Equals || bc instanceof NullEquals) {
                matchAllOrNone = false;
            } else if (bc instanceof NotEquals) {
                matchAllOrNone = true;
            } else {
                throw new QlIllegalArgumentException("Unknown binary comparison [{}]", new Object[]{bc});
            }
            return matchAllOrNone ? new MatchAll(source) : new MatchAll(source).negate(source);
        }

        private static boolean isInRange(DataType numericFieldDataType, DataType valueDataType, Number value) {
            BigDecimal maxValue;
            BigDecimal minValue;
            BigDecimal decimalValue;
            double doubleValue = value.doubleValue();
            if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
                return false;
            }
            if (value instanceof BigInteger) {
                BigInteger bigIntValue = (BigInteger)value;
                decimalValue = new BigDecimal(bigIntValue);
            } else {
                BigDecimal bigDecimal = decimalValue = valueDataType.isRational() ? BigDecimal.valueOf(doubleValue) : BigDecimal.valueOf(value.longValue());
            }
            if (numericFieldDataType == DataTypes.BYTE) {
                minValue = BigDecimal.valueOf(-128L);
                maxValue = BigDecimal.valueOf(127L);
            } else if (numericFieldDataType == DataTypes.SHORT) {
                minValue = BigDecimal.valueOf(-32768L);
                maxValue = BigDecimal.valueOf(32767L);
            } else if (numericFieldDataType == DataTypes.INTEGER) {
                minValue = BigDecimal.valueOf(Integer.MIN_VALUE);
                maxValue = BigDecimal.valueOf(Integer.MAX_VALUE);
            } else if (numericFieldDataType == DataTypes.LONG) {
                minValue = BigDecimal.valueOf(Long.MIN_VALUE);
                maxValue = BigDecimal.valueOf(Long.MAX_VALUE);
            } else if (numericFieldDataType == DataTypes.UNSIGNED_LONG) {
                minValue = BigDecimal.ZERO;
                maxValue = UNSIGNED_LONG_MAX;
            } else if (numericFieldDataType == DataTypes.HALF_FLOAT) {
                minValue = HALF_FLOAT_MAX.negate();
                maxValue = HALF_FLOAT_MAX;
            } else if (numericFieldDataType == DataTypes.FLOAT) {
                minValue = BigDecimal.valueOf(-3.4028234663852886E38);
                maxValue = BigDecimal.valueOf(3.4028234663852886E38);
            } else if (numericFieldDataType == DataTypes.DOUBLE || numericFieldDataType == DataTypes.SCALED_FLOAT) {
                minValue = BigDecimal.valueOf(-1.7976931348623157E308);
                maxValue = BigDecimal.valueOf(Double.MAX_VALUE);
            } else {
                throw new QlIllegalArgumentException("Data type [{}] unsupported for numeric range check", new Object[]{numericFieldDataType});
            }
            return minValue.compareTo(decimalValue) <= 0 && maxValue.compareTo(decimalValue) >= 0;
        }
    }

    public static class SpatialRelatesTranslator
    extends ExpressionTranslator<SpatialRelatesFunction> {
        protected Query asQuery(SpatialRelatesFunction bc, TranslatorHandler handler) {
            return SpatialRelatesTranslator.doTranslate(bc, handler);
        }

        public static void checkSpatialRelatesFunction(Expression constantExpression, ShapeField.QueryRelation queryRelation) {
            Check.isTrue((boolean)constantExpression.foldable(), (String)"Line {}:{}: Comparisons against fields are not (currently) supported; offender [{}] in [ST_{}]", (Object[])new Object[]{constantExpression.sourceLocation().getLineNumber(), constantExpression.sourceLocation().getColumnNumber(), Expressions.name((Expression)constantExpression), queryRelation});
        }

        public static Query wrapFunctionQuery(Expression field, Supplier<Query> querySupplier) {
            return ExpressionTranslator.wrapIfNested((Query)querySupplier.get(), (Expression)field);
        }

        public static Query doTranslate(SpatialRelatesFunction bc, TranslatorHandler handler) {
            if (bc.left().foldable()) {
                SpatialRelatesTranslator.checkSpatialRelatesFunction(bc.left(), bc.queryRelation());
                return SpatialRelatesTranslator.wrapFunctionQuery(bc.right(), () -> SpatialRelatesTranslator.translate(bc, handler, bc.right(), bc.left()));
            }
            SpatialRelatesTranslator.checkSpatialRelatesFunction(bc.right(), bc.queryRelation());
            return SpatialRelatesTranslator.wrapFunctionQuery(bc.left(), () -> SpatialRelatesTranslator.translate(bc, handler, bc.left(), bc.right()));
        }

        static Query translate(SpatialRelatesFunction bc, TranslatorHandler handler, Expression spatialExpression, Expression constantExpression) {
            TypedAttribute attribute = SpatialRelatesTranslator.checkIsPushableAttribute((Expression)spatialExpression);
            String name = handler.nameOf((Expression)attribute);
            try {
                Geometry shape = SpatialRelatesUtils.makeGeometryFromLiteral(constantExpression);
                return new SpatialRelatesQuery(bc.source(), name, bc.queryRelation(), shape, attribute.dataType());
            }
            catch (IllegalArgumentException e) {
                throw new QlIllegalArgumentException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class Scalars
    extends ExpressionTranslator<ScalarFunction> {
        protected Query asQuery(ScalarFunction f, TranslatorHandler handler) {
            return Scalars.doTranslate(f, handler);
        }

        public static Query doTranslate(ScalarFunction f, TranslatorHandler handler) {
            CIDRMatch cm;
            Expression expression;
            if (f instanceof CIDRMatch && (expression = (cm = (CIDRMatch)f).ipField()) instanceof FieldAttribute) {
                FieldAttribute fa = (FieldAttribute)expression;
                if (Expressions.foldable(cm.matches())) {
                    String targetFieldName = handler.nameOf((Expression)fa.exactAttribute());
                    LinkedHashSet set = new LinkedHashSet(Expressions.fold(cm.matches()));
                    TermsQuery query = new TermsQuery(f.source(), targetFieldName, set);
                    return handler.wrapFunctionQuery(f, cm.ipField(), () -> Scalars.lambda$doTranslate$0((Query)query));
                }
            }
            return ExpressionTranslators.Scalars.doTranslate((ScalarFunction)f, (TranslatorHandler)handler);
        }

        private static /* synthetic */ Query lambda$doTranslate$0(Query query) {
            return query;
        }
    }
}

