/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.aggregate.CountDistinct;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.esql.expression.function.aggregate.MedianAbsoluteDeviation;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.esql.expression.function.aggregate.NumericAggregate;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Percentile;
import org.elasticsearch.xpack.esql.expression.function.aggregate.SpatialCentroid;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Values;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.AttributeMap;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.MetadataAttribute;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.expression.function.aggregate.SpatialAggregateFunction;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class AggregateMapper {
    static final List<String> NUMERIC = List.of("Int", "Long", "Double");
    static final List<String> SPATIAL = List.of("GeoPoint", "CartesianPoint");
    static final List<? extends Class<? extends Function>> AGG_FUNCTIONS = List.of(Count.class, CountDistinct.class, Max.class, MedianAbsoluteDeviation.class, Min.class, Percentile.class, SpatialCentroid.class, Sum.class, Values.class);
    private final Map<AggDef, List<IntermediateStateDesc>> mapper;
    private final HashMap<Expression, List<? extends NamedExpression>> cache = new HashMap();

    AggregateMapper() {
        this(AGG_FUNCTIONS);
    }

    AggregateMapper(List<? extends Class<? extends Function>> aggregateFunctionClasses) {
        this.mapper = aggregateFunctionClasses.stream().flatMap(AggregateMapper::typeAndNames).flatMap(AggregateMapper::groupingAndNonGrouping).collect(Collectors.toUnmodifiableMap(aggDef -> aggDef, AggregateMapper::lookupIntermediateState));
    }

    public List<? extends NamedExpression> mapNonGrouping(List<? extends Expression> aggregates) {
        return this.doMapping(aggregates, false);
    }

    public List<? extends NamedExpression> mapNonGrouping(Expression aggregate) {
        return this.map(aggregate, false).toList();
    }

    public List<? extends NamedExpression> mapGrouping(List<? extends Expression> aggregates) {
        return this.doMapping(aggregates, true);
    }

    private List<? extends NamedExpression> doMapping(List<? extends Expression> aggregates, boolean grouping) {
        AttributeMap attrToExpressions = new AttributeMap();
        aggregates.stream().flatMap(agg -> this.map((Expression)agg, grouping)).forEach(ne -> attrToExpressions.put(ne.toAttribute(), ne));
        return attrToExpressions.values().stream().toList();
    }

    public List<? extends NamedExpression> mapGrouping(Expression aggregate) {
        return this.map(aggregate, true).toList();
    }

    private Stream<? extends NamedExpression> map(Expression aggregate, boolean grouping) {
        aggregate = Alias.unwrap((Expression)aggregate);
        return this.cache.computeIfAbsent(aggregate, aggKey -> this.computeEntryForAgg((Expression)aggKey, grouping)).stream();
    }

    private List<? extends NamedExpression> computeEntryForAgg(Expression aggregate, boolean grouping) {
        AggDef aggDef = AggregateMapper.aggDefOrNull(aggregate, grouping);
        if (aggDef != null) {
            List<IntermediateStateDesc> is = this.getNonNull(aggDef);
            List<NamedExpression> exp = AggregateMapper.isToNE(is).toList();
            return exp;
        }
        if (aggregate instanceof FieldAttribute || aggregate instanceof MetadataAttribute || aggregate instanceof ReferenceAttribute) {
            return List.of();
        }
        throw new EsqlIllegalArgumentException("unknown agg: " + aggregate.getClass() + ": " + aggregate);
    }

    private List<IntermediateStateDesc> getNonNull(AggDef aggDef) {
        List<IntermediateStateDesc> l = this.mapper.get(aggDef);
        if (l == null) {
            throw new EsqlIllegalArgumentException("Cannot find intermediate state for: " + aggDef);
        }
        return l;
    }

    private static Stream<Tuple<Class<?>, Tuple<String, String>>> typeAndNames(Class<?> clazz) {
        List<String> types;
        List<String> extraConfigs = List.of("");
        if (NumericAggregate.class.isAssignableFrom(clazz)) {
            types = NUMERIC;
        } else if (clazz == Count.class) {
            types = List.of("");
        } else if (SpatialAggregateFunction.class.isAssignableFrom(clazz)) {
            types = SPATIAL;
            extraConfigs = List.of("SourceValues", "DocValues");
        } else if (Values.class.isAssignableFrom(clazz)) {
            types = List.of("Int", "Long", "Double", "Boolean", "BytesRef");
        } else {
            assert (clazz == CountDistinct.class) : "Expected CountDistinct, got: " + clazz;
            types = Stream.concat(NUMERIC.stream(), Stream.of("Boolean", "BytesRef")).toList();
        }
        return AggregateMapper.combinations(types, extraConfigs).map(combo -> new Tuple((Object)clazz, combo));
    }

    private static Stream<Tuple<String, String>> combinations(List<String> types, List<String> extraConfigs) {
        return types.stream().flatMap(type -> extraConfigs.stream().map(config -> new Tuple(type, config)));
    }

    private static Stream<AggDef> groupingAndNonGrouping(Tuple<Class<?>, Tuple<String, String>> tuple) {
        return Stream.of(new AggDef((Class)tuple.v1(), (String)((Tuple)tuple.v2()).v1(), (String)((Tuple)tuple.v2()).v2(), true), new AggDef((Class)tuple.v1(), (String)((Tuple)tuple.v2()).v1(), (String)((Tuple)tuple.v2()).v2(), false));
    }

    private static AggDef aggDefOrNull(Expression aggregate, boolean grouping) {
        if (aggregate instanceof AggregateFunction) {
            AggregateFunction aggregateFunction = (AggregateFunction)aggregate;
            return new AggDef(aggregateFunction.getClass(), AggregateMapper.dataTypeToString(aggregateFunction.field().dataType(), aggregateFunction.getClass()), aggregate instanceof SpatialCentroid ? "SourceValues" : "", grouping);
        }
        return null;
    }

    private static List<IntermediateStateDesc> lookupIntermediateState(AggDef aggDef) {
        try {
            return AggregateMapper.lookup(aggDef.aggClazz(), aggDef.type(), aggDef.extra(), aggDef.grouping()).invokeExact();
        }
        catch (Throwable t) {
            throw new EsqlIllegalArgumentException(t);
        }
    }

    private static MethodHandle lookup(Class<?> clazz, String type, String extra, boolean grouping) {
        try {
            return MethodHandles.lookup().findStatic(Class.forName(AggregateMapper.determineAggName(clazz, type, extra, grouping)), "intermediateStateDesc", MethodType.methodType(List.class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new EsqlIllegalArgumentException(e);
        }
    }

    private static String determineAggName(Class<?> clazz, String type, String extra, boolean grouping) {
        StringBuilder sb = new StringBuilder();
        sb.append(AggregateMapper.determinePackageName(clazz)).append(".");
        sb.append(clazz.getSimpleName());
        sb.append(type);
        sb.append(extra);
        sb.append(grouping ? "Grouping" : "");
        sb.append("AggregatorFunction");
        return sb.toString();
    }

    private static String determinePackageName(Class<?> clazz) {
        if (clazz.getSimpleName().startsWith("Spatial")) {
            return "org.elasticsearch.compute.aggregation.spatial";
        }
        return "org.elasticsearch.compute.aggregation";
    }

    private static Stream<NamedExpression> isToNE(List<IntermediateStateDesc> intermediateStateDescs) {
        return intermediateStateDescs.stream().map(is -> new ReferenceAttribute(Source.EMPTY, is.name(), AggregateMapper.toDataType(is.type())));
    }

    private static DataType toDataType(ElementType elementType) {
        return switch (elementType) {
            case ElementType.BOOLEAN -> DataTypes.BOOLEAN;
            case ElementType.BYTES_REF -> DataTypes.KEYWORD;
            case ElementType.INT -> DataTypes.INTEGER;
            case ElementType.LONG -> DataTypes.LONG;
            case ElementType.DOUBLE -> DataTypes.DOUBLE;
            default -> throw new EsqlIllegalArgumentException("unsupported agg type: " + elementType);
        };
    }

    private static String dataTypeToString(DataType type, Class<?> aggClass) {
        if (aggClass == Count.class) {
            return "";
        }
        if (type.equals((Object)DataTypes.BOOLEAN)) {
            return "Boolean";
        }
        if (type.equals((Object)DataTypes.INTEGER)) {
            return "Int";
        }
        if (type.equals((Object)DataTypes.LONG) || type.equals((Object)DataTypes.DATETIME)) {
            return "Long";
        }
        if (type.equals((Object)DataTypes.DOUBLE)) {
            return "Double";
        }
        if (type.equals((Object)DataTypes.KEYWORD) || type.equals((Object)DataTypes.IP) || type.equals((Object)DataTypes.VERSION) || type.equals((Object)DataTypes.TEXT)) {
            return "BytesRef";
        }
        if (type.equals((Object)EsqlDataTypes.GEO_POINT)) {
            return "GeoPoint";
        }
        if (type.equals((Object)EsqlDataTypes.CARTESIAN_POINT)) {
            return "CartesianPoint";
        }
        throw new EsqlIllegalArgumentException("illegal agg type: " + type.typeName());
    }

    private static Expression unwrapAlias(Expression expression) {
        if (expression instanceof Alias) {
            Alias alias = (Alias)expression;
            return alias.child();
        }
        return expression;
    }

    record AggDef(Class<?> aggClazz, String type, String extra, boolean grouping) {
    }
}

