/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class FragmentExec
extends LeafExec
implements EstimatesRowSize {
    private final LogicalPlan fragment;
    private final QueryBuilder esFilter;
    private final PhysicalPlan reducer;
    private final int estimatedRowSize;

    public FragmentExec(LogicalPlan fragment) {
        this(fragment.source(), fragment, null, 0, null);
    }

    public FragmentExec(Source source, LogicalPlan fragment, QueryBuilder esFilter, int estimatedRowSize, PhysicalPlan reducer) {
        super(source);
        this.fragment = fragment;
        this.esFilter = esFilter;
        this.estimatedRowSize = estimatedRowSize;
        this.reducer = reducer;
    }

    public LogicalPlan fragment() {
        return this.fragment;
    }

    public QueryBuilder esFilter() {
        return this.esFilter;
    }

    public Integer estimatedRowSize() {
        return this.estimatedRowSize;
    }

    public PhysicalPlan reducer() {
        return this.reducer;
    }

    protected NodeInfo<FragmentExec> info() {
        return NodeInfo.create((Node)this, FragmentExec::new, (Object)this.fragment, (Object)this.esFilter, (Object)this.estimatedRowSize, (Object)((Object)this.reducer));
    }

    public List<Attribute> output() {
        return this.fragment.output();
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        int estimatedRowSize = state.consumeAllFields(false);
        return Objects.equals(estimatedRowSize, this.estimatedRowSize) ? this : new FragmentExec(this.source(), this.fragment, this.esFilter, estimatedRowSize, this.reducer);
    }

    public FragmentExec withFilter(QueryBuilder filter) {
        return Objects.equals(filter, this.esFilter) ? this : new FragmentExec(this.source(), this.fragment, filter, this.estimatedRowSize, this.reducer);
    }

    public FragmentExec withReducer(PhysicalPlan reducer) {
        return Objects.equals((Object)reducer, (Object)this.reducer) ? this : new FragmentExec(this.source(), this.fragment, this.esFilter, this.estimatedRowSize, reducer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.fragment, this.esFilter, this.estimatedRowSize, this.reducer});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FragmentExec other = (FragmentExec)obj;
        return Objects.equals(this.fragment, other.fragment) && Objects.equals(this.esFilter, other.esFilter) && Objects.equals(this.estimatedRowSize, other.estimatedRowSize) && Objects.equals((Object)this.reducer, (Object)other.reducer);
    }

    public String nodeString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nodeName());
        sb.append("[filter=");
        sb.append(this.esFilter);
        sb.append(", estimatedRowSize=");
        sb.append(this.estimatedRowSize);
        sb.append(", reducer=[");
        sb.append(this.reducer == null ? "" : this.reducer.toString());
        sb.append("], fragment=[<>\n");
        sb.append(this.fragment.toString());
        sb.append("<>]]");
        return sb.toString();
    }
}

