/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.NodeUtils;
import org.elasticsearch.xpack.ql.tree.Source;

public class FieldExtractExec
extends UnaryExec
implements EstimatesRowSize {
    private final List<Attribute> attributesToExtract;
    private final Attribute sourceAttribute;
    private final Set<Attribute> docValuesAttributes;
    private List<Attribute> lazyOutput;

    public FieldExtractExec(Source source, PhysicalPlan child, List<Attribute> attributesToExtract) {
        this(source, child, attributesToExtract, Collections.emptySet());
    }

    public FieldExtractExec(Source source, PhysicalPlan child, List<Attribute> attributesToExtract, Set<Attribute> docValuesAttributes) {
        super(source, child);
        this.attributesToExtract = attributesToExtract;
        this.sourceAttribute = FieldExtractExec.extractSourceAttributesFrom(child);
        this.docValuesAttributes = docValuesAttributes;
    }

    public static Attribute extractSourceAttributesFrom(PhysicalPlan plan) {
        for (Attribute attribute : plan.outputSet()) {
            if (!EsQueryExec.isSourceAttribute(attribute)) continue;
            return attribute;
        }
        return null;
    }

    protected NodeInfo<FieldExtractExec> info() {
        return NodeInfo.create((Node)this, FieldExtractExec::new, (Object)((Object)this.child()), this.attributesToExtract, this.docValuesAttributes);
    }

    @Override
    public UnaryExec replaceChild(PhysicalPlan newChild) {
        return new FieldExtractExec(this.source(), newChild, this.attributesToExtract, this.docValuesAttributes);
    }

    public List<Attribute> attributesToExtract() {
        return this.attributesToExtract;
    }

    public Attribute sourceAttribute() {
        return this.sourceAttribute;
    }

    public Collection<Attribute> docValuesAttributes() {
        return this.docValuesAttributes;
    }

    public boolean hasDocValuesAttribute(Attribute attr) {
        return this.docValuesAttributes.contains(attr);
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            List childOutput = this.child().output();
            this.lazyOutput = new ArrayList<Attribute>(childOutput.size() + this.attributesToExtract.size());
            this.lazyOutput.addAll(childOutput);
            this.lazyOutput.addAll(this.attributesToExtract);
        }
        return this.lazyOutput;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(true, this.attributesToExtract);
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.attributesToExtract, this.docValuesAttributes, this.child()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldExtractExec other = (FieldExtractExec)obj;
        return Objects.equals(this.attributesToExtract, other.attributesToExtract) && Objects.equals(this.docValuesAttributes, other.docValuesAttributes) && Objects.equals((Object)this.child(), (Object)other.child());
    }

    public String nodeString() {
        return this.nodeName() + NodeUtils.limitedToString(this.attributesToExtract) + "<" + NodeUtils.limitedToString(this.docValuesAttributes) + ">";
    }
}

