/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class AggregateExec
extends UnaryExec
implements EstimatesRowSize {
    private final List<? extends Expression> groupings;
    private final List<? extends NamedExpression> aggregates;
    private final Mode mode;
    private final Integer estimatedRowSize;

    public AggregateExec(Source source, PhysicalPlan child, List<? extends Expression> groupings, List<? extends NamedExpression> aggregates, Mode mode, Integer estimatedRowSize) {
        super(source, child);
        this.groupings = groupings;
        this.aggregates = aggregates;
        this.mode = mode;
        this.estimatedRowSize = estimatedRowSize;
    }

    protected NodeInfo<AggregateExec> info() {
        return NodeInfo.create((Node)this, AggregateExec::new, (Object)((Object)this.child()), this.groupings, this.aggregates, (Object)((Object)this.mode), (Object)this.estimatedRowSize);
    }

    @Override
    public AggregateExec replaceChild(PhysicalPlan newChild) {
        return new AggregateExec(this.source(), newChild, this.groupings, this.aggregates, this.mode, this.estimatedRowSize);
    }

    public List<? extends Expression> groupings() {
        return this.groupings;
    }

    public List<? extends NamedExpression> aggregates() {
        return this.aggregates;
    }

    public Integer estimatedRowSize() {
        return this.estimatedRowSize;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(false, this.aggregates);
        int size = state.consumeAllFields(true);
        return Objects.equals(this.estimatedRowSize, size) ? this : new AggregateExec(this.source(), this.child(), this.groupings, this.aggregates, this.mode, size);
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public List<Attribute> output() {
        return Expressions.asAttributes(this.aggregates);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.groupings, this.aggregates, this.mode, this.estimatedRowSize, this.child()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AggregateExec other = (AggregateExec)obj;
        return Objects.equals(this.groupings, other.groupings) && Objects.equals(this.aggregates, other.aggregates) && Objects.equals((Object)this.mode, (Object)other.mode) && Objects.equals(this.estimatedRowSize, other.estimatedRowSize) && Objects.equals((Object)this.child(), (Object)other.child());
    }

    public static enum Mode {
        SINGLE,
        PARTIAL,
        FINAL;

    }
}

