/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.elasticsearch.xpack.esql.optimizer.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.tree.Node;

public final class PhysicalVerifier {
    public static final PhysicalVerifier INSTANCE = new PhysicalVerifier();
    private static final OptimizerRules.PhysicalPlanDependencyCheck DEPENDENCY_CHECK = new OptimizerRules.PhysicalPlanDependencyCheck();

    private PhysicalVerifier() {
    }

    public Collection<Failure> verify(PhysicalPlan plan) {
        LinkedHashSet<Failure> failures = new LinkedHashSet<Failure>();
        plan.forEachDown(p -> {
            FieldExtractExec fieldExtractExec;
            Attribute sourceAttribute;
            if (p instanceof FieldExtractExec && (sourceAttribute = (fieldExtractExec = (FieldExtractExec)p).sourceAttribute()) == null) {
                failures.add(Failure.fail((Node)fieldExtractExec, (String)"Need to add field extractor for [{}] but cannot detect source attributes from node [{}]", (Object[])new Object[]{Expressions.names(fieldExtractExec.attributesToExtract()), fieldExtractExec.child()}));
            }
        });
        return failures;
    }
}

