/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalVerifier;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.EnrichExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.MvExpandExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.ProjectExec;
import org.elasticsearch.xpack.esql.plan.physical.RegexExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeMap;
import org.elasticsearch.xpack.ql.expression.AttributeSet;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.Holder;

public class PhysicalPlanOptimizer
extends ParameterizedRuleExecutor<PhysicalPlan, PhysicalOptimizerContext> {
    private static final Iterable<RuleExecutor.Batch<PhysicalPlan>> rules = PhysicalPlanOptimizer.initializeRules(true);
    private final PhysicalVerifier verifier = PhysicalVerifier.INSTANCE;

    public PhysicalPlanOptimizer(PhysicalOptimizerContext context) {
        super((Object)context);
    }

    public PhysicalPlan optimize(PhysicalPlan plan) {
        return this.verify((PhysicalPlan)this.execute((Node)plan));
    }

    PhysicalPlan verify(PhysicalPlan plan) {
        Collection<Failure> failures = this.verifier.verify(plan);
        if (!failures.isEmpty()) {
            throw new VerificationException(failures);
        }
        return plan;
    }

    static List<RuleExecutor.Batch<PhysicalPlan>> initializeRules(boolean isOptimizedForEsSource) {
        RuleExecutor.Batch boundary = new RuleExecutor.Batch("Plan Boundary", RuleExecutor.Limiter.ONCE, new Rule[]{new ProjectAwayColumns()});
        return Arrays.asList(boundary);
    }

    protected Iterable<RuleExecutor.Batch<PhysicalPlan>> batches() {
        return rules;
    }

    static class ProjectAwayColumns
    extends Rule<PhysicalPlan, PhysicalPlan> {
        ProjectAwayColumns() {
        }

        public PhysicalPlan apply(PhysicalPlan plan) {
            Holder projectAll = new Holder((Object)Boolean.TRUE);
            Holder keepCollecting = new Holder((Object)Boolean.TRUE);
            AttributeSet attributes = new AttributeSet();
            AttributeMap aliases = new AttributeMap();
            return (PhysicalPlan)plan.transformDown(UnaryExec.class, p -> {
                if (p instanceof ProjectExec || p instanceof AggregateExec) {
                    projectAll.set((Object)Boolean.FALSE);
                }
                if (((Boolean)keepCollecting.get()).booleanValue()) {
                    p.forEachExpression(NamedExpression.class, ne -> {
                        Attribute attr = ne.toAttribute();
                        if (ne instanceof Alias) {
                            Alias as = (Alias)ne;
                            aliases.put(attr, (Object)as.child());
                            attributes.remove((Object)attr);
                        } else if (!attr.synthetic() && !aliases.containsKey((Object)attr)) {
                            attributes.add(attr);
                        }
                    });
                    if (p instanceof RegexExtractExec) {
                        RegexExtractExec ree = (RegexExtractExec)p;
                        attributes.removeAll(ree.extractedFields());
                    }
                    if (p instanceof MvExpandExec) {
                        MvExpandExec mvee = (MvExpandExec)((Object)p);
                        attributes.remove((Object)mvee.expanded());
                    }
                    if (p instanceof EnrichExec) {
                        EnrichExec ee = (EnrichExec)p;
                        for (NamedExpression enrichField : ee.enrichFields()) {
                            NamedExpression namedExpression;
                            if (enrichField instanceof Alias) {
                                Alias a = (Alias)enrichField;
                                namedExpression = a.child();
                            } else {
                                namedExpression = enrichField;
                            }
                            attributes.remove((Object)namedExpression);
                        }
                    }
                }
                if (p instanceof ExchangeExec) {
                    FragmentExec fragmentExec;
                    Object logicalFragment;
                    ExchangeExec exec = (ExchangeExec)((Object)p);
                    keepCollecting.set((Object)Boolean.FALSE);
                    PhysicalPlan child = exec.child();
                    if (child instanceof FragmentExec && !((logicalFragment = (fragmentExec = (FragmentExec)child).fragment()) instanceof Aggregate)) {
                        List output;
                        Boolean selectAll = (Boolean)projectAll.get();
                        List list = output = selectAll != false ? exec.child().output() : new ArrayList(attributes);
                        if (output.isEmpty()) {
                            Alias alias = new Alias(logicalFragment.source(), "<all-fields-projected>", null, (Expression)Literal.NULL, null, true);
                            List<Alias> fields = Collections.singletonList(alias);
                            logicalFragment = new Eval(logicalFragment.source(), (LogicalPlan)logicalFragment, fields);
                            output = Expressions.asAttributes(fields);
                        }
                        p = exec.replaceChild(new FragmentExec(Source.EMPTY, (LogicalPlan)new Project(logicalFragment.source(), logicalFragment, output), fragmentExec.esFilter(), fragmentExec.estimatedRowSize(), fragmentExec.reducer()));
                    }
                }
                return p;
            });
        }
    }
}

