/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Case;
import org.elasticsearch.xpack.esql.expression.function.scalar.nulls.Coalesce;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesFunction;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LogicalVerifier;
import org.elasticsearch.xpack.esql.optimizer.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.analyzer.AnalyzerRules;
import org.elasticsearch.xpack.ql.common.Failures;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeMap;
import org.elasticsearch.xpack.ql.expression.AttributeSet;
import org.elasticsearch.xpack.ql.expression.EmptyAttribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.ExpressionSet;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.expression.predicate.Predicates;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RegexMatch;
import org.elasticsearch.xpack.ql.optimizer.OptimizerRules;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.rule.ParameterizedRule;
import org.elasticsearch.xpack.ql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.ql.util.Holder;

public class LogicalPlanOptimizer
extends ParameterizedRuleExecutor<LogicalPlan, LogicalOptimizerContext> {
    private final LogicalVerifier verifier = LogicalVerifier.INSTANCE;

    public LogicalPlanOptimizer(LogicalOptimizerContext optimizerContext) {
        super((Object)optimizerContext);
    }

    public LogicalPlan optimize(LogicalPlan verified) {
        LogicalPlan optimized = (LogicalPlan)this.execute((Node)verified);
        Failures failures = this.verifier.verify(optimized);
        if (failures.hasFailures()) {
            throw new VerificationException(failures);
        }
        return optimized;
    }

    protected List<RuleExecutor.Batch<LogicalPlan>> batches() {
        return LogicalPlanOptimizer.rules();
    }

    protected static RuleExecutor.Batch<LogicalPlan> substitutions() {
        return new RuleExecutor.Batch("Substitutions", RuleExecutor.Limiter.ONCE, new Rule[]{new RemoveStatsOverride(), new ReplaceStatsNestedExpressionWithEval(), new ReplaceStatsAggExpressionWithEval(), new SubstituteSurrogates(), new ReplaceRegexMatch(), new ReplaceAliasingEvalWithProject(), new SkipQueryOnEmptyMappings(), new SubstituteSpatialSurrogates(), new ReplaceOrderByExpressionWithEval()});
    }

    protected static RuleExecutor.Batch<LogicalPlan> operators() {
        return new RuleExecutor.Batch("Operator Optimization", new Rule[]{new CombineProjections(), new CombineEvals(), new PruneEmptyPlans(), new PropagateEmptyRelation(), new ConvertStringToByteRef(), new FoldNull(), new SplitInWithFoldableValue(), new PropagateEvalFoldables(), new OptimizerRules.ConstantFolding(), new PartiallyFoldCase(), new BooleanSimplification(), new OptimizerRules.LiteralsOnTheRight(), new OptimizerRules.PropagateEquals(), new PropagateNullable(), new OptimizerRules.BooleanFunctionEqualsElimination(), new OptimizerRules.CombineDisjunctionsToIn(), new OptimizerRules.SimplifyComparisonsArithmetics(EsqlDataTypes::areCompatible), new PruneFilters(), new PruneColumns(), new OptimizerRules.PruneLiteralsInOrderBy(), new PushDownAndCombineLimits(), new DuplicateLimitAfterMvExpand(), new PushDownAndCombineFilters(), new PushDownEval(), new PushDownRegexExtract(), new PushDownEnrich(), new PushDownAndCombineOrderBy(), new PruneOrderByBeforeStats(), new PruneRedundantSortClauses()});
    }

    protected static RuleExecutor.Batch<LogicalPlan> cleanup() {
        return new RuleExecutor.Batch("Clean Up", new Rule[]{new ReplaceLimitAndSortAsTopN()});
    }

    protected static List<RuleExecutor.Batch<LogicalPlan>> rules() {
        RuleExecutor.Batch skip = new RuleExecutor.Batch("Skip Compute", new Rule[]{new SkipQueryOnLimitZero()});
        RuleExecutor.Batch defaultTopN = new RuleExecutor.Batch("Add default TopN", new Rule[]{new AddDefaultTopN()});
        RuleExecutor.Batch label = new RuleExecutor.Batch("Set as Optimized", RuleExecutor.Limiter.ONCE, new Rule[]{new OptimizerRules.SetAsOptimized()});
        return Arrays.asList(LogicalPlanOptimizer.substitutions(), LogicalPlanOptimizer.operators(), skip, LogicalPlanOptimizer.cleanup(), defaultTopN, label);
    }

    private static LogicalPlan skipPlan(UnaryPlan plan) {
        return new LocalRelation(plan.source(), plan.output(), LocalSupplier.EMPTY);
    }

    private static LogicalPlan skipPlan(UnaryPlan plan, LocalSupplier supplier) {
        return new LocalRelation(plan.source(), plan.output(), supplier);
    }

    private static LogicalPlan pushGeneratingPlanPastProjectAndOrderBy(UnaryPlan generatingPlan, List<Attribute> generatedAttributes) {
        LogicalPlan child = generatingPlan.child();
        if (child instanceof OrderBy) {
            OrderBy orderBy = (OrderBy)child;
            LinkedHashSet<String> evalFieldNames = new LinkedHashSet<String>(Expressions.names(generatedAttributes));
            AttributeReplacement nonShadowedOrders = LogicalPlanOptimizer.renameAttributesInExpressions(evalFieldNames, orderBy.order());
            AttributeMap<Alias> aliasesForShadowedOrderByAttrs = nonShadowedOrders.replacedAttributes;
            List<Expression> newOrder = nonShadowedOrders.rewrittenExpressions;
            if (!aliasesForShadowedOrderByAttrs.isEmpty()) {
                ArrayList<Alias> newAliases = new ArrayList<Alias>(aliasesForShadowedOrderByAttrs.values());
                Eval plan = new Eval(orderBy.source(), orderBy.child(), newAliases);
                plan = generatingPlan.replaceChild((LogicalPlan)plan);
                plan = new OrderBy(orderBy.source(), (LogicalPlan)plan, newOrder);
                plan = new Project(generatingPlan.source(), (LogicalPlan)plan, generatingPlan.output());
                return plan;
            }
            return orderBy.replaceChild((LogicalPlan)generatingPlan.replaceChild(orderBy.child()));
        }
        if (child instanceof Project) {
            Project projectWithEvalChild = LogicalPlanOptimizer.pushDownPastProject(generatingPlan);
            return projectWithEvalChild.withProjections(NamedExpressions.mergeOutputExpressions(generatedAttributes, projectWithEvalChild.projections()));
        }
        return generatingPlan;
    }

    private static AttributeReplacement renameAttributesInExpressions(Set<String> attributeNamesToRename, List<? extends Expression> expressions) {
        AttributeMap aliasesForReplacedAttributes = new AttributeMap();
        ArrayList<Expression> rewrittenExpressions = new ArrayList<Expression>();
        for (Expression expression : expressions) {
            rewrittenExpressions.add((Expression)expression.transformUp(Attribute.class, attr -> {
                if (attributeNamesToRename.contains(attr.name())) {
                    Alias renamedAttribute = (Alias)aliasesForReplacedAttributes.computeIfAbsent(attr, a -> {
                        String tempName = SubstituteSurrogates.rawTemporaryName(a.name(), "temp_name", a.id().toString());
                        return new Alias(a.source(), tempName, null, (Expression)a, null, false);
                    });
                    return renamedAttribute.toAttribute();
                }
                return attr;
            }));
        }
        return new AttributeReplacement(rewrittenExpressions, (AttributeMap<Alias>)aliasesForReplacedAttributes);
    }

    private static Project pushDownPastProject(UnaryPlan parent) {
        LogicalPlan logicalPlan = parent.child();
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            AttributeMap.Builder aliasBuilder = AttributeMap.builder();
            project.forEachExpression(Alias.class, a -> aliasBuilder.put(a.toAttribute(), (Object)a.child()));
            AttributeMap aliases = aliasBuilder.build();
            UnaryPlan expressionsWithResolvedAliases = (UnaryPlan)parent.transformExpressionsOnly(ReferenceAttribute.class, r -> (Expression)aliases.resolve(r, r));
            return project.replaceChild((LogicalPlan)expressionsWithResolvedAliases.replaceChild(project.child()));
        }
        throw new EsqlIllegalArgumentException("Expected child to be instance of Project");
    }

    private static class RemoveStatsOverride
    extends AnalyzerRules.AnalyzerRule<Aggregate> {
        private RemoveStatsOverride() {
        }

        protected boolean skipResolved() {
            return false;
        }

        protected LogicalPlan rule(Aggregate agg) {
            return agg.resolved() ? RemoveStatsOverride.removeAggDuplicates(agg) : agg;
        }

        private static Aggregate removeAggDuplicates(Aggregate agg) {
            List groupings = agg.groupings();
            List aggregates = agg.aggregates();
            groupings = RemoveStatsOverride.removeDuplicateNames(groupings);
            aggregates = RemoveStatsOverride.removeDuplicateNames(aggregates);
            return new Aggregate(agg.source(), agg.child(), groupings, aggregates);
        }

        private static <T extends Expression> List<T> removeDuplicateNames(List<T> list) {
            ArrayList<T> newList = new ArrayList<T>(list);
            HashSet nameSet = Sets.newHashSetWithExpectedSize((int)list.size());
            for (int i = list.size() - 1; i >= 0; --i) {
                Expression element = (Expression)list.get(i);
                String name = Expressions.name((Expression)element);
                if (nameSet.add(name)) continue;
                newList.remove(i);
            }
            return newList.size() == list.size() ? list : newList;
        }
    }

    static class ReplaceStatsNestedExpressionWithEval
    extends OptimizerRules.OptimizerRule<Aggregate> {
        ReplaceStatsNestedExpressionWithEval() {
        }

        protected LogicalPlan rule(Aggregate aggregate) {
            ArrayList<Alias> evals = new ArrayList<Alias>();
            HashMap<String, Object> evalNames = new HashMap<String, Object>();
            HashMap<GroupingFunction, Object> groupingAttributes = new HashMap<GroupingFunction, Object>();
            ArrayList<Object> newGroupings = new ArrayList<Object>(aggregate.groupings());
            boolean groupingChanged = false;
            int s = newGroupings.size();
            for (int i = 0; i < s; ++i) {
                Expression g = (Expression)newGroupings.get(i);
                if (!(g instanceof Alias)) continue;
                Alias as2 = (Alias)g;
                groupingChanged = true;
                Attribute attr = as2.toAttribute();
                evals.add(as2);
                evalNames.put(as2.name(), attr);
                newGroupings.set(i, attr);
                Expression expression = as2.child();
                if (!(expression instanceof GroupingFunction)) continue;
                GroupingFunction groupingFunction = (GroupingFunction)expression;
                groupingAttributes.put(groupingFunction, attr);
            }
            Holder aggsChanged = new Holder((Object)false);
            List aggs = aggregate.aggregates();
            ArrayList<NamedExpression> newAggs = new ArrayList<NamedExpression>(aggs.size());
            HashMap<Expression, Attribute> expToAttribute = new HashMap<Expression, Attribute>();
            for (Alias alias : evals) {
                expToAttribute.put(alias.child().canonical(), alias.toAttribute());
            }
            int[] counter = new int[]{0};
            for (NamedExpression agg : aggs) {
                NamedExpression a = (NamedExpression)agg.transformDown(Alias.class, as -> {
                    AggregateFunction af2;
                    Expression child = as.child();
                    if (child instanceof AggregateFunction && (af2 = (AggregateFunction)child).field() instanceof Attribute) {
                        return as;
                    }
                    Attribute ref = (Attribute)evalNames.get(as.name());
                    if (ref != null) {
                        aggsChanged.set((Object)true);
                        return ref;
                    }
                    Expression replaced = (Expression)child.transformUp(AggregateFunction.class, af -> {
                        AggregateFunction result = af;
                        Expression field = af.field();
                        if (!(field instanceof Attribute) && !field.foldable()) {
                            Attribute attr = expToAttribute.computeIfAbsent(field.canonical(), k -> {
                                int n = counter[0];
                                counter[0] = n + 1;
                                Alias newAlias = new Alias(k.source(), ReplaceStatsNestedExpressionWithEval.syntheticName(k, af, n), null, k, null, true);
                                evals.add(newAlias);
                                return newAlias.toAttribute();
                            });
                            aggsChanged.set((Object)true);
                            ArrayList<Attribute> newChildren = new ArrayList<Attribute>(af.children());
                            newChildren.set(0, attr);
                            result = (Expression)af.replaceChildren(newChildren);
                        }
                        return result;
                    });
                    replaced = (Expression)replaced.transformDown(GroupingFunction.class, gf -> {
                        aggsChanged.set((Object)true);
                        return (Expression)groupingAttributes.get(gf);
                    });
                    return as.replaceChild(replaced);
                });
                newAggs.add(a);
            }
            if (evals.size() > 0) {
                List<Object> list = groupingChanged ? newGroupings : aggregate.groupings();
                List<Object> aggregates = (Boolean)aggsChanged.get() != false ? newAggs : aggregate.aggregates();
                Eval newEval = new Eval(aggregate.source(), aggregate.child(), evals);
                aggregate = new Aggregate(aggregate.source(), (LogicalPlan)newEval, list, aggregates);
            }
            return aggregate;
        }

        static String syntheticName(Expression expression, AggregateFunction af, int counter) {
            return SubstituteSurrogates.temporaryName(expression, (Expression)af, counter);
        }
    }

    static class ReplaceStatsAggExpressionWithEval
    extends OptimizerRules.OptimizerRule<Aggregate> {
        ReplaceStatsAggExpressionWithEval() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected LogicalPlan rule(Aggregate aggregate) {
            AttributeMap aliases = new AttributeMap();
            aggregate.forEachExpressionUp(Alias.class, a -> aliases.put(a.toAttribute(), (Object)a.child()));
            List aggs = aggregate.aggregates();
            LinkedHashMap rootAggs = Maps.newLinkedHashMapWithExpectedSize((int)aggs.size());
            ArrayList<Alias> newEvals = new ArrayList<Alias>();
            ArrayList<Object> newProjections = new ArrayList<Object>();
            ArrayList<Object> newAggs = new ArrayList<Object>();
            Holder changed = new Holder((Object)false);
            int[] counter = new int[]{0};
            for (NamedExpression agg : aggs) {
                if (agg instanceof Alias) {
                    Alias as = (Alias)agg;
                    Expression child = as.child();
                    if (child instanceof AggregateFunction) {
                        AggregateFunction af2 = (AggregateFunction)child;
                        AggregateFunction canonical = (AggregateFunction)af2.canonical();
                        Expression field = (Expression)canonical.field().transformUp(e -> (Expression)aliases.resolve(e, e));
                        Alias found = (Alias)rootAggs.get(canonical = (AggregateFunction)canonical.replaceChildren(CollectionUtils.combine((Collection[])new Collection[]{Collections.singleton(field), canonical.parameters()})));
                        if (found == null) {
                            rootAggs.put(canonical, as);
                            newAggs.add(as);
                            newProjections.add(as.toAttribute());
                            continue;
                        }
                        changed.set((Object)true);
                        newProjections.add(as.replaceChild((Expression)found.toAttribute()));
                        continue;
                    }
                    changed.set((Object)true);
                    Expression aggExpression = (Expression)child.transformUp(AggregateFunction.class, af -> {
                        AggregateFunction canonical = (AggregateFunction)af.canonical();
                        Alias alias = (Alias)rootAggs.get(canonical);
                        if (alias == null) {
                            int n = counter[0];
                            counter[0] = n + 1;
                            alias = new Alias(af.source(), ReplaceStatsAggExpressionWithEval.syntheticName((Expression)canonical, child, n), as.qualifier(), (Expression)canonical, null, true);
                            rootAggs.put(canonical, alias);
                            newAggs.add(alias);
                        }
                        return alias.toAttribute();
                    });
                    Alias alias = as.replaceChild(aggExpression);
                    newEvals.add(alias);
                    newProjections.add(alias.toAttribute());
                    continue;
                }
                newAggs.add(agg);
                newProjections.add(agg.toAttribute());
            }
            Object plan = aggregate;
            if (((Boolean)changed.get()).booleanValue()) {
                Source source = aggregate.source();
                plan = new Aggregate(source, aggregate.child(), aggregate.groupings(), newAggs);
                if (newEvals.size() > 0) {
                    plan = new Eval(source, (LogicalPlan)plan, newEvals);
                }
                plan = new Project(source, (LogicalPlan)plan, newProjections);
            }
            return plan;
        }

        static String syntheticName(Expression expression, Expression af, int counter) {
            return SubstituteSurrogates.temporaryName(expression, af, counter);
        }
    }

    static class SubstituteSurrogates
    extends OptimizerRules.OptimizerRule<Aggregate> {
        static int TO_STRING_LIMIT = 16;

        SubstituteSurrogates() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected LogicalPlan rule(Aggregate aggregate) {
            List aggs = aggregate.aggregates();
            ArrayList<NamedExpression> newAggs = new ArrayList<NamedExpression>(aggs.size());
            HashMap<AggregateFunction, Attribute> aggFuncToAttr = new HashMap<AggregateFunction, Attribute>();
            ArrayList<Alias> transientEval = new ArrayList<Alias>();
            boolean changed = false;
            for (Object agg : aggs) {
                SurrogateExpression se;
                AggregateFunction af2;
                Expression expression = Alias.unwrap((Expression)agg);
                if (!(expression instanceof AggregateFunction) || (af2 = (AggregateFunction)expression) instanceof SurrogateExpression && (se = (SurrogateExpression)af2).surrogate() != null) continue;
                aggFuncToAttr.put(af2, agg.toAttribute());
            }
            int[] counter = new int[]{0};
            for (NamedExpression agg : aggs) {
                SurrogateExpression sf;
                Expression e = Alias.unwrap((Expression)agg);
                if (e instanceof SurrogateExpression && (sf = (SurrogateExpression)e).surrogate() != null) {
                    changed = true;
                    Expression s = sf.surrogate();
                    if (!(s instanceof AggregateFunction)) {
                        Expression surrogateWithRefs = (Expression)s.transformUp(AggregateFunction.class, af -> {
                            Attribute attr = (Attribute)aggFuncToAttr.get(af);
                            if (attr == null) {
                                int n = counter[0];
                                counter[0] = n + 1;
                                String temporaryName = SubstituteSurrogates.temporaryName((Expression)af, (Expression)agg, n);
                                Alias newAlias = new Alias(agg.source(), temporaryName, null, (Expression)af, null, true);
                                attr = newAlias.toAttribute();
                                aggFuncToAttr.put((AggregateFunction)af, attr);
                                newAggs.add((NamedExpression)newAlias);
                            }
                            return attr;
                        });
                        Alias aliased = new Alias(agg.source(), agg.name(), null, surrogateWithRefs, agg.toAttribute().id());
                        transientEval.add(aliased);
                        continue;
                    }
                    newAggs.add((NamedExpression)agg.replaceChildren(Collections.singletonList(s)));
                    continue;
                }
                newAggs.add(agg);
            }
            Object plan = aggregate;
            if (changed) {
                Source source = aggregate.source();
                plan = !newAggs.isEmpty() ? new Aggregate(source, aggregate.child(), aggregate.groupings(), newAggs) : new LocalRelation(source, List.of(new EmptyAttribute(source)), LocalSupplier.of(new Block[]{BlockUtils.constantBlock((BlockFactory)PlannerUtils.NON_BREAKING_BLOCK_FACTORY, null, (int)1)}));
                if (!transientEval.isEmpty()) {
                    plan = new Eval(source, (LogicalPlan)plan, transientEval);
                    plan = new Project(source, (LogicalPlan)plan, Expressions.asAttributes((List)aggs));
                }
            }
            return plan;
        }

        static String temporaryName(Expression inner, Expression outer, int suffix) {
            String in = SubstituteSurrogates.toString(inner);
            String out = SubstituteSurrogates.toString(outer);
            return SubstituteSurrogates.rawTemporaryName(in, out, String.valueOf(suffix));
        }

        static String rawTemporaryName(String inner, String outer, String suffix) {
            return "$$" + inner + "$" + outer + "$" + suffix;
        }

        static String toString(Expression ex) {
            String string;
            if (ex instanceof AggregateFunction) {
                AggregateFunction af = (AggregateFunction)ex;
                string = af.functionName();
            } else {
                string = SubstituteSurrogates.extractString(ex);
            }
            return string;
        }

        static String extractString(Expression ex) {
            String string;
            if (ex instanceof NamedExpression) {
                NamedExpression ne = (NamedExpression)ex;
                string = ne.name();
            } else {
                string = SubstituteSurrogates.limitToString(ex.sourceText()).replace(' ', '_');
            }
            return string;
        }

        static String limitToString(String string) {
            return string.length() > 16 ? string.substring(0, TO_STRING_LIMIT - 1) + ">" : string;
        }
    }

    public static class ReplaceRegexMatch
    extends OptimizerRules.ReplaceRegexMatch {
        protected Expression regexToEquals(RegexMatch<?> regexMatch, Literal literal) {
            return new Equals(regexMatch.source(), regexMatch.field(), (Expression)literal);
        }
    }

    static class ReplaceAliasingEvalWithProject
    extends Rule<LogicalPlan, LogicalPlan> {
        ReplaceAliasingEvalWithProject() {
        }

        public LogicalPlan apply(LogicalPlan logicalPlan) {
            Holder enabled = new Holder((Object)false);
            return (LogicalPlan)logicalPlan.transformDown(p -> {
                if (p instanceof Aggregate || p instanceof Project) {
                    enabled.set((Object)true);
                } else if (((Boolean)enabled.get()).booleanValue() && p instanceof Eval) {
                    Eval eval = (Eval)((Object)p);
                    p = this.rule(eval);
                }
                return p;
            });
        }

        private LogicalPlan rule(Eval eval) {
            Eval plan = eval;
            AttributeMap basicAliases = new AttributeMap();
            AttributeMap basicAliasSources = new AttributeMap();
            ArrayList<Alias> keptFields = new ArrayList<Alias>();
            List<Alias> fields = eval.fields();
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                Alias field = fields.get(i);
                Expression child = field.child();
                Attribute attribute = field.toAttribute();
                if (child instanceof Attribute) {
                    basicAliases.put(attribute, (Object)child);
                    basicAliasSources.put(attribute, (Object)field);
                    continue;
                }
                if (basicAliases.size() > 0) {
                    field = (Alias)field.transformUp(e -> (Expression)basicAliases.resolve(e, e));
                }
                keptFields.add(field);
            }
            if (basicAliases.size() > 0) {
                ArrayList<Attribute> projections = new ArrayList<Attribute>(eval.output());
                for (int i = projections.size() - 1; i >= 0; --i) {
                    NamedExpression project = (NamedExpression)projections.get(i);
                    projections.set(i, (Attribute)((NamedExpression)basicAliasSources.getOrDefault((Object)project, (Object)project)));
                }
                Object child = eval.child();
                if (keptFields.size() > 0) {
                    child = new Eval(eval.source(), eval.child(), keptFields);
                }
                plan = new Project(eval.source(), child, projections);
            }
            return plan;
        }
    }

    static class SkipQueryOnEmptyMappings
    extends OptimizerRules.OptimizerRule<EsRelation> {
        SkipQueryOnEmptyMappings() {
        }

        protected LogicalPlan rule(EsRelation plan) {
            return plan.index().concreteIndices().isEmpty() ? new LocalRelation(plan.source(), plan.output(), LocalSupplier.EMPTY) : plan;
        }
    }

    static class SubstituteSpatialSurrogates
    extends OptimizerRules.OptimizerExpressionRule<SpatialRelatesFunction> {
        SubstituteSpatialSurrogates() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected SpatialRelatesFunction rule(SpatialRelatesFunction function) {
            return function.surrogate();
        }
    }

    static class ReplaceOrderByExpressionWithEval
    extends OptimizerRules.OptimizerRule<OrderBy> {
        private static int counter = 0;

        ReplaceOrderByExpressionWithEval() {
        }

        protected LogicalPlan rule(OrderBy orderBy) {
            int size = orderBy.order().size();
            ArrayList<Alias> evals = new ArrayList<Alias>(size);
            ArrayList<Order> newOrders = new ArrayList<Order>(size);
            for (int i = 0; i < size; ++i) {
                Order order = (Order)orderBy.order().get(i);
                if (!(order.child() instanceof Attribute)) {
                    String name = SubstituteSurrogates.rawTemporaryName("order_by", String.valueOf(i), String.valueOf(counter++));
                    Alias eval = new Alias(order.child().source(), name, order.child());
                    newOrders.add(order.replaceChildren(List.of(eval.toAttribute())));
                    evals.add(eval);
                    continue;
                }
                newOrders.add(order);
            }
            if (evals.isEmpty()) {
                return orderBy;
            }
            OrderBy newOrderBy = new OrderBy(orderBy.source(), (LogicalPlan)new Eval(orderBy.source(), orderBy.child(), evals), newOrders);
            return new Project(orderBy.source(), (LogicalPlan)newOrderBy, orderBy.output());
        }
    }

    static class CombineProjections
    extends OptimizerRules.OptimizerRule<UnaryPlan> {
        CombineProjections() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected LogicalPlan rule(UnaryPlan plan) {
            LogicalPlan child = plan.child();
            if (plan instanceof Project) {
                Project project = (Project)plan;
                if (child instanceof Project) {
                    Project p = (Project)child;
                    project = p.withProjections(CombineProjections.combineProjections(project.projections(), p.projections()));
                    child = project.child();
                    plan = project;
                }
                if (child instanceof Aggregate) {
                    Aggregate a = (Aggregate)child;
                    List aggs = a.aggregates();
                    List<? extends NamedExpression> newAggs = CombineProjections.projectAggregations(project.projections(), aggs);
                    if (newAggs != null) {
                        List<Expression> newGroups = this.replacePrunedAliasesUsedInGroupBy(a.groupings(), aggs, newAggs);
                        plan = new Aggregate(a.source(), a.child(), newGroups, newAggs);
                    }
                }
                return plan;
            }
            if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                if (child instanceof Project) {
                    Project p = (Project)child;
                    List groupings = a.groupings();
                    ArrayList<Attribute> groupingAttrs = new ArrayList<Attribute>(a.groupings().size());
                    for (Expression grouping : groupings) {
                        if (grouping instanceof Attribute) {
                            Attribute attribute = (Attribute)grouping;
                            groupingAttrs.add(attribute);
                            continue;
                        }
                        throw new EsqlIllegalArgumentException("Expected an Attribute, got {}", grouping);
                    }
                    plan = new Aggregate(a.source(), p.child(), CombineProjections.combineUpperGroupingsAndLowerProjections(groupingAttrs, p.projections()), CombineProjections.combineProjections(a.aggregates(), p.projections()));
                }
            }
            return plan;
        }

        private static List<? extends NamedExpression> projectAggregations(List<? extends NamedExpression> upperProjection, List<? extends NamedExpression> lowerAggregations) {
            AttributeSet seen = new AttributeSet();
            for (NamedExpression namedExpression : upperProjection) {
                Expression unwrapped = Alias.unwrap((Expression)namedExpression);
                if (seen.contains((Object)unwrapped)) {
                    return null;
                }
                seen.add(Expressions.attribute((Expression)unwrapped));
            }
            lowerAggregations = CombineProjections.combineProjections(upperProjection, lowerAggregations);
            return lowerAggregations;
        }

        private static List<NamedExpression> combineProjections(List<? extends NamedExpression> upper, List<? extends NamedExpression> lower) {
            AttributeMap namedExpressions = new AttributeMap();
            AttributeMap aliases = new AttributeMap();
            for (NamedExpression namedExpression : lower) {
                aliases.put(namedExpression.toAttribute(), (Object)Alias.unwrap((Expression)namedExpression));
                if (!(namedExpression instanceof Alias)) continue;
                Alias alias = (Alias)namedExpression;
                Expression child = alias.child();
                namedExpressions.put(namedExpression.toAttribute(), (Object)alias.replaceChild((Expression)aliases.resolve((Object)child, (Object)child)));
            }
            ArrayList<NamedExpression> replaced = new ArrayList<NamedExpression>();
            for (NamedExpression namedExpression : upper) {
                NamedExpression replacedExp = (NamedExpression)namedExpression.transformUp(Attribute.class, a -> (Expression)namedExpressions.resolve(a, a));
                replaced.add((NamedExpression)CombineProjections.trimNonTopLevelAliases((Expression)replacedExp));
            }
            return replaced;
        }

        private static List<Expression> combineUpperGroupingsAndLowerProjections(List<? extends Attribute> upperGroupings, List<? extends NamedExpression> lowerProjections) {
            AttributeMap aliases = new AttributeMap();
            for (NamedExpression namedExpression : lowerProjections) {
                aliases.put(namedExpression.toAttribute(), (Object)((Attribute)Alias.unwrap((Expression)namedExpression)));
            }
            AttributeSet replaced = new AttributeSet();
            for (Attribute attribute : upperGroupings) {
                replaced.add((Attribute)aliases.resolve((Object)attribute, (Object)attribute));
            }
            return new ArrayList<Expression>((Collection<Expression>)replaced);
        }

        private List<Expression> replacePrunedAliasesUsedInGroupBy(List<Expression> groupings, List<? extends NamedExpression> oldAggs, List<? extends NamedExpression> newAggs) {
            AttributeMap removedAliases = new AttributeMap();
            AttributeSet currentAliases = new AttributeSet((Collection)Expressions.asAttributes(newAggs));
            for (NamedExpression namedExpression : oldAggs) {
                if (!(namedExpression instanceof Alias)) continue;
                Alias alias = (Alias)namedExpression;
                Attribute attr = namedExpression.toAttribute();
                if (currentAliases.contains((Object)attr)) continue;
                removedAliases.put(attr, (Object)alias.child());
            }
            if (removedAliases.isEmpty()) {
                return groupings;
            }
            ArrayList<Expression> newGroupings = new ArrayList<Expression>(groupings.size());
            for (Expression group : groupings) {
                Expression transformed = (Expression)group.transformUp(Attribute.class, a -> (Expression)removedAliases.resolve(a, a));
                if (Expressions.anyMatch(newGroupings, g -> Expressions.equalsAsAttribute((Expression)g, (Expression)transformed))) continue;
                newGroupings.add(transformed);
            }
            return newGroupings;
        }

        public static Expression trimNonTopLevelAliases(Expression e) {
            Expression expression;
            if (e instanceof Alias) {
                Alias a = (Alias)e;
                expression = a.replaceChild(CombineProjections.trimAliases(a.child()));
            } else {
                expression = CombineProjections.trimAliases(e);
            }
            return expression;
        }

        private static Expression trimAliases(Expression e) {
            return (Expression)e.transformDown(Alias.class, Alias::child);
        }
    }

    static class CombineEvals
    extends OptimizerRules.OptimizerRule<Eval> {
        CombineEvals() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected LogicalPlan rule(Eval eval) {
            Eval plan = eval;
            LogicalPlan logicalPlan = eval.child();
            if (logicalPlan instanceof Eval) {
                Eval subEval = (Eval)logicalPlan;
                plan = new Eval(eval.source(), subEval.child(), CollectionUtils.combine(subEval.fields(), eval.fields()));
            }
            return plan;
        }
    }

    static class PruneEmptyPlans
    extends OptimizerRules.OptimizerRule<UnaryPlan> {
        PruneEmptyPlans() {
        }

        protected LogicalPlan rule(UnaryPlan plan) {
            return plan.output().isEmpty() ? LogicalPlanOptimizer.skipPlan(plan) : plan;
        }
    }

    static class PropagateEmptyRelation
    extends OptimizerRules.OptimizerRule<UnaryPlan> {
        PropagateEmptyRelation() {
        }

        protected LogicalPlan rule(UnaryPlan plan) {
            LocalRelation local;
            UnaryPlan p = plan;
            LogicalPlan logicalPlan = plan.child();
            if (logicalPlan instanceof LocalRelation && (local = (LocalRelation)logicalPlan).supplier() == LocalSupplier.EMPTY) {
                Aggregate agg;
                if (plan instanceof Aggregate && (agg = (Aggregate)plan).groupings().isEmpty()) {
                    List<Block> emptyBlocks = this.aggsFromEmpty(agg.aggregates());
                    p = LogicalPlanOptimizer.skipPlan(plan, LocalSupplier.of((Block[])emptyBlocks.toArray(Block[]::new)));
                } else {
                    p = LogicalPlanOptimizer.skipPlan(plan);
                }
            }
            return p;
        }

        private List<Block> aggsFromEmpty(List<? extends NamedExpression> aggs) {
            ArrayList<Block> blocks = new ArrayList<Block>();
            BlockFactory blockFactory = PlannerUtils.NON_BREAKING_BLOCK_FACTORY;
            boolean i = false;
            for (NamedExpression namedExpression : aggs) {
                Expression expression = Alias.unwrap((Expression)namedExpression);
                if (expression instanceof AggregateFunction) {
                    AggregateFunction aggFunc = (AggregateFunction)expression;
                    this.aggOutput(namedExpression, aggFunc, blockFactory, blocks);
                    continue;
                }
                throw new EsqlIllegalArgumentException("Did not expect a non-aliased aggregation {}", namedExpression);
            }
            return blocks;
        }

        protected void aggOutput(NamedExpression agg, AggregateFunction aggFunc, BlockFactory blockFactory, List<Block> blocks) {
            Count count;
            Long value = aggFunc instanceof Count && (!(count = (Count)aggFunc).foldable() || count.fold() != null) ? Long.valueOf(0L) : null;
            BlockUtils.BuilderWrapper wrapper = BlockUtils.wrapperFor((BlockFactory)blockFactory, (ElementType)PlannerUtils.toElementType(aggFunc.dataType()), (int)1);
            wrapper.accept((Object)value);
            blocks.add(wrapper.builder().build());
        }
    }

    static class ConvertStringToByteRef
    extends OptimizerRules.OptimizerExpressionRule<Literal> {
        ConvertStringToByteRef() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected Expression rule(Literal lit) {
            Object value = lit.value();
            if (value == null) {
                return lit;
            }
            if (value instanceof String) {
                String s = (String)value;
                return Literal.of((Expression)lit, (Object)new BytesRef((CharSequence)s));
            }
            if (value instanceof List) {
                List l = (List)value;
                if (l.isEmpty() || !(l.get(0) instanceof String)) {
                    return lit;
                }
                ArrayList<BytesRef> byteRefs = new ArrayList<BytesRef>(l.size());
                for (Object v : l) {
                    byteRefs.add(new BytesRef((CharSequence)v.toString()));
                }
                return Literal.of((Expression)lit, byteRefs);
            }
            return lit;
        }
    }

    public static class FoldNull
    extends OptimizerRules.FoldNull {
        protected Expression tryReplaceIsNullIsNotNull(Expression e) {
            return e;
        }
    }

    public static class SplitInWithFoldableValue
    extends OptimizerRules.OptimizerExpressionRule<In> {
        SplitInWithFoldableValue() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected Expression rule(In in) {
            if (in.value().foldable()) {
                ArrayList<Expression> foldables = new ArrayList<Expression>(in.list().size());
                ArrayList<Expression> nonFoldables = new ArrayList<Expression>(in.list().size());
                in.list().forEach(e -> {
                    if (e.foldable() && !Expressions.isNull((Expression)e)) {
                        foldables.add((Expression)e);
                    } else {
                        nonFoldables.add((Expression)e);
                    }
                });
                if (foldables.size() > 0 && nonFoldables.size() > 0) {
                    In withFoldables = new In(in.source(), in.value(), foldables);
                    In withoutFoldables = new In(in.source(), in.value(), nonFoldables);
                    return new Or(in.source(), (Expression)withFoldables, (Expression)withoutFoldables);
                }
            }
            return in;
        }
    }

    static class PropagateEvalFoldables
    extends Rule<LogicalPlan, LogicalPlan> {
        PropagateEvalFoldables() {
        }

        public LogicalPlan apply(LogicalPlan plan) {
            AttributeMap collectRefs = new AttributeMap();
            Function<ReferenceAttribute, Expression> replaceReference = r -> (Expression)collectRefs.resolve(r, r);
            plan.forEachExpressionUp(Alias.class, a -> {
                Expression c = a.child();
                boolean shouldCollect = c.foldable();
                if (!shouldCollect) {
                    c = (Expression)c.transformUp(ReferenceAttribute.class, replaceReference);
                    shouldCollect = c.foldable();
                }
                if (shouldCollect) {
                    collectRefs.put(a.toAttribute(), (Object)Literal.of((Expression)c));
                }
            });
            if (collectRefs.isEmpty()) {
                return plan;
            }
            plan = (LogicalPlan)plan.transformUp(p -> {
                if (p instanceof Filter || p instanceof Eval) {
                    p = (LogicalPlan)p.transformExpressionsOnly(ReferenceAttribute.class, replaceReference);
                }
                return p;
            });
            return plan;
        }
    }

    static class PartiallyFoldCase
    extends OptimizerRules.OptimizerExpressionRule<Case> {
        PartiallyFoldCase() {
            super(OptimizerRules.TransformDirection.DOWN);
        }

        protected Expression rule(Case c) {
            return c.partiallyFold();
        }
    }

    private static class BooleanSimplification
    extends OptimizerRules.BooleanSimplification {
        BooleanSimplification() {
        }

        protected Expression maybeSimplifyNegatable(Expression e) {
            return null;
        }
    }

    public static class PropagateNullable
    extends OptimizerRules.PropagateNullable {
        protected Expression nullify(Expression exp, Expression nullExp) {
            if (exp instanceof Coalesce) {
                ArrayList<Expression> newChildren = new ArrayList<Expression>(exp.children());
                newChildren.removeIf(e -> e.semanticEquals(nullExp));
                if (newChildren.size() != exp.children().size() && newChildren.size() > 0) {
                    return (Expression)exp.replaceChildren(newChildren);
                }
            }
            return Literal.of((Expression)exp, null);
        }
    }

    static class PruneFilters
    extends OptimizerRules.PruneFilters {
        PruneFilters() {
        }

        protected LogicalPlan skipPlan(Filter filter) {
            return LogicalPlanOptimizer.skipPlan((UnaryPlan)filter);
        }
    }

    static class PruneColumns
    extends Rule<LogicalPlan, LogicalPlan> {
        PruneColumns() {
        }

        public LogicalPlan apply(LogicalPlan plan) {
            AttributeSet used = new AttributeSet();
            Holder seenProjection = new Holder((Object)Boolean.FALSE);
            LogicalPlan pl = (LogicalPlan)plan.transformDown(p -> {
                boolean recheck;
                if (p instanceof Limit) {
                    return p;
                }
                do {
                    List<Alias> remaining;
                    recheck = false;
                    if (p instanceof Aggregate) {
                        Aggregate aggregate = (Aggregate)p;
                        List<Alias> list = remaining = (Boolean)seenProjection.get() != false ? PruneColumns.removeUnused(aggregate.aggregates(), used) : null;
                        if (remaining != null) {
                            if (remaining.isEmpty()) {
                                if (aggregate.groupings().isEmpty()) {
                                    p = new LocalRelation(aggregate.source(), List.of(new EmptyAttribute(aggregate.source())), LocalSupplier.of(new Block[]{BlockUtils.constantBlock((BlockFactory)PlannerUtils.NON_BREAKING_BLOCK_FACTORY, null, (int)1)}));
                                } else {
                                    remaining = List.of(Expressions.attribute((Expression)((Expression)aggregate.groupings().get(0))));
                                    p = new Aggregate(aggregate.source(), aggregate.child(), aggregate.groupings(), remaining);
                                }
                            } else {
                                p = new Aggregate(aggregate.source(), aggregate.child(), aggregate.groupings(), remaining);
                            }
                        }
                        seenProjection.set((Object)Boolean.TRUE);
                        continue;
                    }
                    if (p instanceof Eval) {
                        Eval eval = (Eval)((Object)((Object)p));
                        List<Alias> list = remaining = (Boolean)seenProjection.get() != false ? PruneColumns.removeUnused(eval.fields(), used) : null;
                        if (remaining == null) continue;
                        if (remaining.isEmpty()) {
                            p = eval.child();
                            recheck = true;
                            continue;
                        }
                        p = new Eval(eval.source(), eval.child(), remaining);
                        continue;
                    }
                    if (!(p instanceof Project)) continue;
                    seenProjection.set((Object)Boolean.TRUE);
                } while (recheck);
                used.addAll(p.references());
                return p;
            });
            return pl;
        }

        private static <N extends NamedExpression> List<N> removeUnused(List<N> named, AttributeSet used) {
            ArrayList<N> clone = new ArrayList<N>(named);
            ListIterator<N> it = clone.listIterator(clone.size());
            while (it.hasPrevious()) {
                NamedExpression prev = (NamedExpression)it.previous();
                if (!used.contains((Object)prev.toAttribute())) {
                    it.remove();
                    continue;
                }
                used.addAll(prev.references());
            }
            return clone.size() != named.size() ? clone : null;
        }
    }

    static class PushDownAndCombineLimits
    extends OptimizerRules.OptimizerRule<Limit> {
        PushDownAndCombineLimits() {
        }

        protected LogicalPlan rule(Limit limit) {
            LogicalPlan limitSource;
            LogicalPlan logicalPlan = limit.child();
            if (logicalPlan instanceof Limit) {
                Limit childLimit = (Limit)logicalPlan;
                limitSource = limit.limit();
                int l1 = (Integer)limitSource.fold();
                int l2 = (Integer)childLimit.limit().fold();
                return new Limit(limit.source(), (Expression)Literal.of((Expression)limitSource, (Object)Math.min(l1, l2)), childLimit.child());
            }
            limitSource = limit.child();
            if (limitSource instanceof UnaryPlan) {
                UnaryPlan unary = (UnaryPlan)limitSource;
                if (unary instanceof Eval || unary instanceof Project || unary instanceof RegexExtract || unary instanceof Enrich) {
                    return unary.replaceChild((LogicalPlan)limit.replaceChild(unary.child()));
                }
                Limit descendantLimit = PushDownAndCombineLimits.descendantLimit(unary);
                if (descendantLimit != null) {
                    int l1 = (Integer)limit.limit().fold();
                    int l2 = (Integer)descendantLimit.limit().fold();
                    if (l2 <= l1) {
                        return new Limit(limit.source(), (Expression)Literal.of((Expression)limit.limit(), (Object)l2), limit.child());
                    }
                }
            }
            return limit;
        }

        private static Limit descendantLimit(UnaryPlan unary) {
            UnaryPlan plan = unary;
            while (!(plan instanceof Aggregate)) {
                UnaryPlan unaryPlan;
                if (plan instanceof Limit) {
                    Limit limit = (Limit)plan;
                    return limit;
                }
                if (plan instanceof MvExpand) {
                    return null;
                }
                LogicalPlan logicalPlan = plan.child();
                if (!(logicalPlan instanceof UnaryPlan)) break;
                plan = unaryPlan = (UnaryPlan)logicalPlan;
            }
            return null;
        }
    }

    static class DuplicateLimitAfterMvExpand
    extends OptimizerRules.OptimizerRule<Limit> {
        DuplicateLimitAfterMvExpand() {
        }

        protected LogicalPlan rule(Limit limit) {
            Limit limitBeforeMvExpand;
            UnaryPlan unary;
            MvExpand mvExpand;
            boolean shouldSkip;
            LogicalPlan child = limit.child();
            boolean bl = shouldSkip = child instanceof Eval || child instanceof Project || child instanceof RegexExtract || child instanceof Enrich || child instanceof Limit;
            if (!shouldSkip && child instanceof UnaryPlan && (mvExpand = DuplicateLimitAfterMvExpand.descendantMvExpand(unary = (UnaryPlan)child)) != null && (limitBeforeMvExpand = DuplicateLimitAfterMvExpand.limitBeforeMvExpand(mvExpand)) == null) {
                Limit duplicateLimit = new Limit(limit.source(), limit.limit(), mvExpand.child());
                return limit.replaceChild(this.propagateDuplicateLimitUntilMvExpand(duplicateLimit, mvExpand, unary));
            }
            return limit;
        }

        private static MvExpand descendantMvExpand(UnaryPlan unary) {
            UnaryPlan plan = unary;
            AttributeSet filterReferences = new AttributeSet();
            while (!(plan instanceof Aggregate)) {
                UnaryPlan unaryPlan;
                if (plan instanceof MvExpand) {
                    MvExpand mve = (MvExpand)plan;
                    if (!filterReferences.isEmpty() && (filterReferences.contains((Object)mve.target()) || mve.target() instanceof ReferenceAttribute || filterReferences.stream().anyMatch(ref -> ref instanceof ReferenceAttribute))) {
                        return null;
                    }
                    return mve;
                }
                if (plan instanceof Filter) {
                    Filter filter = (Filter)plan;
                    filterReferences.addAll(filter.references());
                } else if (plan instanceof OrderBy) {
                    return null;
                }
                LogicalPlan logicalPlan = plan.child();
                if (!(logicalPlan instanceof UnaryPlan)) break;
                plan = unaryPlan = (UnaryPlan)logicalPlan;
            }
            return null;
        }

        private static Limit limitBeforeMvExpand(MvExpand mvExpand) {
            MvExpand plan = mvExpand;
            while (!(plan instanceof Aggregate)) {
                if (plan instanceof Limit) {
                    Limit limit = (Limit)plan;
                    return limit;
                }
                LogicalPlan logicalPlan = plan.child();
                if (!(logicalPlan instanceof UnaryPlan)) break;
                UnaryPlan unaryPlan = (UnaryPlan)logicalPlan;
                plan = unaryPlan;
            }
            return null;
        }

        private LogicalPlan propagateDuplicateLimitUntilMvExpand(Limit duplicateLimit, MvExpand mvExpand, UnaryPlan child) {
            if (child == mvExpand) {
                return mvExpand.replaceChild((LogicalPlan)duplicateLimit);
            }
            return child.replaceChild(this.propagateDuplicateLimitUntilMvExpand(duplicateLimit, mvExpand, (UnaryPlan)child.child()));
        }
    }

    protected static class PushDownAndCombineFilters
    extends OptimizerRules.OptimizerRule<Filter> {
        protected PushDownAndCombineFilters() {
        }

        protected LogicalPlan rule(Filter filter) {
            Filter plan = filter;
            LogicalPlan child = filter.child();
            Expression condition = filter.condition();
            if (child instanceof Filter) {
                Filter f = (Filter)child;
                plan = f.with(Predicates.combineAnd(List.of(f.condition(), condition)));
            } else if (child instanceof Aggregate) {
                Aggregate agg = (Aggregate)child;
                plan = PushDownAndCombineFilters.maybePushDownPastUnary(filter, (UnaryPlan)agg, e -> e instanceof Attribute && agg.output().contains(e) && !agg.groupings().contains(e) || e instanceof AggregateFunction);
            } else if (child instanceof Eval) {
                Eval eval = (Eval)child;
                AttributeSet attributes = new AttributeSet((Collection)Expressions.asAttributes(eval.fields()));
                plan = PushDownAndCombineFilters.maybePushDownPastUnary(filter, eval, arg_0 -> ((AttributeSet)attributes).contains(arg_0));
            } else if (child instanceof RegexExtract) {
                RegexExtract re = (RegexExtract)child;
                AttributeSet attributes = new AttributeSet((Collection)Expressions.asAttributes(re.extractedFields()));
                plan = PushDownAndCombineFilters.maybePushDownPastUnary(filter, re, arg_0 -> ((AttributeSet)attributes).contains(arg_0));
            } else if (child instanceof Enrich) {
                Enrich enrich = (Enrich)child;
                AttributeSet attributes = new AttributeSet((Collection)Expressions.asAttributes(enrich.enrichFields()));
                plan = PushDownAndCombineFilters.maybePushDownPastUnary(filter, enrich, arg_0 -> ((AttributeSet)attributes).contains(arg_0));
            } else {
                if (child instanceof Project) {
                    return LogicalPlanOptimizer.pushDownPastProject((UnaryPlan)filter);
                }
                if (child instanceof OrderBy) {
                    OrderBy orderBy = (OrderBy)child;
                    plan = orderBy.replaceChild((LogicalPlan)filter.with(orderBy.child(), condition));
                }
            }
            return plan;
        }

        private static LogicalPlan maybePushDownPastUnary(Filter filter, UnaryPlan unary, Predicate<Expression> cannotPush) {
            Filter plan;
            ArrayList pushable = new ArrayList();
            ArrayList<Expression> nonPushable = new ArrayList<Expression>();
            for (Expression exp : Predicates.splitAnd((Expression)filter.condition())) {
                (exp.anyMatch(cannotPush) ? nonPushable : pushable).add(exp);
            }
            if (pushable.size() > 0) {
                if (nonPushable.size() > 0) {
                    Filter pushed = new Filter(filter.source(), unary.child(), Predicates.combineAnd(pushable));
                    plan = filter.with((LogicalPlan)unary.replaceChild((LogicalPlan)pushed), Predicates.combineAnd(nonPushable));
                } else {
                    plan = unary.replaceChild((LogicalPlan)filter.with(unary.child(), filter.condition()));
                }
            } else {
                plan = filter;
            }
            return plan;
        }
    }

    protected static class PushDownEval
    extends OptimizerRules.OptimizerRule<Eval> {
        protected PushDownEval() {
        }

        protected LogicalPlan rule(Eval eval) {
            return LogicalPlanOptimizer.pushGeneratingPlanPastProjectAndOrderBy(eval, Expressions.asAttributes(eval.fields()));
        }
    }

    protected static class PushDownRegexExtract
    extends OptimizerRules.OptimizerRule<RegexExtract> {
        protected PushDownRegexExtract() {
        }

        protected LogicalPlan rule(RegexExtract re) {
            return LogicalPlanOptimizer.pushGeneratingPlanPastProjectAndOrderBy(re, re.extractedFields());
        }
    }

    protected static class PushDownEnrich
    extends OptimizerRules.OptimizerRule<Enrich> {
        protected PushDownEnrich() {
        }

        protected LogicalPlan rule(Enrich en) {
            return LogicalPlanOptimizer.pushGeneratingPlanPastProjectAndOrderBy(en, Expressions.asAttributes(en.enrichFields()));
        }
    }

    protected static class PushDownAndCombineOrderBy
    extends OptimizerRules.OptimizerRule<OrderBy> {
        protected PushDownAndCombineOrderBy() {
        }

        protected LogicalPlan rule(OrderBy orderBy) {
            LogicalPlan child = orderBy.child();
            if (child instanceof OrderBy) {
                OrderBy childOrder = (OrderBy)child;
                return new OrderBy(orderBy.source(), childOrder.child(), orderBy.order());
            }
            if (child instanceof Project) {
                return LogicalPlanOptimizer.pushDownPastProject((UnaryPlan)orderBy);
            }
            return orderBy;
        }
    }

    static class PruneOrderByBeforeStats
    extends OptimizerRules.OptimizerRule<Aggregate> {
        PruneOrderByBeforeStats() {
        }

        protected LogicalPlan rule(Aggregate agg) {
            OrderBy order = PruneOrderByBeforeStats.findPullableOrderBy(agg.child());
            Aggregate p = agg;
            if (order != null) {
                p = (LogicalPlan)agg.transformDown(OrderBy.class, o -> o == order ? order.child() : o);
            }
            return p;
        }

        private static OrderBy findPullableOrderBy(LogicalPlan plan) {
            OrderBy pullable = null;
            if (plan instanceof OrderBy) {
                OrderBy o;
                pullable = o = (OrderBy)plan;
            } else if (plan instanceof Eval || plan instanceof Filter || plan instanceof Project || plan instanceof RegexExtract || plan instanceof Enrich) {
                pullable = PruneOrderByBeforeStats.findPullableOrderBy(((UnaryPlan)plan).child());
            }
            return pullable;
        }
    }

    static class PruneRedundantSortClauses
    extends OptimizerRules.OptimizerRule<OrderBy> {
        PruneRedundantSortClauses() {
        }

        protected LogicalPlan rule(OrderBy plan) {
            ExpressionSet referencedAttributes = new ExpressionSet();
            ArrayList<Order> order = new ArrayList<Order>();
            for (Order o : plan.order()) {
                if (!referencedAttributes.add((Expression)o)) continue;
                order.add(o);
            }
            return plan.order().size() == order.size() ? plan : new OrderBy(plan.source(), plan.child(), order);
        }
    }

    static class ReplaceLimitAndSortAsTopN
    extends OptimizerRules.OptimizerRule<Limit> {
        ReplaceLimitAndSortAsTopN() {
        }

        protected LogicalPlan rule(Limit plan) {
            Object p = plan;
            LogicalPlan logicalPlan = plan.child();
            if (logicalPlan instanceof OrderBy) {
                OrderBy o = (OrderBy)logicalPlan;
                p = new TopN(plan.source(), o.child(), o.order(), plan.limit());
            }
            return p;
        }
    }

    static class SkipQueryOnLimitZero
    extends OptimizerRules.SkipQueryOnLimitZero {
        SkipQueryOnLimitZero() {
        }

        protected LogicalPlan skipPlan(Limit limit) {
            return LogicalPlanOptimizer.skipPlan((UnaryPlan)limit);
        }
    }

    static class AddDefaultTopN
    extends ParameterizedOptimizerRule<LogicalPlan, LogicalOptimizerContext> {
        AddDefaultTopN() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan, LogicalOptimizerContext context) {
            OrderBy order;
            UnaryPlan unary;
            LogicalPlan logicalPlan;
            if (plan instanceof UnaryPlan && (logicalPlan = (unary = (UnaryPlan)plan).child()) instanceof OrderBy && (logicalPlan = (order = (OrderBy)logicalPlan).child()) instanceof EsRelation) {
                EsRelation relation = (EsRelation)logicalPlan;
                Literal limit = new Literal(plan.source(), (Object)context.configuration().resultTruncationMaxSize(), DataTypes.INTEGER);
                return unary.replaceChild((LogicalPlan)new TopN(plan.source(), (LogicalPlan)relation, order.order(), (Expression)limit));
            }
            return plan;
        }
    }

    private record AttributeReplacement(List<Expression> rewrittenExpressions, AttributeMap<Alias> replacedAttributes) {
    }

    static class NormalizeAggregate
    extends Rule<LogicalPlan, LogicalPlan> {
        NormalizeAggregate() {
        }

        public LogicalPlan apply(LogicalPlan plan) {
            AttributeMap aliases = new AttributeMap();
            plan = (LogicalPlan)plan.transformUp(p -> {
                if (p instanceof Aggregate) {
                    Aggregate agg = (Aggregate)p;
                    p = NormalizeAggregate.normalize(agg, (AttributeMap<Expression>)aliases);
                }
                p.forEachExpression(Alias.class, a -> {
                    Expression child = a.child();
                    if (child.foldable() || child instanceof NamedExpression) {
                        aliases.putIfAbsent((Object)a.toAttribute(), (Object)child);
                    }
                });
                return p;
            });
            return plan;
        }

        private static LogicalPlan normalize(Aggregate aggregate, AttributeMap<Expression> aliases) {
            List aggs = aggregate.aggregates();
            ArrayList<NamedExpression> newAggs = new ArrayList<NamedExpression>(aggs.size());
            Holder changed = new Holder((Object)false);
            for (NamedExpression agg : aggs) {
                NamedExpression newAgg = (NamedExpression)agg.transformDown(AggregateFunction.class, af -> {
                    NamedExpression ne;
                    Attribute attr;
                    Expression resolved;
                    Expression patt79165$temp = af.field();
                    if (patt79165$temp instanceof NamedExpression && (resolved = (Expression)aliases.resolve((Object)(attr = (ne = (NamedExpression)patt79165$temp).toAttribute()), (Object)attr)) != attr) {
                        changed.set((Object)true);
                        List newChildren = CollectionUtils.combine(Collections.singletonList(resolved), (List)af.parameters());
                        af = (AggregateFunction)af.replaceChildren(newChildren);
                    }
                    if (af instanceof Count) {
                        Object fold;
                        Count count = (Count)af;
                        Expression field = af.field();
                        if (field.foldable() && (fold = field.fold()) != null && !"*".equals(fold)) {
                            changed.set((Object)true);
                            Source source = count.source();
                            af = new Count(source, (Expression)new Literal(source, (Object)"*", DataTypes.KEYWORD));
                        }
                    }
                    return af;
                });
                newAggs.add(newAgg);
            }
            return (Boolean)changed.get() != false ? new Aggregate(aggregate.source(), aggregate.child(), aggregate.groupings(), newAggs) : aggregate;
        }
    }

    private static abstract class ParameterizedOptimizerRule<SubPlan extends LogicalPlan, P>
    extends ParameterizedRule<SubPlan, LogicalPlan, P> {
        private ParameterizedOptimizerRule() {
        }

        public final LogicalPlan apply(LogicalPlan plan, P context) {
            return (LogicalPlan)plan.transformDown(this.typeToken(), t -> this.rule(t, context));
        }

        protected abstract LogicalPlan rule(SubPlan var1, P var2);
    }
}

